/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.resource;

import jdk.management.resource.ResourceApprover;
import jdk.management.resource.ResourceId;
import jdk.management.resource.ResourceRequest;
import jdk.management.resource.ResourceType;
import jdk.management.resource.SimpleMeter;
import jdk.management.resource.internal.ResourceIdImpl;

public class NotifyingMeter
extends SimpleMeter {
    private final ResourceApprover approver;
    private long granularity;

    public static NotifyingMeter create(ResourceType resourceType, ResourceApprover resourceApprover) {
        return new NotifyingMeter(resourceType, null, resourceApprover);
    }

    public static NotifyingMeter create(ResourceType resourceType, ResourceRequest resourceRequest, ResourceApprover resourceApprover) {
        return new NotifyingMeter(resourceType, resourceRequest, resourceApprover);
    }

    protected NotifyingMeter(ResourceType resourceType, ResourceRequest resourceRequest, ResourceApprover resourceApprover) {
        super(resourceType, resourceRequest);
        this.approver = resourceApprover;
        this.granularity = 1L;
    }

    @Override
    protected long validate(long l, long l2, ResourceId resourceId) {
        long l3;
        long l4;
        long l5 = l2;
        if (this.approver != null && ((l4 = Math.floorDiv(l, this.granularity)) != (l3 = Math.floorDiv(l + l2, this.granularity)) || l2 == 0L && resourceId != null && resourceId instanceof ResourceIdImpl && ((ResourceIdImpl)resourceId).isForcedUpdate()) && (l5 = this.approver.request(this, l, l2, resourceId)) != l2 && l5 != 0L) {
            l5 = l2;
        }
        return l5;
    }

    public final synchronized long getGranularity() {
        return this.granularity;
    }

    public final long setGranularity(long l) {
        return this.setGranularityInternal(l);
    }

    synchronized long setGranularityInternal(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("granularity must be greater than zero");
        }
        long l2 = this.granularity;
        this.granularity = l;
        return l2;
    }

    public final ResourceApprover getApprover() {
        return this.approver;
    }
}

