/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.hyperic.hq.product.MeasurementInfo;
import org.hyperic.util.config.EncodingException;
import org.hyperic.util.config.InvalidOptionException;
import org.hyperic.util.config.InvalidOptionValueException;

public class MeasurementInfos {
    private Set measurements = new HashSet();

    public static MeasurementInfos decode(byte[] data) throws EncodingException, InvalidOptionException, InvalidOptionValueException {
        try {
            MeasurementInfo measurementInfo;
            ByteArrayInputStream byteStream = new ByteArrayInputStream(data);
            ObjectInputStream objectStream = new ObjectInputStream(byteStream);
            MeasurementInfos measurements = new MeasurementInfos();
            while ((measurementInfo = (MeasurementInfo)objectStream.readObject()) != null) {
                measurements.addMeasurementInfo(measurementInfo);
            }
            return measurements;
        }
        catch (IOException exc) {
            throw new EncodingException(exc.toString());
        }
        catch (ClassNotFoundException exc) {
            throw new EncodingException(exc.toString());
        }
    }

    public void addMeasurementInfo(MeasurementInfo measurement) {
        this.measurements.add(measurement);
    }

    public byte[] encode() throws EncodingException {
        ObjectOutputStream objectStream = null;
        byte[] retVal = null;
        try {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            objectStream = new ObjectOutputStream(byteStream);
            Iterator iterator = this.measurements.iterator();
            while (iterator.hasNext()) {
                objectStream.writeObject((MeasurementInfo)iterator.next());
            }
            objectStream.writeObject(null);
            objectStream.flush();
            retVal = byteStream.toByteArray();
        }
        catch (IOException exc) {
            throw new EncodingException(exc.toString());
        }
        finally {
            if (objectStream != null) {
                try {
                    objectStream.close();
                }
                catch (Exception ex) {}
            }
        }
        return retVal;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        return this.getMeasurementNames().equals(((MeasurementInfos)obj).getMeasurementNames());
    }

    public Set getMeasurementNames() {
        HashSet<String> measurementNames = new HashSet<String>();
        Iterator iterator = this.getMeasurements().iterator();
        while (iterator.hasNext()) {
            measurementNames.add(((MeasurementInfo)iterator.next()).getName());
        }
        return measurementNames;
    }

    public MeasurementInfo getMeasurement(String name) {
        for (MeasurementInfo measurement : this.getMeasurements()) {
            if (!measurement.getName().equals(name)) continue;
            return measurement;
        }
        return null;
    }

    public Set getMeasurements() {
        return this.measurements;
    }

    public int hashCode() {
        return this.getMeasurementNames().hashCode();
    }

    public String toString() {
        StringBuilder measurementString = new StringBuilder("MeasurementInfos[measurementNames=").append(this.getMeasurementNames()).append("]");
        return measurementString.toString();
    }
}

