/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.agent.server;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentConfig;
import org.hyperic.hq.agent.server.AgentDaemon;
import org.hyperic.hq.agent.server.AgentStorageProvider;
import org.hyperic.hq.agent.server.AgentTransportLifecycle;
import org.hyperic.hq.agent.server.ShouldShutdownGracefully;
import org.hyperic.hq.bizapp.agent.CommandsAPIInfo;
import org.hyperic.hq.bizapp.agent.ProviderInfo;
import org.hyperic.hq.bizapp.client.AgentCallbackClient;
import org.hyperic.hq.transport.AgentTransport;
import org.hyperic.hq.util.properties.PropertiesUtil;

public final class AgentTransportLifecycleImpl
implements AgentTransportLifecycle {
    private static final Log _log = LogFactory.getLog(AgentTransportLifecycleImpl.class);
    private static final String REMOTE_TRANSPORT_LOCATOR_PATH = "ServerInvokerServlet";
    private final AgentDaemon _agent;
    private final AgentConfig _config;
    private final AgentStorageProvider _storageProvider;
    private final Map _serviceInterfaceName2ServiceInterface;
    private final Map _serviceInterface2ServiceImpl;
    private final Set<ShouldShutdownGracefully> _serviceInterface2WaitAtGracefullStop;
    private AgentTransport _agentTransport;

    public AgentTransportLifecycleImpl(AgentDaemon agent, AgentConfig bootConfig, AgentStorageProvider storageProvider) {
        this._agent = agent;
        this._config = bootConfig;
        this._storageProvider = storageProvider;
        this._serviceInterfaceName2ServiceInterface = new HashMap();
        this._serviceInterface2ServiceImpl = new HashMap();
        this._serviceInterface2WaitAtGracefullStop = new HashSet<ShouldShutdownGracefully>();
        this._agent.registerNotifyHandler(this, CommandsAPIInfo.NOTIFY_SERVER_SET);
    }

    @Override
    public void startAgentTransport() throws Exception {
        ProviderInfo provider = CommandsAPIInfo.getProvider(this._storageProvider);
        Properties bootProperties = this._config.getBootProperties();
        _log.info((Object)"Agent is using unidirectional transport. Looking for properties to start the unidirectional transport.");
        String host = this.getHost(bootProperties, provider);
        if (host == null) {
            _log.info((Object)"Host is not currently set.");
        } else {
            _log.info((Object)("Host=" + host));
        }
        int unidirectionalPort = this.getUndirectionalPort(bootProperties, provider);
        if (unidirectionalPort == -1) {
            _log.info((Object)"Unidirectional port is not currently set.");
            _log.info((Object)"Cannot start new transport since we do not know the server port for the unidirectional transport.");
            return;
        }
        _log.info((Object)("Unidirectional port=" + unidirectionalPort));
        long pollingFrequency = this.getPollingFrequency(bootProperties);
        _log.info((Object)("Polling frequency=" + pollingFrequency));
        if (host == null) {
            _log.info((Object)"Cannot start new transport since we do not know the host.");
            return;
        }
        _log.info((Object)"Setting up unidirectional transport");
        if (this._config.isProxyServerSet()) {
            _log.info((Object)("Configuring proxy host and port: host=" + this._config.getProxyIp() + "; port=" + this._config.getProxyPort()));
            System.setProperty("https.proxyHost", this._config.getProxyIp());
            System.setProperty("https.proxyPort", String.valueOf(this._config.getProxyPort()));
        }
        this._agentTransport = new AgentTransport(this._config, this._storageProvider, pollingFrequency, 1);
        if (this._agentTransport != null) {
            for (Map.Entry entry : this._serviceInterface2ServiceImpl.entrySet()) {
                Class serviceInterface = (Class)entry.getKey();
                Object serviceImpl = entry.getValue();
                this._agentTransport.registerService(serviceInterface, serviceImpl);
            }
            this._agentTransport.start();
        }
    }

    @Override
    public void stopAgentTransport() {
        if (this._agentTransport != null) {
            try {
                this._agentTransport.stop();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this._agentTransport = null;
        }
    }

    @Override
    public void stopAgentTransportGracefully() {
        _log.info((Object)"Stopping AgentTransport gracefully");
        this.stopAgentTransport();
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        for (final ShouldShutdownGracefully serviceImpl : this._serviceInterface2WaitAtGracefullStop) {
            executorService.submit(new Runnable(){

                @Override
                public void run() {
                    serviceImpl.shutdownGracefully();
                }
            });
        }
        try {
            executorService.shutdown();
            executorService.awaitTermination(5L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            _log.error((Object)"Failed to wait for graceful stop", (Throwable)e);
        }
        _log.info((Object)"Stopping AgentTransport gracefully: done");
    }

    @Override
    public void handleNotification(String msgClass, String msg) {
        ProviderInfo provider = CommandsAPIInfo.getProvider(this._storageProvider);
        if (this._agentTransport == null) {
            try {
                this.startAgentTransport();
            }
            catch (Exception e) {
                _log.error((Object)"Failed to start agent transport after agent setup", (Throwable)e);
                return;
            }
        }
        if (this._agentTransport == null) {
            _log.error((Object)"Failed to start agent transport after agent setup");
            return;
        }
        if (provider == null) {
            _log.error((Object)"Agent transport expected agent token set but storage provider does not have token.");
        } else if (this._agentTransport != null) {
            String agentToken = provider.getAgentToken();
            _log.info((Object)("Updating agent transport with new agent token: " + agentToken));
        }
    }

    @Override
    public void registerService(Class serviceInterface, Object serviceImpl) {
        Class oldInterface = (Class)this._serviceInterfaceName2ServiceInterface.get(serviceInterface.getName());
        if (oldInterface == null) {
            this._serviceInterfaceName2ServiceInterface.put(serviceInterface.getName(), serviceInterface);
            this._serviceInterface2ServiceImpl.put(serviceInterface, serviceImpl);
        } else {
            this._serviceInterfaceName2ServiceInterface.remove(serviceInterface.getName());
            this._serviceInterface2ServiceImpl.remove(oldInterface);
            this._serviceInterfaceName2ServiceInterface.put(serviceInterface.getName(), serviceInterface);
            this._serviceInterface2ServiceImpl.put(serviceInterface, serviceImpl);
        }
        if (null != serviceImpl && serviceImpl instanceof ShouldShutdownGracefully) {
            this._serviceInterface2WaitAtGracefullStop.add((ShouldShutdownGracefully)serviceImpl);
        }
    }

    private String getHost(Properties bootProperties, ProviderInfo provider) {
        String host = bootProperties.getProperty("agent.setup.serverIP");
        if (host == null && provider != null) {
            host = AgentCallbackClient.getHostFromProviderURL(provider.getProviderAddress());
        }
        return host;
    }

    private int getUndirectionalPort(Properties bootProperties, ProviderInfo provider) {
        int port = -1;
        String portString = bootProperties.getProperty("agent.setup.serverSSLPort");
        if (portString == null) {
            if (provider != null) {
                port = provider.getProviderPort();
            }
        } else {
            try {
                port = PropertiesUtil.getPortValue((String)"agent.setup.serverSSLPort", (String)portString, (int)443);
            }
            catch (NumberFormatException e) {
                _log.error((Object)("The port given in the agent.setup.serverSSLPort property of " + portString + " is not a valid number."));
            }
            catch (IllegalArgumentException e) {
                _log.error((Object)"The port given in the agent.setup.serverSSLPort property is empty.");
            }
        }
        return port;
    }

    private long getPollingFrequency(Properties bootProperties) {
        String pollingFrequencyString = bootProperties.getProperty("agent.setup.uniPollingFrequency");
        return PropertiesUtil.getLongValue((String)"agent.setup.uniPollingFrequency", (String)pollingFrequencyString, (long)60000L);
    }
}

