/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.panel;

import com.sun.deploy.config.Config;
import com.sun.deploy.panel.NetworkSettingsDialog;
import com.sun.deploy.panel.NumberDocument;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.ui.DialogTemplate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;

public class AdvancedNetworkSettingsDialog
extends JDialog {
    private JTextArea bypassTextArea;
    private JTextField httpTextField;
    private JTextField secureTextField;
    private JTextField ftpTextField;
    private JTextField socksTextField;
    private JTextField httpPortTextField;
    private JTextField securePortTextField;
    private JTextField ftpPortTextField;
    private JTextField socksPortTextField;
    private JButton okButton;
    private JButton cancelButton;
    private JCheckBox useForAllChBox;
    private String lastFtpProxy;
    private String lastFtpPort;
    private String lastSecureProxy;
    private String lastSecurePort;

    public AdvancedNetworkSettingsDialog(Dialog dialog, boolean bl) {
        super(dialog, bl);
        this.initComponents();
    }

    private void initComponents() {
        this.setTitle(this.getMessage("advanced.network.dlg.title"));
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AdvancedNetworkSettingsDialog.this.closeDialog();
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(15, 15, 15, 15));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(5, 1, 0, 5));
        JLabel jLabel = new JLabel(this.getMessage("advanced.network.dlg.type"));
        jLabel.setHorizontalAlignment(0);
        JLabel jLabel2 = new JLabel(this.getMessage("advanced.network.dlg.http"));
        JLabel jLabel3 = new JLabel(this.getMessage("advanced.network.dlg.secure"));
        JLabel jLabel4 = new JLabel(this.getMessage("advanced.network.dlg.ftp"));
        JLabel jLabel5 = new JLabel(this.getMessage("advanced.network.dlg.socks"));
        jPanel4.add(jLabel);
        jPanel4.add(jLabel2);
        jPanel4.add(jLabel3);
        jPanel4.add(jLabel4);
        jPanel4.add(jLabel5);
        jPanel3.add(Box.createHorizontalStrut(5));
        jPanel3.add(jPanel4);
        jPanel3.add(Box.createHorizontalStrut(5));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayout(5, 1, 0, 5));
        JLabel jLabel6 = new JLabel(this.getMessage("advanced.network.dlg.proxy_address"));
        jLabel6.setHorizontalAlignment(0);
        this.httpTextField = new JTextField(20);
        JLabel jLabel7 = new JLabel(this.getMessage("advanced.network.dlg.http.proxy_address"));
        jLabel7.setLabelFor(this.httpTextField);
        this.secureTextField = new JTextField(20);
        JLabel jLabel8 = new JLabel(this.getMessage("advanced.network.dlg.secure.proxy_address"));
        jLabel8.setLabelFor(this.secureTextField);
        this.ftpTextField = new JTextField(20);
        JLabel jLabel9 = new JLabel(this.getMessage("advanced.network.dlg.ftp.proxy_address"));
        jLabel9.setLabelFor(this.ftpTextField);
        this.socksTextField = new JTextField(20);
        JLabel jLabel10 = new JLabel(this.getMessage("advanced.network.dlg.socks.proxy_address"));
        jLabel10.setLabelFor(this.socksTextField);
        jPanel5.add(jLabel6);
        jPanel5.add(this.httpTextField);
        jPanel5.add(this.secureTextField);
        jPanel5.add(this.ftpTextField);
        jPanel5.add(this.socksTextField);
        jPanel3.add(jPanel5);
        jPanel3.add(Box.createHorizontalStrut(5));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayout(5, 1, 0, 5));
        JLabel jLabel11 = new JLabel(":");
        jLabel11.setHorizontalAlignment(0);
        JLabel jLabel12 = new JLabel(":");
        jLabel12.setHorizontalAlignment(0);
        JLabel jLabel13 = new JLabel(":");
        jLabel13.setHorizontalAlignment(0);
        JLabel jLabel14 = new JLabel(":");
        jLabel14.setHorizontalAlignment(0);
        jPanel6.add(Box.createGlue());
        jPanel6.add(jLabel11);
        jPanel6.add(jLabel12);
        jPanel6.add(jLabel13);
        jPanel6.add(jLabel14);
        jPanel3.add(jPanel6);
        jPanel3.add(Box.createHorizontalStrut(5));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayout(5, 1, 0, 5));
        JLabel jLabel15 = new JLabel(this.getMessage("advanced.network.dlg.port"));
        jLabel15.setHorizontalAlignment(0);
        this.httpPortTextField = new JTextField(6);
        this.httpPortTextField.setDocument(new NumberDocument());
        JLabel jLabel16 = new JLabel(this.getMessage("advanced.network.dlg.http.port"));
        jLabel16.setLabelFor(this.httpPortTextField);
        this.securePortTextField = new JTextField(6);
        this.securePortTextField.setDocument(new NumberDocument());
        JLabel jLabel17 = new JLabel(this.getMessage("advanced.network.dlg.secure.port"));
        jLabel17.setLabelFor(this.securePortTextField);
        this.ftpPortTextField = new JTextField(6);
        this.ftpPortTextField.setDocument(new NumberDocument());
        JLabel jLabel18 = new JLabel(this.getMessage("advanced.network.dlg.ftp.port"));
        jLabel18.setLabelFor(this.ftpPortTextField);
        this.socksPortTextField = new JTextField(6);
        this.socksPortTextField.setDocument(new NumberDocument());
        JLabel jLabel19 = new JLabel(this.getMessage("advanced.network.dlg.socks.port"));
        jLabel19.setLabelFor(this.socksPortTextField);
        jPanel7.add(jLabel15);
        jPanel7.add(this.httpPortTextField);
        jPanel7.add(this.securePortTextField);
        jPanel7.add(this.ftpPortTextField);
        jPanel7.add(this.socksPortTextField);
        jPanel3.add(jPanel7);
        jPanel3.add(Box.createHorizontalStrut(5));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new FlowLayout(1));
        this.useForAllChBox = new JCheckBox(this.getMessage("advanced.network.dlg.same_proxy"));
        this.useForAllChBox.setSelected(false);
        this.useForAllChBox.setMnemonic(ResourceManager.getMnemonic("advanced.network.dlg.same_proxy"));
        this.useForAllChBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                AdvancedNetworkSettingsDialog.this.useForAllChBoxItemStateChanged(itemEvent);
            }
        });
        jPanel8.add(this.useForAllChBox);
        jPanel2.add((Component)jPanel3, "Center");
        jPanel2.add((Component)jPanel8, "South");
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BorderLayout());
        jPanel9.setBorder(new EmptyBorder(15, 15, 15, 15));
        JLabel jLabel20 = new JLabel(this.getMessage("advanced.network.dlg.no_proxy"));
        jLabel20.setFocusable(false);
        this.bypassTextArea = new JTextArea(3, 1);
        this.bypassTextArea.setFont(ResourceManager.getUIFont());
        this.bypassTextArea.setLineWrap(true);
        JLabel jLabel21 = new JLabel(this.getMessage("advanced.network.dlg.bypass.text_area"));
        jLabel21.setLabelFor(this.bypassTextArea);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setHorizontalScrollBarPolicy(31);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setAutoscrolls(true);
        jScrollPane.setViewportView(this.bypassTextArea);
        JLabel jLabel22 = new JLabel(this.getMessage("advanced.network.dlg.no_proxy_note"));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new BorderLayout());
        jPanel10.add((Component)jLabel20, "North");
        jPanel10.add((Component)jScrollPane, "Center");
        jPanel10.add((Component)jLabel22, "South");
        jPanel9.add(Box.createHorizontalStrut(10), "West");
        jPanel9.add((Component)jPanel10, "Center");
        jPanel9.add(Box.createHorizontalStrut(10), "East");
        jPanel9.add(Box.createVerticalStrut(5), "South");
        jPanel.add((Component)jPanel9, "Center");
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new FlowLayout(2));
        this.okButton = new JButton(this.getMessage("common.ok_btn"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedNetworkSettingsDialog.this.okButtonActionPerformed(actionEvent);
            }
        });
        this.cancelButton = new JButton(this.getMessage("common.cancel_btn"));
        JButton[] jButtonArray = new JButton[]{this.okButton, this.cancelButton};
        DialogTemplate.resizeButtons(jButtonArray);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedNetworkSettingsDialog.this.closeDialog();
            }
        };
        this.cancelButton.addActionListener(abstractAction);
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "cancel");
        this.getRootPane().getActionMap().put("cancel", abstractAction);
        jPanel11.add(this.okButton);
        jPanel11.add(this.cancelButton);
        this.getRootPane().setDefaultButton(this.okButton);
        jPanel.add((Component)jPanel11, "South");
        this.getContentPane().add(jPanel);
        this.pack();
        this.setValues();
        this.setResizable(false);
        this.setFocusSequence();
    }

    private void setValues() {
        boolean bl;
        if (this.getParent() != null && this.getParent() instanceof NetworkSettingsDialog) {
            this.getValuesFromParent();
            bl = ((NetworkSettingsDialog)this.getParent()).getUseSameProxy();
            this.useForAllChBox.setSelected(bl);
        } else {
            this.getValuesFromConfig();
            bl = Config.getBooleanProperty("deployment.proxy.same");
            this.useForAllChBox.setSelected(bl);
        }
        this.useForAllChBox.setEnabled(!Config.get().isPropertyLocked("deployment.proxy.same"));
        this.bypassTextArea.setEditable(!Config.get().isPropertyLocked("deployment.proxy.bypass.list"));
        this.setUseForAll(bl);
    }

    private void getValuesFromParent() {
        NetworkSettingsDialog networkSettingsDialog = (NetworkSettingsDialog)this.getParent();
        if (this.httpTextField.getText().trim().equals("")) {
            this.httpTextField.setText(networkSettingsDialog.getProxyAddressField("deployment.proxy.http.host"));
        }
        if (this.httpPortTextField.getText().trim().equals("")) {
            this.httpPortTextField.setText(networkSettingsDialog.getProxyPortField("deployment.proxy.http.port"));
        }
        if (this.secureTextField.getText().trim().equals("")) {
            this.secureTextField.setText(networkSettingsDialog.getProxyAddressField("deployment.proxy.https.host"));
        }
        if (this.securePortTextField.getText().trim().equals("")) {
            this.securePortTextField.setText(networkSettingsDialog.getProxyPortField("deployment.proxy.https.port"));
        }
        if (this.ftpTextField.getText().trim().equals("")) {
            this.ftpTextField.setText(networkSettingsDialog.getProxyAddressField("deployment.proxy.ftp.host"));
        }
        if (this.ftpPortTextField.getText().trim().equals("")) {
            this.ftpPortTextField.setText(networkSettingsDialog.getProxyPortField("deployment.proxy.ftp.port"));
        }
        if (this.socksTextField.getText().trim().equals("")) {
            this.socksTextField.setText(networkSettingsDialog.getProxyAddressField("deployment.proxy.socks.host"));
        }
        if (this.socksPortTextField.getText().trim().equals("")) {
            this.socksPortTextField.setText(networkSettingsDialog.getProxyPortField("deployment.proxy.socks.port"));
        }
        if (this.bypassTextArea.getText().trim().equals("")) {
            this.bypassTextArea.setText(networkSettingsDialog.getBypassString());
        }
    }

    private void getValuesFromConfig() {
        if (this.httpTextField.getText().trim().equals("")) {
            this.httpTextField.setText(Config.getStringProperty("deployment.proxy.http.host"));
        }
        if (this.httpPortTextField.getText().trim().equals("")) {
            this.httpPortTextField.setText(Config.getStringProperty("deployment.proxy.http.port"));
        }
        if (this.secureTextField.getText().trim().equals("")) {
            this.secureTextField.setText(Config.getStringProperty("deployment.proxy.https.host"));
        }
        if (this.securePortTextField.getText().trim().equals("")) {
            this.securePortTextField.setText(Config.getStringProperty("deployment.proxy.https.port"));
        }
        if (this.ftpTextField.getText().trim().equals("")) {
            this.ftpTextField.setText(Config.getStringProperty("deployment.proxy.ftp.host"));
        }
        if (this.ftpPortTextField.getText().trim().equals("")) {
            this.ftpPortTextField.setText(Config.getStringProperty("deployment.proxy.ftp.port"));
        }
        if (this.socksTextField.getText().trim().equals("")) {
            this.socksTextField.setText(Config.getStringProperty("deployment.proxy.socks.host"));
        }
        if (this.socksPortTextField.getText().trim().equals("")) {
            this.socksPortTextField.setText(Config.getStringProperty("deployment.proxy.socks.port"));
        }
        if (this.bypassTextArea.getText().trim().equals("")) {
            this.bypassTextArea.setText(Config.getStringProperty("deployment.proxy.bypass.list"));
        }
    }

    private void setFocusSequence() {
        this.httpTextField.setNextFocusableComponent(this.httpPortTextField);
        this.secureTextField.setNextFocusableComponent(this.securePortTextField);
        this.ftpTextField.setNextFocusableComponent(this.ftpPortTextField);
        this.socksTextField.setNextFocusableComponent(this.socksPortTextField);
        this.httpPortTextField.setNextFocusableComponent(this.secureTextField);
        this.securePortTextField.setNextFocusableComponent(this.ftpTextField);
        this.ftpPortTextField.setNextFocusableComponent(this.socksTextField);
        this.bypassTextArea.setNextFocusableComponent(this.okButton);
    }

    private void setComponent(JComponent jComponent, boolean bl) {
        if (jComponent instanceof JLabel || jComponent instanceof JCheckBox || jComponent instanceof JButton) {
            jComponent.setEnabled(bl);
        } else if (jComponent instanceof JTextField) {
            jComponent.setEnabled(bl);
            ((JTextField)jComponent).setEditable(bl);
        }
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        if (this.getParent() instanceof NetworkSettingsDialog) {
            ((NetworkSettingsDialog)this.getParent()).updateProxyInfo(this.httpTextField.getText(), this.httpPortTextField.getText(), this.secureTextField.getText(), this.securePortTextField.getText(), this.ftpTextField.getText(), this.ftpPortTextField.getText(), this.socksTextField.getText(), this.socksPortTextField.getText(), this.useForAllChBox.isSelected(), this.bypassTextArea.getText());
        } else {
            this.savePropertiesInConfig();
        }
        this.setVisible(false);
        this.dispose();
    }

    private void savePropertiesInConfig() {
        Config.setStringProperty("deployment.proxy.http.host", this.httpTextField.getText());
        Config.setStringProperty("deployment.proxy.http.port", this.httpPortTextField.getText());
        Config.setStringProperty("deployment.proxy.https.host", this.secureTextField.getText());
        Config.setStringProperty("deployment.proxy.https.port", this.securePortTextField.getText());
        Config.setStringProperty("deployment.proxy.ftp.host", this.ftpTextField.getText());
        Config.setStringProperty("deployment.proxy.ftp.port", this.ftpPortTextField.getText());
        Config.setStringProperty("deployment.proxy.socks.host", this.socksTextField.getText());
        Config.setStringProperty("deployment.proxy.socks.port", this.socksPortTextField.getText());
        Config.setBooleanProperty("deployment.proxy.same", this.useForAllChBox.isSelected());
        Config.setStringProperty("deployment.proxy.bypass.list", this.bypassTextArea.getText());
    }

    private void useForAllChBoxItemStateChanged(ItemEvent itemEvent) {
        if (this.useForAllChBox.isSelected()) {
            this.lastFtpProxy = this.ftpTextField.getText();
            this.lastFtpPort = this.ftpPortTextField.getText();
            this.lastSecureProxy = this.secureTextField.getText();
            this.lastSecurePort = this.securePortTextField.getText();
        } else {
            this.secureTextField.setText(this.lastSecureProxy);
            this.securePortTextField.setText(this.lastSecurePort);
            this.ftpTextField.setText(this.lastFtpProxy);
            this.ftpPortTextField.setText(this.lastFtpPort);
        }
        this.setUseForAll(this.useForAllChBox.isSelected());
    }

    private void setUseForAll(boolean bl) {
        if (this.getParent() != null && this.getParent() instanceof NetworkSettingsDialog) {
            this.getValuesFromParent();
        } else {
            this.getValuesFromConfig();
        }
        this.setTextFields(!bl);
        if (bl) {
            this.secureTextField.setText(this.httpTextField.getText());
            this.securePortTextField.setText(this.httpPortTextField.getText());
            this.ftpTextField.setText(this.httpTextField.getText());
            this.ftpPortTextField.setText(this.httpPortTextField.getText());
        }
    }

    private void setTextFields(boolean bl) {
        boolean bl2 = !Config.get().isPropertyLocked("deployment.proxy.http.host");
        this.httpTextField.setEnabled(bl2);
        this.httpTextField.setEditable(bl2);
        bl2 = !Config.get().isPropertyLocked("deployment.proxy.http.port");
        this.httpPortTextField.setEnabled(bl2);
        this.httpPortTextField.setEditable(bl2);
        bl2 = bl && !Config.get().isPropertyLocked("deployment.proxy.https.host");
        this.secureTextField.setEnabled(bl2);
        this.secureTextField.setEditable(bl2);
        bl2 = bl && !Config.get().isPropertyLocked("deployment.proxy.https.port");
        this.securePortTextField.setEnabled(bl2);
        this.securePortTextField.setEditable(bl2);
        bl2 = bl && !Config.get().isPropertyLocked("deployment.proxy.ftp.host");
        this.ftpTextField.setEnabled(bl2);
        this.ftpTextField.setEditable(bl2);
        bl2 = bl && !Config.get().isPropertyLocked("deployment.proxy.ftp.port");
        this.ftpPortTextField.setEnabled(bl2);
        this.ftpPortTextField.setEditable(bl2);
        bl2 = !Config.get().isPropertyLocked("deployment.proxy.socks.host");
        this.socksTextField.setEnabled(bl2);
        this.socksTextField.setEditable(bl2);
        bl2 = !Config.get().isPropertyLocked("deployment.proxy.socks.port");
        this.socksPortTextField.setEnabled(bl2);
        this.socksPortTextField.setEditable(bl2);
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private String getMessage(String string) {
        return ResourceManager.getMessage(string);
    }
}

