/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.transport;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PortUnreachableException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.transport.UdpTransportMapping;
import org.snmp4j.util.WorkerTask;

public class DefaultUdpTransportMapping
extends UdpTransportMapping {
    private static final LogAdapter logger = LogFactory.getLogger(DefaultUdpTransportMapping.class);
    protected DatagramSocket socket = null;
    protected WorkerTask listener;
    protected ListenThread listenerThread;
    private int socketTimeout = 0;
    private int receiveBufferSize = 0;

    public DefaultUdpTransportMapping() throws IOException {
        super(new UdpAddress(InetAddress.getLocalHost(), 0));
        this.socket = new DatagramSocket(this.udpAddress.getPort());
    }

    public DefaultUdpTransportMapping(UdpAddress udpAddress, boolean reuseAddress) throws IOException {
        super(udpAddress);
        this.socket = new DatagramSocket(null);
        this.socket.setReuseAddress(reuseAddress);
        InetSocketAddress addr = new InetSocketAddress(udpAddress.getInetAddress(), udpAddress.getPort());
        this.socket.bind(addr);
    }

    public DefaultUdpTransportMapping(UdpAddress udpAddress) throws IOException {
        super(udpAddress);
        this.socket = new DatagramSocket(udpAddress.getPort(), udpAddress.getInetAddress());
    }

    public void sendMessage(Address targetAddress, byte[] message) throws IOException {
        InetSocketAddress targetSocketAddress = new InetSocketAddress(((UdpAddress)targetAddress).getInetAddress(), ((UdpAddress)targetAddress).getPort());
        if (logger.isDebugEnabled()) {
            logger.debug("Sending message to " + targetAddress + " with length " + message.length + ": " + new OctetString(message).toHexString());
        }
        DatagramSocket s = this.ensureSocket();
        s.send(new DatagramPacket(message, message.length, targetSocketAddress));
    }

    public void close() throws IOException {
        boolean interrupted = false;
        WorkerTask l = this.listener;
        if (l != null) {
            l.terminate();
            l.interrupt();
            if (this.socketTimeout > 0) {
                try {
                    l.join();
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                    logger.warn(ex);
                }
            }
            this.listener = null;
        }
        if (this.socket != null && !this.socket.isClosed()) {
            this.socket.close();
        }
        this.socket = null;
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public synchronized void listen() throws IOException {
        if (this.listener != null) {
            throw new SocketException("Port already listening");
        }
        this.ensureSocket();
        this.listenerThread = new ListenThread();
        this.listener = SNMP4JSettings.getThreadFactory().createWorkerThread("DefaultUDPTransportMapping_" + this.getAddress(), this.listenerThread, true);
        this.listener.run();
    }

    private synchronized DatagramSocket ensureSocket() throws SocketException {
        DatagramSocket s = this.socket;
        if (s == null) {
            s = new DatagramSocket(this.udpAddress.getPort());
            s.setSoTimeout(this.socketTimeout);
            this.socket = s;
        }
        return s;
    }

    public void setPriority(int newPriority) {
        WorkerTask lt = this.listener;
        if (lt instanceof Thread) {
            ((Thread)((Object)lt)).setPriority(newPriority);
        }
    }

    public int getPriority() {
        WorkerTask lt = this.listener;
        if (lt instanceof Thread) {
            return ((Thread)((Object)lt)).getPriority();
        }
        return 5;
    }

    public void setThreadName(String name) {
        WorkerTask lt = this.listener;
        if (lt instanceof Thread) {
            ((Thread)((Object)lt)).setName(name);
        }
    }

    public String getThreadName() {
        WorkerTask lt = this.listener;
        if (lt instanceof Thread) {
            return ((Thread)((Object)lt)).getName();
        }
        return null;
    }

    public void setMaxInboundMessageSize(int maxInboundMessageSize) {
        this.maxInboundMessageSize = maxInboundMessageSize;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        if (receiveBufferSize <= 0) {
            throw new IllegalArgumentException("Receive buffer size must be > 0");
        }
        this.receiveBufferSize = receiveBufferSize;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        if (this.socket != null) {
            try {
                this.socket.setSoTimeout(socketTimeout);
            }
            catch (SocketException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public boolean isListening() {
        return this.listener != null;
    }

    class ListenThread
    implements WorkerTask {
        private byte[] buf;
        private volatile boolean stop = false;

        public ListenThread() throws SocketException {
            this.buf = new byte[DefaultUdpTransportMapping.this.getMaxInboundMessageSize()];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                DefaultUdpTransportMapping.this.socket.setSoTimeout(DefaultUdpTransportMapping.this.getSocketTimeout());
                if (DefaultUdpTransportMapping.this.receiveBufferSize > 0) {
                    DefaultUdpTransportMapping.this.socket.setReceiveBufferSize(Math.max(DefaultUdpTransportMapping.this.receiveBufferSize, DefaultUdpTransportMapping.this.maxInboundMessageSize));
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("UDP receive buffer size for socket " + DefaultUdpTransportMapping.this.getAddress() + " is set to: " + DefaultUdpTransportMapping.this.socket.getReceiveBufferSize());
                }
            }
            catch (SocketException ex) {
                logger.error(ex);
                DefaultUdpTransportMapping.this.setSocketTimeout(0);
            }
            while (!this.stop) {
                DatagramPacket packet = new DatagramPacket(this.buf, this.buf.length, DefaultUdpTransportMapping.this.udpAddress.getInetAddress(), DefaultUdpTransportMapping.this.udpAddress.getPort());
                try {
                    ByteBuffer bis;
                    try {
                        DefaultUdpTransportMapping.this.socket.receive(packet);
                    }
                    catch (InterruptedIOException iiox) {
                        if (iiox.bytesTransferred <= 0) continue;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Received message from " + packet.getAddress() + "/" + packet.getPort() + " with length " + packet.getLength() + ": " + new OctetString(packet.getData(), 0, packet.getLength()).toHexString());
                    }
                    if (DefaultUdpTransportMapping.this.isAsyncMsgProcessingSupported()) {
                        byte[] bytes = new byte[packet.getLength()];
                        System.arraycopy(packet.getData(), 0, bytes, 0, bytes.length);
                        bis = ByteBuffer.wrap(bytes);
                    } else {
                        bis = ByteBuffer.wrap(packet.getData());
                    }
                    DefaultUdpTransportMapping.this.fireProcessMessage(new UdpAddress(packet.getAddress(), packet.getPort()), bis);
                }
                catch (SocketTimeoutException stex) {
                }
                catch (PortUnreachableException purex) {
                    DefaultUdpTransportMapping defaultUdpTransportMapping = DefaultUdpTransportMapping.this;
                    synchronized (defaultUdpTransportMapping) {
                        DefaultUdpTransportMapping.this.listener = null;
                    }
                    logger.error(purex);
                    if (logger.isDebugEnabled()) {
                        purex.printStackTrace();
                    }
                    if (!SNMP4JSettings.isFowardRuntimeExceptions()) break;
                    throw new RuntimeException(purex);
                }
                catch (SocketException soex) {
                    if (!this.stop) {
                        logger.error("Socket for transport mapping " + this.toString() + " error: " + soex.getMessage(), soex);
                    }
                    this.stop = true;
                }
                catch (IOException iox) {
                    logger.warn(iox);
                    if (logger.isDebugEnabled()) {
                        iox.printStackTrace();
                    }
                    if (!SNMP4JSettings.isFowardRuntimeExceptions()) continue;
                    throw new RuntimeException(iox);
                }
            }
            DefaultUdpTransportMapping defaultUdpTransportMapping = DefaultUdpTransportMapping.this;
            synchronized (defaultUdpTransportMapping) {
                DefaultUdpTransportMapping.this.listener = null;
                this.stop = true;
                if (DefaultUdpTransportMapping.this.socket != null) {
                    DefaultUdpTransportMapping.this.socket.close();
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Worker task stopped:" + this.getClass().getName());
            }
        }

        public void close() {
            this.stop = true;
        }

        public void terminate() {
            this.close();
            if (logger.isDebugEnabled()) {
                logger.debug("Terminated worker task: " + this.getClass().getName());
            }
        }

        public void join() throws InterruptedException {
            if (logger.isDebugEnabled()) {
                logger.debug("Joining worker task: " + this.getClass().getName());
            }
        }

        public void interrupt() {
            if (logger.isDebugEnabled()) {
                logger.debug("Interrupting worker task: " + this.getClass().getName());
            }
            this.close();
        }
    }
}

