/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.system;

import java.util.ArrayList;
import org.hyperic.hq.appdef.shared.AIServiceValue;
import org.hyperic.hq.plugin.system.SystemPlugin;
import org.hyperic.hq.plugin.system.SystemServerDetector;
import org.hyperic.sigar.NetFlags;
import org.hyperic.sigar.NetInterfaceConfig;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.EncodingException;

public class NetifDetector
extends SystemServerDetector {
    @Override
    protected String getServerType() {
        return "NetworkServer";
    }

    @Override
    protected ArrayList getSystemServiceValues(Sigar sigar, ConfigResponse config) throws SigarException {
        ArrayList<AIServiceValue> services = new ArrayList<AIServiceValue>();
        String[] ifNames = sigar.getNetInterfaceList();
        for (int i = 0; i < ifNames.length; ++i) {
            long flags;
            NetInterfaceConfig ifconfig;
            String name = ifNames[i];
            if (name.indexOf(58) != -1) continue;
            try {
                ifconfig = sigar.getNetInterfaceConfig(name);
            }
            catch (SigarException e) {
                this.getLog().debug((Object)("getNetInterfaceConfig(" + name + "): " + e.getMessage()), (Throwable)e);
                continue;
            }
            if (NetFlags.isAnyAddress((String)ifconfig.getAddress()) || ((flags = ifconfig.getFlags()) & 1L) <= 0L || (flags & 0x10L) > 0L) continue;
            String type = (flags & 8L) > 0L ? "loopback" : ifconfig.getType().toLowerCase();
            String info = "Network Interface " + name + " (" + type + ")";
            AIServiceValue svc = this.createSystemService(SystemPlugin.NETWORK_INTERFACE_SERVICE, this.getFullServiceName(info), "interface", name);
            String desc = ifconfig.getDescription();
            if (!desc.equals(name)) {
                svc.setDescription(desc);
            }
            ConfigResponse cprops = new ConfigResponse();
            cprops.setValue("mtu", String.valueOf(ifconfig.getMtu()));
            cprops.setValue("flags", NetFlags.getIfFlagsString((long)flags).trim());
            String mac = ifconfig.getHwaddr();
            if (!mac.equals("00:00:00:00:00:00")) {
                cprops.setValue("mac", mac);
            }
            String[][] addrs = new String[][]{{"address", ifconfig.getAddress()}, {"netmask", ifconfig.getNetmask()}, {"broadcast", ifconfig.getBroadcast()}};
            for (int j = 0; j < addrs.length; ++j) {
                String key = addrs[j][0];
                String val = addrs[j][1];
                if (NetFlags.isAnyAddress((String)val)) continue;
                cprops.setValue(key, val);
            }
            try {
                svc.setCustomProperties(cprops.encode());
            }
            catch (EncodingException e) {
                this.getLog().error((Object)("Error encoding cprops: " + e.getMessage()));
            }
            services.add(svc);
        }
        return services;
    }
}

