/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.cache.impl;

import com.vmware.ares.vcd.v1.MyImageRecordType;
import com.vmware.ares.vcd.v1.OperatingSystemCatalogRecordType;
import com.vmware.vcim.ngc.service.adapter.common.AdapterWrapper;
import com.vmware.vcim.ngc.service.adapter.common.DataAdapter;
import com.vmware.vcim.ngc.service.adapter.common.DataAdapterFactory;
import com.vmware.vcim.ngc.service.cache.common.CacheProxy;
import com.vmware.vcim.ngc.service.cache.impl.CacheAdapter;
import com.vmware.vcim.ngc.service.cache.jaxbwrapper.MyImageRecordTypeWrapper;
import com.vmware.vcim.ngc.service.cache.jaxbwrapper.OperatingSystemCatalogRecordTypeWrappper;
import com.vmware.vcim.ngc.service.cache.model.CacheEntries;
import com.vmware.vcim.ngc.service.cache.model.CacheEntry;
import com.vmware.vcim.ngc.service.impl.VcimSessionManager;
import com.vmware.vcim.ngc.service.model.Network;
import com.vmware.vcim.ngc.service.model.VCimTemplate;
import com.vmware.vcim.ngc.service.model.VCimVirtualDatacenter;
import com.vmware.vcim.ngc.service.model.VMStorage;
import com.vmware.vcim.ngc.service.model.VchsObjectType;
import com.vmware.vcim.ngc.service.vpc.contracts.TemplateOperations;
import com.vmware.vcim.ngc.service.vpc.contracts.VirtualDatacenterOperations;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class TemplateCacheAdapter
extends CacheAdapter
implements TemplateOperations,
DataAdapter {
    private DataAdapterFactory dataAdapterFactory;
    private AdapterWrapper adapterWrapper;
    private CacheProxy cacheProxy;
    private JAXBContext osCatalogRecordTypeWrappperContext;
    private JAXBContext myImageRecordTypeWrapperContext;
    private static final Logger logger = LoggerFactory.getLogger(TemplateCacheAdapter.class);

    public TemplateCacheAdapter(VcimSessionManager vcimSessionMgr, CacheProxy cacheProxy, AdapterWrapper adapterWrapper) {
        super(vcimSessionMgr);
        this.cacheProxy = cacheProxy;
        this.adapterWrapper = adapterWrapper;
        try {
            this.osCatalogRecordTypeWrappperContext = JAXBContext.newInstance((Class[])new Class[]{OperatingSystemCatalogRecordTypeWrappper.class});
            this.myImageRecordTypeWrapperContext = JAXBContext.newInstance((Class[])new Class[]{MyImageRecordTypeWrapper.class});
        }
        catch (JAXBException e) {
            // empty catch block
        }
    }

    public DataAdapterFactory getDataAdapterFactory() {
        return this.dataAdapterFactory;
    }

    public void setDataAdapterFactory(DataAdapterFactory dataAdapterFactory) {
        this.dataAdapterFactory = dataAdapterFactory;
        this.dataAdapterFactory.registerAdapter(this);
    }

    @Override
    public List<VCimTemplate> getTemplates(String clientSessionId) {
        ArrayList<VCimTemplate> templates = new ArrayList<VCimTemplate>();
        List<VCimVirtualDatacenter> vDCs = this.getVdcReadOnlyAdapter().getVDCs(clientSessionId);
        if (vDCs != null) {
            for (VCimVirtualDatacenter vDC : vDCs) {
                if (!vDC.isPrivate()) {
                    templates.addAll(this.getSharedOsCatalogs(clientSessionId, vDC));
                    templates.addAll(this.getSharedImages(clientSessionId, vDC));
                    continue;
                }
                templates.addAll(this.getPrivateOsCatalogs(clientSessionId, vDC));
                templates.addAll(this.getPrivateImages(clientSessionId, vDC));
            }
        }
        return templates;
    }

    private List<VCimTemplate> getSharedOsCatalogs(String clientSessionId, VCimVirtualDatacenter vDC) {
        logger.info("Fetching OS catalogs for shared VDC - " + vDC.getName());
        String url = "/vdc/<VDC_ID>/osCatalog";
        url = url.replace("<VDC_ID>", vDC.getId());
        url = this.getUserQualifiedUrl(url, clientSessionId);
        return this.getOsCatalogs(clientSessionId, url, false, vDC.getCloudId(), vDC.getId());
    }

    private List<VCimTemplate> getPrivateOsCatalogs(String clientSessionId, VCimVirtualDatacenter vDC) {
        logger.info("Fetching OS catalogs for dedicated VDC - " + vDC.getName());
        String url = "/vdc/<VDC_ID>/osCatalog";
        url = url.replace("<VDC_ID>", vDC.getId());
        url = this.getUserQualifiedUrl(url, clientSessionId);
        return this.getOsCatalogs(clientSessionId, url, true, vDC.getCloudId(), vDC.getId());
    }

    private List<VCimTemplate> getOsCatalogs(String clientSessionId, String url, boolean isPrivate, String vpcId, String vdcId) {
        ResponseEntity osCatalogResponse = null;
        try {
            osCatalogResponse = (ResponseEntity)this.cacheProxy.sendGetRequest(url, CacheEntries.class);
        }
        catch (Exception ex) {
            logger.error("Error fetching OS catalogs.", (Throwable)ex);
        }
        ArrayList<VCimTemplate> templates = new ArrayList<VCimTemplate>();
        if (null != osCatalogResponse) {
            CacheEntries osList = (CacheEntries)osCatalogResponse.getBody();
            logger.info("Found " + osList.getCacheEntries().size() + " OS catalogs");
            for (CacheEntry osCatalogEntry : osList.getCacheEntries()) {
                OperatingSystemCatalogRecordTypeWrappper osCatalogRecordWrapper = this.unmarshal(this.osCatalogRecordTypeWrappperContext, osCatalogEntry.getXmlChunk(), OperatingSystemCatalogRecordTypeWrappper.class);
                OperatingSystemCatalogRecordType osCatalogRecord = osCatalogRecordWrapper.getOperatingSystemCatalogRecordType();
                templates.add(new VCimTemplate(osCatalogRecord, isPrivate, vpcId, vdcId));
            }
        }
        return templates;
    }

    private List<VCimTemplate> getSharedImages(String clientSessionId, VCimVirtualDatacenter vDC) {
        String url = "/vdc/<VDC_ID>/myImage";
        url = url.replace("<VDC_ID>", vDC.getId());
        return this.getMyImages(clientSessionId, url, false, vDC.getCloudId(), vDC.getId());
    }

    private List<VCimTemplate> getPrivateImages(String clientSessionId, VCimVirtualDatacenter vDC) {
        String url = "/vdc/<VDC_ID>/myImage";
        url = url.replace("<VDC_ID>", vDC.getId());
        url = this.getUserQualifiedUrl(url, clientSessionId);
        return this.getMyImages(clientSessionId, url, true, vDC.getCloudId(), vDC.getId());
    }

    private List<VCimTemplate> getMyImages(String clientSessionId, String url, boolean isPrivate, String vpcId, String vdcId) {
        ResponseEntity myImageResponse = null;
        try {
            myImageResponse = (ResponseEntity)this.cacheProxy.sendGetRequest(url, CacheEntries.class);
        }
        catch (Exception ex) {
            logger.error("Error fetching my images.", (Throwable)ex);
        }
        ArrayList<VCimTemplate> templates = new ArrayList<VCimTemplate>();
        if (null != myImageResponse) {
            CacheEntries imageList = (CacheEntries)myImageResponse.getBody();
            logger.info("Found " + imageList.getCacheEntries().size() + " my images.");
            for (CacheEntry myImageEntry : imageList.getCacheEntries()) {
                MyImageRecordTypeWrapper myImageRecordTypeWrapper = this.unmarshal(this.myImageRecordTypeWrapperContext, myImageEntry.getXmlChunk(), MyImageRecordTypeWrapper.class);
                MyImageRecordType myImageRecordType = myImageRecordTypeWrapper.getMyImageRecordType();
                templates.add(new VCimTemplate(myImageRecordType, isPrivate, vpcId, vdcId));
            }
        }
        return templates;
    }

    @Override
    public VCimTemplate getTemplate(String clientSessionId, URI templateUri) {
        logger.info("Fetching template with URI - " + templateUri + "for client id - " + clientSessionId);
        String vdcId = VCimTemplate.getVdcId(templateUri);
        List<VCimTemplate> templates = this.getTemplatesForVdc(clientSessionId, vdcId);
        for (VCimTemplate template : templates) {
            if (!templateUri.equals(template.getUri())) continue;
            logger.info("Found template with URI - " + templateUri);
            return template;
        }
        return null;
    }

    @Override
    public void deployTemplate(String clientSessionId, URI templateUri, String name, int vcpu, long memory, List<VMStorage> storage, List<Network> networks) {
    }

    @Override
    public List<VCimTemplate> getTemplatesForVdc(String clientSessionId, String vdcId) {
        ArrayList<VCimTemplate> templates = new ArrayList<VCimTemplate>();
        logger.info("Fetching templates for vdc id - " + vdcId);
        Date currentTimestamp = new Date();
        logger.info("Started fetching templates for VDC " + vdcId + " from cache, Timestamp @ " + currentTimestamp.getTime());
        VCimVirtualDatacenter vDC = this.getVdcReadOnlyAdapter().getVDCById(clientSessionId, vdcId);
        if (vDC != null) {
            if (!vDC.isPrivate()) {
                templates.addAll(this.getSharedOsCatalogs(clientSessionId, vDC));
                templates.addAll(this.getSharedImages(clientSessionId, vDC));
            } else {
                templates.addAll(this.getPrivateOsCatalogs(clientSessionId, vDC));
                templates.addAll(this.getPrivateImages(clientSessionId, vDC));
            }
        }
        currentTimestamp = new Date();
        logger.info("Completed fetching templates for VDC " + vdcId + " from cache, Timestamp @ " + currentTimestamp.getTime());
        return templates;
    }

    @Override
    public DataAdapter.AdapterType getAdapterType() {
        return DataAdapter.AdapterType.READ_ONLY_ADAPTER;
    }

    @Override
    public VchsObjectType getSupportedObjectType() {
        return VchsObjectType.TEMPLATE;
    }

    private VirtualDatacenterOperations getVdcReadOnlyAdapter() {
        return (VirtualDatacenterOperations)((Object)this.adapterWrapper.getReadOnlyAdapter(VchsObjectType.DATACENTER));
    }
}

