/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.cache.vpc.impl;

import com.vmware.ares.common.v2.CloudTypeType;
import com.vmware.ares.product.v2.DcSnapshotListType;
import com.vmware.ares.product.v2.DcSnapshotType;
import com.vmware.ares.vcd.v2.VdcSnapshotListType;
import com.vmware.ares.vcd.v2.VdcSnapshotType;
import com.vmware.vcim.ngc.service.cache.common.CloudObjectEntity;
import com.vmware.vcim.ngc.service.cache.helper.CloudInstanceVpcHelper;
import com.vmware.vcim.ngc.service.cache.helper.VpcHelper;
import com.vmware.vcim.ngc.service.cache.jaxbwrapper.DcSnapshotTypeWrapper;
import com.vmware.vcim.ngc.service.cache.jaxbwrapper.VdcSnapshotTypeWrapper;
import com.vmware.vcim.ngc.service.impl.VcimSessionManager;
import com.vmware.vcim.ngc.service.model.VCimRegion;
import com.vmware.vcim.ngc.service.model.VchsObjectType;
import com.vmware.vcim.ngc.service.rest.vcim.VcimRestClient;
import com.vmware.vcim.ngc.service.vpc.impl.RegionVpcAdapter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.springframework.http.ResponseEntity;

public class CloudInstanceVpcHelperImpl
extends VpcHelper
implements CloudInstanceVpcHelper {
    private RegionVpcAdapter regionAdapter;
    private JAXBContext dcSnapshotTypeWrapperContext;
    private JAXBContext vdcSnapshotTypeWrapperContext;

    public CloudInstanceVpcHelperImpl(VcimRestClient vcimRestClient, VcimSessionManager vcimSessionMgr, RegionVpcAdapter regionAdapter) {
        super(vcimRestClient, vcimSessionMgr);
        this.regionAdapter = regionAdapter;
        try {
            this.dcSnapshotTypeWrapperContext = JAXBContext.newInstance((Class[])new Class[]{DcSnapshotTypeWrapper.class});
            this.vdcSnapshotTypeWrapperContext = JAXBContext.newInstance((Class[])new Class[]{VdcSnapshotTypeWrapper.class});
        }
        catch (JAXBException e) {
            // empty catch block
        }
    }

    @Override
    public List<CloudObjectEntity> getPrivateClouds(String clientSessionId) {
        List<VCimRegion> regions = this.regionAdapter.getRegions(clientSessionId);
        ArrayList<CloudObjectEntity> cloudObjects = new ArrayList<CloudObjectEntity>();
        for (VCimRegion region : regions) {
            cloudObjects.addAll(this.getPrivateClouds(clientSessionId, region.getId()));
        }
        return cloudObjects;
    }

    @Override
    public List<CloudObjectEntity> getPublicClouds(String clientSessionId) {
        List<VCimRegion> regions = this.regionAdapter.getRegions(clientSessionId);
        ArrayList<CloudObjectEntity> cloudObjects = new ArrayList<CloudObjectEntity>();
        for (VCimRegion region : regions) {
            cloudObjects.addAll(this.getPublicClouds(clientSessionId, region.getId()));
        }
        return cloudObjects;
    }

    private List<CloudObjectEntity> getPrivateClouds(String clientSessionId, String regionId) {
        String url = "/api/private/region/<REGION_ID>/dcs";
        url = url.replace("<REGION_ID>", regionId);
        ResponseEntity vpcResponse = (ResponseEntity)this.vcimRestClient.sendGetRequest(url, DcSnapshotListType.class, null, clientSessionId);
        ArrayList<CloudObjectEntity> cloudObjects = new ArrayList<CloudObjectEntity>();
        if (null != vpcResponse) {
            DcSnapshotListType vpcs = (DcSnapshotListType)vpcResponse.getBody();
            for (DcSnapshotType dc : vpcs.getDcSnapshot()) {
                DcSnapshotTypeWrapper dcSnapshotTypeWrapper = new DcSnapshotTypeWrapper();
                dcSnapshotTypeWrapper.setDcSnapshotType(dc);
                String id = "private~" + dc.getId();
                String payload = this.marshal(this.dcSnapshotTypeWrapperContext, dcSnapshotTypeWrapper);
                CloudObjectEntity cloudObject = new CloudObjectEntity(VchsObjectType.CLOUD, id, payload);
                cloudObject.getObjectProperties().put("isShared", "false");
                cloudObject.getObjectProperties().put("regionId", regionId);
                cloudObjects.add(cloudObject);
            }
        }
        return cloudObjects;
    }

    private List<CloudObjectEntity> getPublicClouds(String clientSessionId, String regionId) {
        String url = "/api/private/region/<REGION_ID>/vdcs";
        url = url.replace("<REGION_ID>", regionId);
        ResponseEntity vdcResponse = (ResponseEntity)this.vcimRestClient.sendGetRequest(url, VdcSnapshotListType.class, null, clientSessionId);
        ArrayList<CloudObjectEntity> cloudObjects = new ArrayList<CloudObjectEntity>();
        if (null != vdcResponse) {
            VdcSnapshotListType vdcs = (VdcSnapshotListType)vdcResponse.getBody();
            for (VdcSnapshotType vdc : vdcs.getVdcSnapshot()) {
                if (CloudTypeType.VPC != vdc.getContainerCloudType()) continue;
                VdcSnapshotTypeWrapper vdcSnapshotTypeWrapper = new VdcSnapshotTypeWrapper();
                vdcSnapshotTypeWrapper.setVdcSnapshotType(vdc);
                String id = "public~" + vdc.getId();
                String payload = this.marshal(this.vdcSnapshotTypeWrapperContext, vdcSnapshotTypeWrapper);
                CloudObjectEntity cloudObject = new CloudObjectEntity(VchsObjectType.CLOUD, id, payload);
                cloudObject.getObjectProperties().put("isShared", "true");
                cloudObject.getObjectProperties().put("regionId", regionId);
                cloudObjects.add(cloudObject);
            }
        }
        return cloudObjects;
    }
}

