/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.cache.vpc.impl;

import com.vmware.ares.vcd.v1.NetworkSnapshotListType;
import com.vmware.ares.vcd.v1.NetworkSnapshotType;
import com.vmware.ares.vcd.v1.VdcUserType;
import com.vmware.ares.vcd.v1.VdcUsersType;
import com.vmware.ares.vcd.v2.VdcSnapshotListType;
import com.vmware.ares.vcd.v2.VdcSnapshotType;
import com.vmware.ares.vcd.v2.VdcType;
import com.vmware.vcim.ngc.service.cache.common.CloudObjectEntity;
import com.vmware.vcim.ngc.service.cache.helper.DatacenterVpcHelper;
import com.vmware.vcim.ngc.service.cache.helper.VpcHelper;
import com.vmware.vcim.ngc.service.cache.jaxbwrapper.NetworkSnapshotTypeWrapper;
import com.vmware.vcim.ngc.service.cache.jaxbwrapper.VdcSnapshotTypeWrapper;
import com.vmware.vcim.ngc.service.cache.jaxbwrapper.VdcTypeWrapper;
import com.vmware.vcim.ngc.service.cache.jaxbwrapper.VdcUserTypeWrapper;
import com.vmware.vcim.ngc.service.impl.VcimSessionManager;
import com.vmware.vcim.ngc.service.model.VchsObjectType;
import com.vmware.vcim.ngc.service.rest.vcim.VcimRestClient;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.springframework.http.ResponseEntity;

public class DatacenterVpcHelperImpl
extends VpcHelper
implements DatacenterVpcHelper {
    private JAXBContext vdcSnapshotTypeWrapperContext;
    private JAXBContext vdcTypeWrapperContext;
    private JAXBContext vdcUserTypeWrapperContext;
    private JAXBContext networkSnapshotTypeWrapperContext;

    public DatacenterVpcHelperImpl(VcimRestClient vcimRestClient, VcimSessionManager vcimSessionMgr) {
        super(vcimRestClient, vcimSessionMgr);
        try {
            this.vdcSnapshotTypeWrapperContext = JAXBContext.newInstance((Class[])new Class[]{VdcSnapshotTypeWrapper.class});
            this.vdcTypeWrapperContext = JAXBContext.newInstance((Class[])new Class[]{VdcTypeWrapper.class});
            this.vdcUserTypeWrapperContext = JAXBContext.newInstance((Class[])new Class[]{VdcUserTypeWrapper.class});
            this.networkSnapshotTypeWrapperContext = JAXBContext.newInstance((Class[])new Class[]{NetworkSnapshotTypeWrapper.class});
        }
        catch (JAXBException jAXBException) {
            // empty catch block
        }
    }

    @Override
    public List<CloudObjectEntity> getDatacenters(String clientSessionId, CloudObjectEntity cloudObject) {
        String url = "/api/private/region/<REGION_ID>/vdcs";
        url = url.replace("<REGION_ID>", cloudObject.getObjectProperties().get("regionId"));
        ResponseEntity vdcResponse = (ResponseEntity)this.vcimRestClient.sendGetRequest(url, VdcSnapshotListType.class, null, clientSessionId);
        ArrayList<CloudObjectEntity> vdcObjects = new ArrayList<CloudObjectEntity>();
        if (null != vdcResponse) {
            VdcSnapshotListType vdcs = (VdcSnapshotListType)vdcResponse.getBody();
            String cloudId = cloudObject.getId();
            cloudId = cloudId.substring(cloudId.indexOf("~") + 1);
            boolean isShared = Boolean.parseBoolean(cloudObject.getObjectProperties().get("isShared"));
            for (VdcSnapshotType vdc : vdcs.getVdcSnapshot()) {
                if ((!cloudId.equals(vdc.getCloudId()) || isShared) && (!cloudId.equals(vdc.getId()) || !isShared)) continue;
                VdcSnapshotTypeWrapper vdcSnapshotTypeWrapper = new VdcSnapshotTypeWrapper();
                vdcSnapshotTypeWrapper.setVdcSnapshotType(vdc);
                String payload = this.marshal(this.vdcSnapshotTypeWrapperContext, vdcSnapshotTypeWrapper);
                CloudObjectEntity vdcObject = new CloudObjectEntity(VchsObjectType.DATACENTER, vdc.getId(), payload);
                vdcObject.setObjectProperties(cloudObject.getObjectProperties());
                vdcObject.getObjectProperties().put("cloudId", cloudObject.getId());
                vdcObjects.add(vdcObject);
            }
        }
        return vdcObjects;
    }

    @Override
    public CloudObjectEntity getDatacenterDetails(String clientSessionId, CloudObjectEntity cloudObject) {
        String url = "/api/private/dc/<VPC_ID>/vdc/<VDC_ID>";
        boolean isShared = Boolean.parseBoolean(cloudObject.getObjectProperties().get("isShared"));
        if (!isShared) {
            String cloudId = cloudObject.getObjectProperties().get("cloudId");
            cloudId = cloudId.substring(cloudId.indexOf("~") + 1);
            url = url.replace("<VPC_ID>", cloudId);
        } else {
            url = "/api/private/vpc/<VDC_ID>";
        }
        String vdcId = cloudObject.getId();
        url = url.replace("<VDC_ID>", vdcId);
        ResponseEntity response = (ResponseEntity)this.vcimRestClient.sendGetRequest(url, VdcType.class, null, clientSessionId);
        VdcType vdcType = (VdcType)response.getBody();
        VdcTypeWrapper vdcTypeWrapper = new VdcTypeWrapper();
        vdcTypeWrapper.setVdcType(vdcType);
        String payload = this.marshal(this.vdcTypeWrapperContext, vdcTypeWrapper);
        CloudObjectEntity vdcDetailObject = new CloudObjectEntity(VchsObjectType.DATACENTER_DETAIL, vdcId, payload);
        return vdcDetailObject;
    }

    @Override
    public List<CloudObjectEntity> getDatacenterUsers(String clientSessionId, CloudObjectEntity vdcObject) {
        boolean isShared = Boolean.parseBoolean(vdcObject.getObjectProperties().get("isShared"));
        String url = "/api/private/dc/<VPC_ID>/vdc/<VDC_ID>/useraccess";
        if (!isShared) {
            String cloudId = vdcObject.getObjectProperties().get("cloudId");
            cloudId = cloudId.substring(cloudId.indexOf("~") + 1);
            url = url.replace("<VPC_ID>", cloudId);
        } else {
            url = "/api/private/vpc/<VDC_ID>/useraccess";
        }
        url = url.replace("<VDC_ID>", vdcObject.getId());
        ResponseEntity response = (ResponseEntity)this.vcimRestClient.sendGetRequest(url, VdcUsersType.class, null, clientSessionId);
        VdcUsersType vdcUsers = (VdcUsersType)response.getBody();
        ArrayList<CloudObjectEntity> userObjects = new ArrayList<CloudObjectEntity>();
        if (null != vdcUsers) {
            for (VdcUserType vdcUser : vdcUsers.getVdcUser()) {
                VdcUserTypeWrapper vdcUserTypeWrapper = new VdcUserTypeWrapper();
                vdcUserTypeWrapper.setVdcUserType(vdcUser);
                String payload = this.marshal(this.vdcUserTypeWrapperContext, vdcUserTypeWrapper);
                String id = vdcObject.getId() + "~" + vdcUser.getId();
                CloudObjectEntity userObject = new CloudObjectEntity(VchsObjectType.DATACENTER_USER, id, payload);
                userObject.setObjectProperties(vdcObject.getObjectProperties());
                userObject.getObjectProperties().put("vdcId", vdcObject.getId());
                userObjects.add(userObject);
            }
        }
        return userObjects;
    }

    @Override
    public List<CloudObjectEntity> getDatacenterNetworks(String clientSessionId, CloudObjectEntity vdcObject) {
        boolean isShared = Boolean.parseBoolean(vdcObject.getObjectProperties().get("isShared"));
        boolean isDR2C = Boolean.parseBoolean(vdcObject.getObjectProperties().get("isDR2C"));
        NetworkSnapshotListType networkSnapshotListType = null;
        String url = "/api/private/dc/<VPC_ID>/vdc/<VDC_ID>/networks";
        if (!isShared) {
            String cloudId = vdcObject.getObjectProperties().get("cloudId");
            cloudId = cloudId.substring(cloudId.indexOf("~") + 1);
            url = url.replace("<VPC_ID>", cloudId);
        } else {
            url = true == isDR2C ? "/api/private/dr2c/<VDC_ID>/networks" : "/api/private/vpc/<VDC_ID>/networks";
        }
        String vdcId = vdcObject.getId();
        url = url.replace("<VDC_ID>", vdcId);
        ArrayList<CloudObjectEntity> networkObjects = new ArrayList<CloudObjectEntity>();
        ResponseEntity response = (ResponseEntity)this.vcimRestClient.sendGetRequest(url, NetworkSnapshotListType.class, null, clientSessionId);
        networkSnapshotListType = (NetworkSnapshotListType)response.getBody();
        for (NetworkSnapshotType networkSnapshot : networkSnapshotListType.getNetworkSnapshot()) {
            NetworkSnapshotTypeWrapper networkSnapshotTypeWrapper = new NetworkSnapshotTypeWrapper();
            networkSnapshotTypeWrapper.setNetworkSnapshotType(networkSnapshot);
            String payload = this.marshal(this.networkSnapshotTypeWrapperContext, networkSnapshotTypeWrapper);
            CloudObjectEntity networkObject = new CloudObjectEntity(VchsObjectType.NETWORK, networkSnapshot.getId(), payload);
            networkObject.setObjectProperties(vdcObject.getObjectProperties());
            networkObject.getObjectProperties().put("vdcId", vdcObject.getId());
            networkObjects.add(networkObject);
        }
        return networkObjects;
    }
}

