/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.common;

import com.vmware.ares.company.v1.RoleType;
import com.vmware.vcim.ngc.service.common.AccessController;
import com.vmware.vcim.ngc.service.common.CommonUtils;
import com.vmware.vcim.ngc.service.impl.VCimSession;
import com.vmware.vcim.ngc.service.impl.VcimSessionManager;
import com.vmware.vise.usersession.UserSessionService;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public class AccessControllerImpl
implements AccessController {
    private UserSessionService userSessionService;
    private VcimSessionManager vcimSessionMgr;
    Map<String, Set<String>> operationAccess = new HashMap<String, Set<String>>();

    public AccessControllerImpl(UserSessionService userSessionService, VcimSessionManager vcimSessionMgr) {
        this.userSessionService = userSessionService;
        this.vcimSessionMgr = vcimSessionMgr;
        this.populateOperationToRolesMapping();
    }

    @Override
    public boolean operationAllowed(String operation) {
        Set<String> permittedRoles = this.operationAccess.get(operation);
        String sessionId = this.getClientSessionId();
        VCimSession session = this.vcimSessionMgr.getSession(sessionId);
        List<RoleType> roles = session.getVchsSession().getUser().getRoles();
        for (RoleType role : roles) {
            if (!permittedRoles.contains(role.getName())) continue;
            return true;
        }
        return false;
    }

    private void populateOperationToRolesMapping() {
        ResourceBundle rb = ResourceBundle.getBundle("roleMapping");
        Enumeration<String> keys = rb.getKeys();
        while (keys.hasMoreElements()) {
            HashSet<String> roles = new HashSet<String>();
            String key = keys.nextElement();
            String str = rb.getString(key);
            String[] lst = str.split(",");
            for (int i = 0; i < lst.length; ++i) {
                roles.add(lst[i].trim());
            }
            this.operationAccess.put(key, roles);
        }
    }

    private String getClientSessionId() {
        return CommonUtils.getClientSessionId(this.userSessionService);
    }
}

