/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.impl;

import com.vmware.vcim.ngc.service.adapter.common.AdapterWrapper;
import com.vmware.vcim.ngc.service.contracts.UserService;
import com.vmware.vcim.ngc.service.impl.VCimDataService;
import com.vmware.vcim.ngc.service.model.UserRole;
import com.vmware.vcim.ngc.service.model.VCimUser;
import com.vmware.vcim.ngc.service.model.VchsObjectType;
import com.vmware.vcim.ngc.service.vpc.contracts.UserOperations;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.uri.ResourceTypeResolverRegistry;
import com.vmware.vise.usersession.UserSessionService;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@type(value="comvmwarevcimngc:User")
public class UserDataService
extends VCimDataService
implements UserService {
    private AdapterWrapper adapterWrapper;
    private static final String USER_DSN = "comvmwarevcimngc:User";

    public UserDataService(ResourceTypeResolverRegistry resourceTypeResolverRegistry, UserSessionService userSessionService, AdapterWrapper adapterWrapper) {
        super(USER_DSN, resourceTypeResolverRegistry, userSessionService);
        this.resourceTypeResolverRegistry = resourceTypeResolverRegistry;
        this.userSessionService = userSessionService;
        this.adapterWrapper = adapterWrapper;
    }

    @Override
    protected List<ResultItem> processSimpleConstraint(Constraint constraint, PropertySpec[] propertySpecs, ResultSpec resultSpec) {
        ArrayList<ResultItem> items = new ArrayList<ResultItem>();
        List<?> users = null;
        if (USER_DSN.equals(constraint.targetType)) {
            String sessionId = this.getClientSessionId();
            String cacheKey = sessionId + "#" + USER_DSN + "#" + "ALL";
            boolean cacheHit = false;
            if (null != resultSpec) {
                if (0 != resultSpec.offset) {
                    this.cacheUtil.invalidateCacheEntry(sessionId);
                } else {
                    List<?> objects = this.cacheUtil.getEntry(cacheKey, resultSpec.offset, resultSpec.maxResultCount);
                    if (null != objects) {
                        cacheHit = true;
                        users = objects;
                    }
                }
            }
            if (!cacheHit) {
                String key = "GET_ALL_USERS#" + sessionId;
                users = (List)this.queryUtil.getResults(key, new Object[0]);
                this.cacheUtil.addEntry(cacheKey, users);
            }
            for (VCimUser user : users) {
                ResultItem ri = this.getUserProperties(user, propertySpecs);
                if (null == ri) continue;
                items.add(ri);
            }
        }
        return items;
    }

    @Override
    protected Object getObject(Object target) {
        return this.getUsersReadOnlyAdapter().getUser(this.getClientSessionId(), (URI)target);
    }

    @Override
    protected ResultItem getObjectProperties(Object object, PropertySpec[] propertySpecs) {
        return this.getUserProperties((VCimUser)object, propertySpecs);
    }

    @Override
    protected List<ResultItem> processRelationalConstraint(Constraint constraint, PropertySpec[] propertySpecs, ResultSpec resultSpec) {
        RelationalConstraint rc = (RelationalConstraint)constraint;
        assert (rc != null);
        assert (rc.constraintOnRelatedObject instanceof ObjectIdentityConstraint);
        ArrayList<ResultItem> returnItems = new ArrayList<ResultItem>();
        return returnItems;
    }

    private ResultItem getUserProperties(VCimUser user, PropertySpec[] propertySpecs) {
        ResultItem ri = new ResultItem();
        StringBuilder name = new StringBuilder();
        ArrayList<PropertyValue> pvs = new ArrayList<PropertyValue>();
        ri.resourceObject = user.getUri();
        HashMap<String, Field> objFields = new HashMap<String, Field>();
        Field[] fields = user.getClass().getDeclaredFields();
        for (int index = 0; index < fields.length; ++index) {
            objFields.put(fields[index].getName(), fields[index]);
        }
        for (PropertySpec ps : propertySpecs) {
            if (!USER_DSN.equals(ps.type)) continue;
            for (String prop : ps.propertyNames) {
                PropertyValue pv = new PropertyValue();
                List<UserRole> propValue = this.UNSUPPORTED_PROPERTY_FLAG;
                if (prop.equals("name")) {
                    propValue = name.append(user.getLastName()).append(",").append(user.getFirstName()).toString();
                } else if (prop.equals("id")) {
                    propValue = user.getId();
                } else if (prop.equals("email")) {
                    propValue = user.getEmail();
                } else if (prop.equals("firstName")) {
                    propValue = user.getFirstName();
                } else if (prop.equals("lastName")) {
                    propValue = user.getLastName();
                } else if (prop.equals("userStatus")) {
                    propValue = user.getUserStatus();
                } else if (prop.equals("userRole")) {
                    propValue = user.getUserRole();
                }
                pv.value = propValue;
                if (pv.value == this.UNSUPPORTED_PROPERTY_FLAG) continue;
                pv.resourceObject = user.getUri();
                pv.propertyName = prop;
                pvs.add(pv);
            }
        }
        ri.properties = pvs.toArray(new PropertyValue[0]);
        return ri;
    }

    @Override
    public VCimUser getUser(Object userUri) {
        return this.getUsersReadOnlyAdapter().getUser(this.getClientSessionId(), (URI)userUri);
    }

    @Override
    public void changeUserStatus(String userId, boolean userStatus) {
        this.getUsersAdapter().changeUserStatus(this.getClientSessionId(), userId, userStatus);
    }

    @Override
    public void deleteUser(String userId) {
        this.getUsersAdapter().deleteUser(this.getClientSessionId(), userId);
    }

    @Override
    public void resetPassword(String userId) {
        this.getUsersAdapter().resetPassword(this.getClientSessionId(), userId);
    }

    @Override
    public Object execute(String identifier, Object ... arguments) {
        String sessionId = this.getClientSessionId();
        if (identifier.startsWith("GET_ALL_USERS#")) {
            return this.getUsersReadOnlyAdapter().getUsers(sessionId);
        }
        return null;
    }

    private UserOperations getUsersReadOnlyAdapter() {
        return (UserOperations)((Object)this.adapterWrapper.getReadOnlyAdapter(VchsObjectType.DATACENTER_USER));
    }

    private UserOperations getUsersAdapter() {
        return (UserOperations)((Object)this.adapterWrapper.getWritableAdapter(VchsObjectType.DATACENTER_USER));
    }
}

