/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.impl;

import com.vmware.vcim.ngc.service.common.CacheUtil;
import com.vmware.vcim.ngc.service.common.CacheUtilImpl;
import com.vmware.vcim.ngc.service.common.CommonUtils;
import com.vmware.vcim.ngc.service.common.QueryCallback;
import com.vmware.vcim.ngc.service.common.QueryUtil;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataProviderAdapter;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.uri.ResourceTypeResolverRegistry;
import com.vmware.vise.usersession.UserSessionService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class VCimDataService
implements DataProviderAdapter,
QueryCallback {
    protected final Object UNSUPPORTED_PROPERTY_FLAG = new Object();
    protected ResourceTypeResolverRegistry resourceTypeResolverRegistry;
    protected UserSessionService userSessionService;
    protected QueryUtil queryUtil;
    protected CacheUtil cacheUtil;
    protected String instanceDSN;

    public VCimDataService(String instanceDSN, ResourceTypeResolverRegistry resourceTypeResolverRegistry, UserSessionService userSessionService) {
        this.instanceDSN = instanceDSN;
        this.resourceTypeResolverRegistry = resourceTypeResolverRegistry;
        this.userSessionService = userSessionService;
        this.queryUtil = new QueryUtil(this);
        this.cacheUtil = CacheUtilImpl.getInstance();
    }

    public void unregisterScheme() {
    }

    public Response getData(RequestSpec rs) throws Exception {
        Response response = new Response();
        QuerySpec[] querySpecs = rs.querySpec;
        ArrayList<ResultSet> results = new ArrayList<ResultSet>(querySpecs.length);
        for (QuerySpec qs : querySpecs) {
            if (qs.name.startsWith("dam-auto-generated: ActionWrapper")) {
                results.addAll(this.processQueriesForActions(querySpecs));
                break;
            }
            ResultSet oneResult = this.processQuery(qs);
            results.add(oneResult);
        }
        response.resultSet = results.toArray(new ResultSet[0]);
        return response;
    }

    protected List<ResultSet> processQueriesForActions(QuerySpec[] querySpecs) {
        ArrayList<ResultSet> resultSets = new ArrayList<ResultSet>();
        Object objInstance = null;
        for (QuerySpec qs : querySpecs) {
            if (objInstance == null) {
                ObjectIdentityConstraint oic = (ObjectIdentityConstraint)((CompositeConstraint)qs.resourceSpec.constraint).nestedConstraints[0];
                objInstance = this.getObject(oic.target);
            }
            ArrayList<ResultItem> items = new ArrayList<ResultItem>();
            ResultItem ri = this.getObjectProperties(objInstance, qs.resourceSpec.propertySpecs);
            if (ri != null) {
                items.add(ri);
            }
            ResultSet rs = new ResultSet();
            rs.items = items.toArray(new ResultItem[items.size()]);
            rs.queryName = qs.name;
            resultSets.add(rs);
        }
        return resultSets;
    }

    protected ResultSet processQuery(QuerySpec qs) {
        ResultSet rs = new ResultSet();
        ExtendedResultSpec extResultSpec = new ExtendedResultSpec(qs.resultSpec);
        List<ResultItem> items = this.processConstraint(qs.resourceSpec.constraint, qs.resourceSpec.propertySpecs, extResultSpec);
        rs.totalMatchedObjectCount = items != null ? items.size() : 0;
        rs.items = this.applyResultSpec(items, extResultSpec);
        rs.queryName = qs.name;
        return rs;
    }

    protected List<ResultItem> processConstraint(Constraint constraint, PropertySpec[] propertySpecs, ResultSpec resultSpec) {
        List<ResultItem> items = null;
        if (constraint.getClass().getSimpleName().equals(Constraint.class.getSimpleName())) {
            items = this.processSimpleConstraint(constraint, propertySpecs, resultSpec);
        } else if (constraint instanceof ObjectIdentityConstraint) {
            items = this.processObjectIdentityConstraint(constraint, propertySpecs, resultSpec);
        } else if (constraint instanceof CompositeConstraint) {
            items = this.processCompositeConstraint((CompositeConstraint)constraint, propertySpecs, resultSpec);
        } else if (constraint instanceof RelationalConstraint) {
            items = this.processRelationalConstraint((Constraint)((RelationalConstraint)constraint), propertySpecs, resultSpec);
        } else if (constraint instanceof PropertyConstraint) {
            items = this.processPropertyConstraint((PropertyConstraint)constraint, propertySpecs, resultSpec);
        }
        return items;
    }

    protected List<ResultItem> processPropertyConstraint(PropertyConstraint constraint, PropertySpec[] propertySpecs, ResultSpec resultSpec) {
        List<ResultItem> items = null;
        assert (resultSpec instanceof ExtendedResultSpec);
        ((ExtendedResultSpec)resultSpec).addPropertyConstraint(constraint);
        return items;
    }

    protected abstract List<ResultItem> processSimpleConstraint(Constraint var1, PropertySpec[] var2, ResultSpec var3);

    protected List<ResultItem> processObjectIdentityConstraint(Constraint constraint, PropertySpec[] propertySpecs, ResultSpec resultSpec) {
        Object objInstance;
        ResultItem ri;
        ArrayList<ResultItem> items = new ArrayList<ResultItem>();
        ObjectIdentityConstraint objectID = (ObjectIdentityConstraint)constraint;
        if (this.instanceDSN.equals(constraint.targetType) && (ri = this.getObjectProperties(objInstance = this.getObject(objectID.target), propertySpecs)) != null) {
            items.add(ri);
        }
        return items;
    }

    protected abstract Object getObject(Object var1);

    protected abstract ResultItem getObjectProperties(Object var1, PropertySpec[] var2);

    protected abstract List<ResultItem> processRelationalConstraint(Constraint var1, PropertySpec[] var2, ResultSpec var3);

    protected List<ResultItem> processCompositeConstraint(CompositeConstraint compositeConstraint, PropertySpec[] propertySpecs, ResultSpec resultSpec) {
        List<ResultItem> resultItems;
        block4: {
            block5: {
                resultItems = new ArrayList<ResultItem>();
                if (Conjoiner.AND != compositeConstraint.conjoiner) break block5;
                for (Constraint constraint : compositeConstraint.nestedConstraints) {
                    List<ResultItem> items = this.processConstraint(constraint, propertySpecs, resultSpec);
                    if (0 == items.size()) continue;
                    if (0 == resultItems.size()) {
                        resultItems = items;
                        continue;
                    }
                    if (0 != (resultItems = this.intersect(resultItems, items)).size()) {
                        continue;
                    }
                    break block4;
                }
                break block4;
            }
            if (Conjoiner.OR != compositeConstraint.conjoiner) break block4;
            for (Constraint constraint : compositeConstraint.nestedConstraints) {
                List<ResultItem> items = this.processConstraint(constraint, propertySpecs, resultSpec);
                if (items == null) continue;
                resultItems.addAll(items);
            }
        }
        return resultItems;
    }

    protected List<ResultItem> intersect(List<ResultItem> list1, List<ResultItem> list2) {
        ArrayList<ResultItem> list3 = new ArrayList<ResultItem>();
        block0: for (ResultItem item1 : list1) {
            String uid1 = item1.resourceObject.toString();
            if (null == uid1) continue;
            for (ResultItem item2 : list2) {
                String uid2 = item2.resourceObject.toString();
                if (!uid1.equals(uid2)) continue;
                list3.add(item1);
                continue block0;
            }
        }
        return list3;
    }

    protected ResultItem[] applyResultSpec(List<ResultItem> originalResultItems, ResultSpec resultSpec) {
        Map<String, String> propertyMap;
        List<ResultItem> items = originalResultItems;
        if (resultSpec instanceof ExtendedResultSpec && (propertyMap = ((ExtendedResultSpec)resultSpec).getPropertyMap()) != null && propertyMap.size() > 0) {
            items = new LinkedList<ResultItem>();
            for (ResultItem item : originalResultItems) {
                for (PropertyValue propValue : item.properties) {
                    if (!propertyMap.containsKey(propValue.propertyName)) continue;
                    String value = propertyMap.get(propValue.propertyName);
                    if (!propValue.value.toString().toLowerCase().contains(value.toLowerCase())) continue;
                    items.add(item);
                }
            }
        }
        return items.toArray(new ResultItem[items.size()]);
    }

    protected String getClientSessionId() {
        return CommonUtils.getClientSessionId(this.userSessionService);
    }

    protected class ExtendedResultSpec
    extends ResultSpec {
        private Map<String, String> propertyMap = new HashMap<String, String>();

        public ExtendedResultSpec(ResultSpec resultSpec) {
            this.order = resultSpec.order;
            this.maxResultCount = resultSpec.maxResultCount;
            this.offset = resultSpec.offset;
        }

        public void addPropertyConstraint(PropertyConstraint propConstraint) {
            assert (propConstraint.comparator == Comparator.TEXTUALLY_MATCHES);
            this.propertyMap.put(propConstraint.propertyName, propConstraint.comparableValue.toString());
        }

        public Map<String, String> getPropertyMap() {
            return this.propertyMap;
        }
    }
}

