/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.impl;

import com.vmware.vcim.ngc.service.impl.VCimDataService;
import com.vmware.vcim.ngc.service.impl.VCimSession;
import com.vmware.vcim.ngc.service.impl.VcimSessionManager;
import com.vmware.vcim.ngc.service.tasks.TaskService;
import com.vmware.vcim.ngc.service.tasks.VCimTask;
import com.vmware.vcim.ngc.service.tasks.impl.TaskAssembler;
import com.vmware.vcim.ngc.service.vpc.notification.impl.VcimNotificationChannelMgr;
import com.vmware.vise.core.model.monitor.ClientTaskInfo;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.type;
import com.vmware.vise.usersession.UserSessionService;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@type(value="vsphere:Task")
public class VCimTasksDataService
extends VCimDataService {
    private TaskService taskService;
    private VcimNotificationChannelMgr notificationChannelMgr;
    private VcimSessionManager vcimSessionMgr;
    private TaskAssembler taskAssembler = new TaskAssembler();
    private static final Logger logger = LoggerFactory.getLogger(VCimTasksDataService.class);

    public VCimTasksDataService(UserSessionService userSessionService, VcimSessionManager vcimSessionMgr, TaskService taskService, VcimNotificationChannelMgr notificationChannelMgr) {
        super(null, null, userSessionService);
        this.vcimSessionMgr = vcimSessionMgr;
        this.taskService = taskService;
        this.notificationChannelMgr = notificationChannelMgr;
    }

    @Override
    protected ResultSet processQuery(QuerySpec qs) {
        ResultSet result = new ResultSet();
        result.totalMatchedObjectCount = 0;
        result.queryName = qs.name;
        VCimSession session = this.vcimSessionMgr.getSession(this.getClientSessionId());
        if (null != session) {
            session.setLastActivityTimeStamp(new Date());
            this.notificationChannelMgr.reEstablishNotificationChannel(session);
            return this.processConstraint(qs, session);
        }
        return result;
    }

    public ResultSet processConstraint(QuerySpec spec, VCimSession session) {
        ResultSet result = null;
        List<VCimTask> tasks = this.taskService.getTasks(session.getVchsSession().getUser().getUserName());
        ArrayList<ClientTaskInfo> allRuns = new ArrayList<ClientTaskInfo>();
        Constraint constraint = spec.resourceSpec.constraint;
        PropertyConstraint[] constraints = null;
        if (constraint instanceof PropertyConstraint) {
            constraints = new PropertyConstraint[]{(PropertyConstraint)constraint};
        } else if (constraint instanceof CompositeConstraint) {
            CompositeConstraint compositeConstraint = (CompositeConstraint)constraint;
            constraints = compositeConstraint.nestedConstraints;
        }
        for (PropertyConstraint singleConstraint : constraints) {
            if (!(singleConstraint instanceof PropertyConstraint)) continue;
            PropertyConstraint propConstraint = singleConstraint;
            String propertyName = propConstraint.propertyName;
            Comparator comparator = propConstraint.comparator;
            if (!"info.rootTasks".equals(propertyName) || Comparator.EQUALS != comparator) continue;
            Object[] keys = (Object[])propConstraint.comparableValue;
            ArrayList<String> rootTaskKeysList = new ArrayList<String>();
            for (Object objKey : keys) {
                rootTaskKeysList.add((String)objKey);
            }
            HashSet<String> rootTaskKeys = new HashSet<String>();
            rootTaskKeys.addAll(rootTaskKeysList);
            for (int index = 0; index < tasks.size(); ++index) {
                VCimTask task = tasks.get(index);
                if (!rootTaskKeys.contains("key-" + task.getId())) continue;
                allRuns.add(this.taskAssembler.buildClientTaskInfo(task));
            }
            result = this.createResultSet(allRuns, spec);
            return result;
        }
        for (int index = 0; index < tasks.size(); ++index) {
            VCimTask task = tasks.get(index);
            allRuns.add(this.taskAssembler.buildClientTaskInfo(task));
        }
        result = this.createResultSet(allRuns, spec);
        return result;
    }

    private ResultSet createResultSet(List<ClientTaskInfo> infos, QuerySpec spec) {
        ResultSet result = new ResultSet();
        result.totalMatchedObjectCount = infos.size();
        result.queryName = spec.name;
        result.items = new ResultItem[infos.size()];
        logger.info(infos.size() + " tasks available");
        int index = 0;
        for (ClientTaskInfo info : infos) {
            ResultItem item = new ResultItem();
            PropertyValue value = new PropertyValue();
            value.propertyName = "info";
            value.value = info;
            item.properties = new PropertyValue[]{value};
            URI uri = null;
            try {
                uri = new URI("urn:vri", "Task:" + info.key, null);
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
            item.resourceObject = uri;
            result.items[index++] = item;
        }
        return result;
    }

    @Override
    public Object execute(String identifier, Object ... arguments) {
        return null;
    }

    @Override
    protected List<ResultItem> processSimpleConstraint(Constraint constraint, PropertySpec[] propertySpecs, ResultSpec resultSpec) {
        return null;
    }

    @Override
    protected Object getObject(Object target) {
        return null;
    }

    @Override
    protected ResultItem getObjectProperties(Object object, PropertySpec[] propertySpecs) {
        return null;
    }

    @Override
    protected List<ResultItem> processRelationalConstraint(Constraint constraint, PropertySpec[] propertySpecs, ResultSpec resultSpec) {
        return null;
    }
}

