/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.impl;

import com.vmware.vcim.ngc.service.cache.common.CacheController;
import com.vmware.vcim.ngc.service.cache.model.CacheEntry;
import com.vmware.vcim.ngc.service.common.AccessController;
import com.vmware.vcim.ngc.service.common.CommonUtils;
import com.vmware.vcim.ngc.service.contracts.UtilityService;
import com.vmware.vcim.ngc.service.impl.VCimAuthenticator;
import com.vmware.vcim.ngc.service.impl.VCimSession;
import com.vmware.vcim.ngc.service.impl.VcimSessionManager;
import com.vmware.vcim.ngc.service.model.AuthenticatedUser;
import com.vmware.vcim.ngc.service.tasks.impl.TaskCompletedBroadcaster;
import com.vmware.vcim.ngc.service.vpc.notification.impl.VcimNotificationChannelMgr;
import com.vmware.vise.security.ClientSessionEndListener;
import com.vmware.vise.usersession.UserSessionService;
import flex.messaging.MessageBroker;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.flex.messaging.MessageTemplate;

public class VCimUtilityService
implements UtilityService,
ClientSessionEndListener {
    private static final Logger logger = LoggerFactory.getLogger(VCimUtilityService.class);
    private UserSessionService userSessionService;
    private VCimAuthenticator vCimAuthenticator;
    private VcimNotificationChannelMgr notificationManager;
    private AccessController mappper;
    private CacheController cacheController;
    private VcimSessionManager vcimSessionMgr;
    private TaskCompletedBroadcaster taskBroadcaster;
    private MessageTemplate template;

    public VCimUtilityService(UserSessionService userSessionService, VCimAuthenticator authenticator, VcimSessionManager vcimSessionMgr, VcimNotificationChannelMgr notificationManager, AccessController access, CacheController cacheController, MessageTemplate template, TaskCompletedBroadcaster taskBroadcaster) {
        this.userSessionService = userSessionService;
        this.vCimAuthenticator = authenticator;
        this.vcimSessionMgr = vcimSessionMgr;
        this.notificationManager = notificationManager;
        this.mappper = access;
        this.cacheController = cacheController;
        this.template = template;
        this.taskBroadcaster = taskBroadcaster;
    }

    public CacheController getCacheController() {
        return this.cacheController;
    }

    @Override
    public boolean isRegisteredToVPC() {
        return this.vCimAuthenticator.isRegisteredToVPC(this.getClientSessionId());
    }

    @Override
    public AuthenticatedUser loginToVPC(String vpcUrl, String username, String password, boolean isCredEncrypted, String proxyUrl, String proxyPort, String proxyUsername, String proxyPassword, boolean useProxy) {
        CacheEntry cacheUser;
        MessageBroker messageBroker = this.template.getMessageBroker();
        this.taskBroadcaster.setMessageBroker(messageBroker);
        AuthenticatedUser authUser = this.vCimAuthenticator.login(this.getClientSessionId(), vpcUrl, username, password, isCredEncrypted, proxyUrl, proxyPort, proxyUsername, proxyPassword, useProxy);
        VCimSession session = this.vcimSessionMgr.getSession(this.getClientSessionId());
        authUser.setTxtUsername(session.getVchsSession().getUser().getUserName());
        if (this.cacheController.isCacheAvailable() && null == (cacheUser = this.cacheController.getCacheEntryForUser(session.getVchsSession().getUser().getUserName()))) {
            this.cacheController.loadObjectTreeForUser(session.getVchsSession().getUser().getUserName());
        }
        this.notificationManager.openNotificationChannel(session);
        return authUser;
    }

    private String getClientSessionId() {
        return CommonUtils.getClientSessionId(this.userSessionService);
    }

    @Override
    public void logout() {
        String sessionId = this.getClientSessionId();
        this.logout(sessionId);
    }

    private void logout(String sessionId) {
        VCimSession session = this.vcimSessionMgr.getSession(sessionId);
        if (null == session) {
            logger.info("May be session was already killed due to inactivity for client id - " + sessionId + ". Skipping terminating notification channel");
            return;
        }
        this.cacheController.cleanUpCache(session.getUsername());
        String username = session.getVchsSession().getUser().getUserName().toLowerCase();
        this.notificationManager.closeChannel(username);
        this.vCimAuthenticator.logout(sessionId);
    }

    public void sessionEnded(String clientId) {
        this.logout(clientId);
    }

    @Override
    public AuthenticatedUser acceptTos() {
        String sessionId = this.getClientSessionId();
        AuthenticatedUser authUser = this.vCimAuthenticator.acceptTos(sessionId);
        VCimSession session = this.vcimSessionMgr.getSession(sessionId);
        authUser.setTxtUsername(session.getVchsSession().getUser().getUserName());
        this.notificationManager.openNotificationChannel(session);
        return authUser;
    }

    @Override
    public AuthenticatedUser getLoggedInUser() {
        String sessionId = this.getClientSessionId();
        AuthenticatedUser authUser = this.vCimAuthenticator.getAuthenticatedUserFromVCimSession(sessionId);
        return authUser;
    }

    @Override
    public Boolean isOperationAllowed(String operation) {
        return this.mappper.operationAllowed(operation);
    }

    @Override
    public List<Boolean> areOperationsAllowed(List<String> operations) {
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        for (String operation : operations) {
            result.add(this.mappper.operationAllowed(operation));
        }
        return result;
    }

    public void unregisterBean() {
    }

    @Override
    public void resetCache() {
        VCimSession session = this.vcimSessionMgr.getSession(this.getClientSessionId());
        this.cacheController.loadObjectTreeForUser(session.getVchsSession().getUser().getUserName());
    }
}

