/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.impl;

import com.vmware.vcim.ngc.service.adapter.common.AdapterWrapper;
import com.vmware.vcim.ngc.service.common.AccessController;
import com.vmware.vcim.ngc.service.contracts.VirtualMachineReplicationStatusService;
import com.vmware.vcim.ngc.service.impl.VCimDataService;
import com.vmware.vcim.ngc.service.model.VCimVirtualDatacenter;
import com.vmware.vcim.ngc.service.model.VCimVirtualMachineReplicationStatus;
import com.vmware.vcim.ngc.service.model.VchsObjectType;
import com.vmware.vcim.ngc.service.vpc.contracts.VirtualDatacenterOperations;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.uri.ResourceTypeResolverRegistry;
import com.vmware.vise.usersession.UserSessionService;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@type(value="comvmwarevcimngc:VirtualMachineReplicationStatus")
public class VCimVirtualMachineReplicationStatusDataService
extends VCimDataService
implements VirtualMachineReplicationStatusService {
    private final AccessController accessController;
    private final AdapterWrapper adapterWrapper;
    private static final String STATUS_DSN = "comvmwarevcimngc:VirtualMachineReplicationStatus";

    public VCimVirtualMachineReplicationStatusDataService(ResourceTypeResolverRegistry resourceTypeResolverRegistry, UserSessionService userSessionService, AccessController accessController, AdapterWrapper adapterWrapper) {
        super(STATUS_DSN, resourceTypeResolverRegistry, userSessionService);
        this.accessController = accessController;
        this.adapterWrapper = adapterWrapper;
    }

    @Override
    public Object execute(String identifier, Object ... arguments) {
        String sessionId = this.getClientSessionId();
        if (identifier.startsWith("GET_ALL_STATUSES#")) {
            return this.getVdcReadOnlyAdapter().getVirtualMachineReplicationStatusesForVdc(sessionId, (String)arguments[0]);
        }
        if (identifier.startsWith("GET_STATUS#")) {
            List<VCimVirtualMachineReplicationStatus> statuses;
            if (arguments.length > 0 && (statuses = this.getAllStatuses(sessionId)) != null) {
                for (VCimVirtualMachineReplicationStatus status : statuses) {
                    if (!status.getId().equalsIgnoreCase((String)arguments[0])) continue;
                    return status;
                }
                return null;
            }
            return null;
        }
        if (identifier.startsWith("GET_STATUS_FOR_VDC#") && arguments.length > 0) {
            return this.getVdcReadOnlyAdapter().getVirtualMachineReplicationStatusesForVdc(sessionId, (String)arguments[0]);
        }
        return null;
    }

    @Override
    public VCimVirtualMachineReplicationStatus getVirtualMachineReplicationStatus(Object statusUri) {
        VCimVirtualMachineReplicationStatus status = null;
        String sessionId = this.getClientSessionId();
        String key = "GET_STATUS#" + ((URI)statusUri).toString() + "#" + sessionId;
        status = (VCimVirtualMachineReplicationStatus)this.queryUtil.getResults(key, statusUri);
        return status;
    }

    @Override
    public List<VCimVirtualMachineReplicationStatus> getVirtualMachineReplicationStatusesForVdc(String vdcId) {
        return null;
    }

    @Override
    protected List<ResultItem> processSimpleConstraint(Constraint constraint, PropertySpec[] propertySpecs, ResultSpec resultSpec) {
        ArrayList<ResultItem> items = new ArrayList<ResultItem>();
        List<VCimVirtualMachineReplicationStatus> statuses = null;
        if (STATUS_DSN.equals(constraint.targetType)) {
            String sessionId = this.getClientSessionId();
            String cacheKey = sessionId + "#" + STATUS_DSN + "#" + "ALL";
            boolean cacheHit = false;
            if (null != resultSpec) {
                if (0 == resultSpec.offset) {
                    this.cacheUtil.invalidateCacheEntry(sessionId);
                } else {
                    List<?> objects = this.cacheUtil.getEntry(cacheKey, resultSpec.offset, resultSpec.maxResultCount);
                    if (null != objects) {
                        cacheHit = true;
                        statuses = objects;
                    }
                }
            }
            if (!cacheHit) {
                statuses = this.getAllStatuses(sessionId);
                this.cacheUtil.addEntry(cacheKey, statuses);
            }
            for (VCimVirtualMachineReplicationStatus status : statuses) {
                ResultItem ri = this.getStatusProperties(status, propertySpecs);
                if (null == ri) continue;
                items.add(ri);
            }
        }
        return items;
    }

    private List<VCimVirtualMachineReplicationStatus> getAllStatuses(String sessionId) {
        List statuses = null;
        String key = "GET_ALL_STATUSES#" + sessionId;
        statuses = (List)this.queryUtil.getResults(key, new Object[0]);
        return statuses;
    }

    @Override
    protected Object getObject(Object target) {
        String sessionId = this.getClientSessionId();
        String key = "GET_STATUS#" + ((URI)target).toString() + "#" + sessionId;
        return this.queryUtil.getResults(key, target);
    }

    @Override
    protected ResultItem getObjectProperties(Object object, PropertySpec[] propertySpecs) {
        return this.getStatusProperties((VCimVirtualMachineReplicationStatus)object, propertySpecs);
    }

    @Override
    protected List<ResultItem> processRelationalConstraint(Constraint constraint, PropertySpec[] propertySpecs, ResultSpec resultSpec) {
        ArrayList<ResultItem> items = new ArrayList<ResultItem>();
        RelationalConstraint rc = (RelationalConstraint)constraint;
        assert (rc != null);
        assert (rc.constraintOnRelatedObject instanceof ObjectIdentityConstraint);
        ObjectIdentityConstraint oic = (ObjectIdentityConstraint)rc.constraintOnRelatedObject;
        if (rc.relation.equals("vdcToReplicationStatus")) {
            URI vdcUri = (URI)oic.target;
            String vdcId = VCimVirtualDatacenter.getVdcId(vdcUri);
            String key = "GET_STATUS_FOR_VDC#" + vdcId + "#" + this.getClientSessionId();
            List statuses = (List)this.queryUtil.getResults(key, vdcId);
            for (VCimVirtualMachineReplicationStatus status : statuses) {
                ResultItem ri = this.getStatusProperties(status, propertySpecs);
                if (null == ri) continue;
                items.add(ri);
            }
            return items;
        }
        return this.processSimpleConstraint((Constraint)rc, propertySpecs, null);
    }

    private ResultItem getStatusProperties(VCimVirtualMachineReplicationStatus status, PropertySpec[] propertySpecs) {
        ResultItem ri = new ResultItem();
        ArrayList<PropertyValue> pvs = new ArrayList<PropertyValue>();
        ri.resourceObject = status.getUri();
        HashMap<String, Field> objFields = new HashMap<String, Field>();
        Field[] fields = status.getClass().getDeclaredFields();
        for (int index = 0; index < fields.length; ++index) {
            objFields.put(fields[index].getName(), fields[index]);
        }
        for (PropertySpec ps : propertySpecs) {
            if (!STATUS_DSN.equals(ps.type)) continue;
            for (String prop : ps.propertyNames) {
                PropertyValue pv = new PropertyValue();
                Object propValue = this.UNSUPPORTED_PROPERTY_FLAG;
                if (prop.equals("vmName")) {
                    propValue = status.getName();
                } else if (prop.equals("vmReplicationState")) {
                    propValue = status.getReplicationState();
                } else if (prop.equals("vmLastCompleted")) {
                    propValue = status.getRecoveryCompletionTime();
                } else if (prop.equals("transferDuration")) {
                    propValue = status.getDurationMin();
                } else if (prop.equals("transferSize")) {
                    propValue = status.getBytesGB();
                } else if (prop.equals("rpo")) {
                    propValue = status.getRpohours();
                }
                pv.value = propValue;
                if (pv.value == this.UNSUPPORTED_PROPERTY_FLAG) continue;
                pv.resourceObject = status.getUri();
                pv.propertyName = prop;
                pvs.add(pv);
            }
        }
        ri.properties = pvs.toArray(new PropertyValue[0]);
        return ri;
    }

    private VirtualDatacenterOperations getVdcReadOnlyAdapter() {
        return (VirtualDatacenterOperations)((Object)this.adapterWrapper.getReadOnlyAdapter(VchsObjectType.DATACENTER));
    }
}

