/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.impl;

import com.vmware.ares.common.v1.EntityState;
import com.vmware.ares.common.v2.CloudTypeType;
import com.vmware.vcim.ngc.service.adapter.common.AdapterWrapper;
import com.vmware.vcim.ngc.service.common.AccessController;
import com.vmware.vcim.ngc.service.contracts.VirtualDatacenterService;
import com.vmware.vcim.ngc.service.impl.VCimDataService;
import com.vmware.vcim.ngc.service.model.DR2CVMCount;
import com.vmware.vcim.ngc.service.model.VCimVirtualDatacenter;
import com.vmware.vcim.ngc.service.model.VCimVirtualMachineReplicationStatus;
import com.vmware.vcim.ngc.service.model.VCimVpc;
import com.vmware.vcim.ngc.service.model.VchsObjectType;
import com.vmware.vcim.ngc.service.model.VdcUser;
import com.vmware.vcim.ngc.service.vpc.contracts.CloudInstanceOperations;
import com.vmware.vcim.ngc.service.vpc.contracts.VirtualDatacenterOperations;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.uri.ResourceTypeResolverRegistry;
import com.vmware.vise.usersession.UserSessionService;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@type(value="comvmwarevcimngc:Datacenter")
public class VirtualDatacenterDataService
extends VCimDataService
implements VirtualDatacenterService {
    private final AccessController accessController;
    private final AdapterWrapper adapterWrapper;
    private static final String VIRTUAL_DATACENTER_DSN = "comvmwarevcimngc:Datacenter";
    private static final String EDIT_VDC = "EDIT_VDC";
    private static final String DELETE_VDC = "DELETE_VDC";
    private static final String EDIT_VDC_QUOTA = "EDIT_VDC_QUOTA";
    private static final Logger logger = LoggerFactory.getLogger(VirtualDatacenterDataService.class);

    public VirtualDatacenterDataService(ResourceTypeResolverRegistry resourceTypeResolverRegistry, UserSessionService userSessionService, AccessController accessController, AdapterWrapper adapterWrapper) {
        super(VIRTUAL_DATACENTER_DSN, resourceTypeResolverRegistry, userSessionService);
        this.accessController = accessController;
        this.adapterWrapper = adapterWrapper;
    }

    @Override
    protected List<ResultItem> processSimpleConstraint(Constraint constraint, PropertySpec[] propertySpecs, ResultSpec resultSpec) {
        ArrayList<ResultItem> items = new ArrayList<ResultItem>();
        List<VCimVirtualDatacenter> vDCs = null;
        if (VIRTUAL_DATACENTER_DSN.equals(constraint.targetType)) {
            String sessionId = this.getClientSessionId();
            String cacheKey = sessionId + "#" + VIRTUAL_DATACENTER_DSN + "#" + "ALL";
            boolean cacheHit = false;
            if (null != resultSpec) {
                if (0 == resultSpec.offset) {
                    this.cacheUtil.invalidateCacheEntry(sessionId);
                } else {
                    List<?> objects = this.cacheUtil.getEntry(cacheKey, resultSpec.offset, resultSpec.maxResultCount);
                    if (null != objects) {
                        cacheHit = true;
                        vDCs = objects;
                    }
                }
            }
            if (!cacheHit) {
                vDCs = this.getVDCs();
                this.cacheUtil.addEntry(cacheKey, vDCs);
            }
            if (vDCs != null) {
                for (VCimVirtualDatacenter vDC : vDCs) {
                    ResultItem ri = this.getvDCProperties(vDC, propertySpecs);
                    if (null == ri) continue;
                    items.add(ri);
                }
            }
        }
        return items;
    }

    @Override
    protected Object getObject(Object target) {
        return this.getVDC(target);
    }

    @Override
    protected ResultItem getObjectProperties(Object object, PropertySpec[] propertySpecs) {
        return this.getvDCProperties((VCimVirtualDatacenter)object, propertySpecs);
    }

    @Override
    protected List<ResultItem> processRelationalConstraint(Constraint constraint, PropertySpec[] propertySpecs, ResultSpec resultSpec) {
        ArrayList<ResultItem> items = new ArrayList<ResultItem>();
        RelationalConstraint rc = (RelationalConstraint)constraint;
        assert (rc != null);
        assert (rc.constraintOnRelatedObject instanceof ObjectIdentityConstraint);
        ObjectIdentityConstraint oic = (ObjectIdentityConstraint)rc.constraintOnRelatedObject;
        if (rc.relation.equals("cloudInstanceToVdc")) {
            if (VIRTUAL_DATACENTER_DSN.equals(rc.targetType)) {
                URI vpcUri = (URI)oic.target;
                CloudInstanceOperations cIo = this.getCloudReadOnlyAdapter();
                VCimVpc vpc = cIo.getVpc(this.getClientSessionId(), vpcUri);
                List<VCimVirtualDatacenter> vDCs = this.getVDCsForVpc(vpc.getId());
                if (vDCs != null) {
                    for (VCimVirtualDatacenter vDC : vDCs) {
                        ResultItem ri = this.getvDCProperties(vDC, propertySpecs);
                        if (ri == null) continue;
                        items.add(ri);
                    }
                }
            }
            return items;
        }
        return this.processSimpleConstraint((Constraint)rc, propertySpecs, null);
    }

    private ResultItem getvDCProperties(VCimVirtualDatacenter vDC, PropertySpec[] propertySpecs) {
        ResultItem ri = new ResultItem();
        ArrayList<PropertyValue> pvs = new ArrayList<PropertyValue>();
        ri.resourceObject = vDC.getUri();
        HashMap<String, Field> objFields = new HashMap<String, Field>();
        Field[] fields = vDC.getClass().getDeclaredFields();
        for (int index = 0; index < fields.length; ++index) {
            objFields.put(fields[index].getName(), fields[index]);
        }
        for (PropertySpec ps : propertySpecs) {
            if (!VIRTUAL_DATACENTER_DSN.equals(ps.type)) continue;
            for (String prop : ps.propertyNames) {
                PropertyValue pv = new PropertyValue();
                Object propValue = this.UNSUPPORTED_PROPERTY_FLAG;
                if (prop.equals("isDR2CVdc")) {
                    propValue = CloudTypeType.DR_2_C == vDC.getContainerCloudType() ? Boolean.valueOf(true) : Boolean.valueOf(false);
                } else if (prop.equals("isNormalVdc")) {
                    propValue = CloudTypeType.DR_2_C != vDC.getContainerCloudType() ? Boolean.valueOf(true) : Boolean.valueOf(false);
                } else if (prop.equals("id")) {
                    propValue = vDC.getId();
                } else if (prop.equals("vdcName")) {
                    propValue = vDC.getName();
                } else if (prop.equals("name")) {
                    propValue = vDC.getName();
                } else if (prop.equals("storageTier")) {
                    propValue = vDC.getStorageTier();
                } else if (prop.equals("vpcName")) {
                    propValue = vDC.getCloudName();
                } else if (prop.equals("vpcId")) {
                    propValue = vDC.getVpcId();
                } else if (prop.equals("href")) {
                    propValue = vDC.getHref();
                } else if (prop.equals("vcpuAllocated")) {
                    propValue = vDC.getVcpuAllocated();
                } else if (prop.equals("vcpuAvailable")) {
                    propValue = vDC.getVcpuAvailable();
                } else if (prop.equals("vcpuConsumed")) {
                    propValue = vDC.getVcpuConsumed();
                } else if (prop.equals("storageAllocated")) {
                    propValue = vDC.getStorageAllocated();
                } else if (prop.equals("storageAvailable")) {
                    propValue = vDC.getStorageAvailable();
                } else if (prop.equals("storageConsumed")) {
                    propValue = vDC.getStorageConsumed();
                } else if (prop.equals("memoryAllocated")) {
                    propValue = vDC.getMemoryAllocated();
                } else if (prop.equals("memoryAvailable")) {
                    propValue = vDC.getMemoryAvailable();
                } else if (prop.equals("memoryConsumed")) {
                    propValue = vDC.getMemoryConsumed();
                } else if (prop.equals("vpcVcpuAvailable")) {
                    propValue = vDC.getVpcVcpuAvailable();
                } else if (prop.equals("vpcMemoryAvailable")) {
                    propValue = vDC.getVpcMemoryAvailable();
                } else if (prop.equals("vpcStorageAvailable")) {
                    propValue = vDC.getVpcStorageAvailable();
                } else if (prop.equals("vpcStorageTiersAvailable")) {
                    propValue = vDC.getVpcStorageTiersAvailable();
                } else if (prop.equals("description")) {
                    propValue = vDC.getDescription();
                } else if (prop.equals("isEnabled")) {
                    propValue = vDC.isEnabled();
                } else if (prop.equals("vmQuota")) {
                    propValue = vDC.getVmQuota();
                } else if (prop.equals("vdcStatus")) {
                    propValue = vDC.getState().value();
                } else if (prop.equals("vcdUrl")) {
                    propValue = vDC.getVcdUrl();
                } else if (prop.equals("sharedVdc")) {
                    propValue = vDC.isSharedVdc();
                } else if (prop.equals("isNotError")) {
                    propValue = vDC.getState() != EntityState.ERROR && vDC.getState() != EntityState.ACTIVATING && vDC.getState() != EntityState.DELETING;
                } else if (prop.equals("isPrivateVDCOperationEnabled")) {
                    propValue = vDC.isPrivate() && vDC.getState() != EntityState.ERROR && vDC.getState() != EntityState.ACTIVATING && vDC.getState() != EntityState.DELETING;
                } else if (prop.equals("isVDCDeleteEnabled")) {
                    propValue = vDC.isPrivate() && vDC.getState() != EntityState.ACTIVATING && this.accessController.operationAllowed(DELETE_VDC);
                } else if (prop.equals("isEditVDCOperationEnabled")) {
                    propValue = vDC.isPrivate() && vDC.getState() != EntityState.ERROR && vDC.getState() != EntityState.ACTIVATING && vDC.getState() != EntityState.DELETING && this.accessController.operationAllowed(EDIT_VDC);
                } else if (prop.equals("isEditQuotaEnabled")) {
                    propValue = vDC.getState() != EntityState.ERROR && vDC.getState() != EntityState.ACTIVATING && vDC.getState() != EntityState.DELETING && this.accessController.operationAllowed(EDIT_VDC_QUOTA);
                } else if (prop.equals("isManageInVcdEnabled")) {
                    propValue = vDC.getState() != EntityState.ERROR && this.accessController.operationAllowed(EDIT_VDC);
                }
                logger.debug("PROP NAME and VALUE IS : {}", (Object)(prop + ":" + propValue));
                pv.value = propValue;
                if (pv.value == this.UNSUPPORTED_PROPERTY_FLAG) continue;
                pv.resourceObject = vDC.getUri();
                pv.propertyName = prop;
                pvs.add(pv);
            }
        }
        ri.properties = pvs.toArray(new PropertyValue[0]);
        return ri;
    }

    @Override
    public VCimVirtualDatacenter getVDC(Object vDCUri) {
        VCimVirtualDatacenter vDC = null;
        String sessionId = this.getClientSessionId();
        String key = "GET_VDC#" + ((URI)vDCUri).toString() + "#" + sessionId;
        vDC = (VCimVirtualDatacenter)this.queryUtil.getResults(key, vDCUri);
        return vDC;
    }

    @Override
    public VCimVirtualDatacenter getVDCById(Object vdcId) {
        VCimVirtualDatacenter vDC = null;
        String sessionId = this.getClientSessionId();
        String key = "GET_VDC_BY_ID#" + (String)vdcId + "#" + sessionId;
        vDC = (VCimVirtualDatacenter)this.queryUtil.getResults(key, vdcId);
        return vDC;
    }

    @Override
    public List<VdcUser> getVdcUsers(String vpcId, String vdcId) {
        return this.getVdcAdapter().getVdcUsers(this.getClientSessionId(), vpcId, vdcId);
    }

    @Override
    public void addVdc(String vdcName, String vpcId, int cpu, int memory, String storage, int publicIps) {
        this.getVdcAdapter().addVdc(this.getClientSessionId(), vdcName, vpcId, cpu, memory, storage, publicIps);
    }

    @Override
    public List<VCimVirtualDatacenter> getVDCs() {
        List vDCs = null;
        String sessionId = this.getClientSessionId();
        String key = "GET_ALL_VDCS#" + sessionId;
        vDCs = (List)this.queryUtil.getResults(key, new Object[0]);
        return vDCs;
    }

    @Override
    public void updateVdcSettings(String href, String vdcName, String vdcDesc, int cpuAlloc, int memoryAlloc, String storageAlloc) {
        this.getVdcAdapter().updateVdcSettings(this.getClientSessionId(), href, vdcName, vdcDesc, cpuAlloc, memoryAlloc, storageAlloc);
    }

    @Override
    public void updateVdcVMQuota(String href, int vmQuota) {
        this.getVdcAdapter().updateVdcVMQuota(this.getClientSessionId(), href, vmQuota);
    }

    @Override
    public void deleteVdc(String href) {
        this.getVdcAdapter().deleteVdc(this.getClientSessionId(), href);
    }

    @Override
    public void changeVdcStatus(String href, boolean status) {
        this.getVdcAdapter().changeVdcStatus(this.getClientSessionId(), href, status);
    }

    @Override
    public List<VCimVirtualDatacenter> getVDCsForVpc(String vpcId) {
        List vDCs = null;
        String sessionId = this.getClientSessionId();
        String key = "GET_VDCS_FOR_VPC#" + vpcId + "#" + sessionId;
        vDCs = (List)this.queryUtil.getResults(key, vpcId);
        return vDCs;
    }

    @Override
    public List<VCimVirtualDatacenter> getVDCsForVpc2(String vpcId) {
        List vDCs = null;
        String sessionId = this.getClientSessionId();
        String key = "GET_VDCS_FOR_VPC2#" + vpcId + "#" + sessionId;
        vDCs = (List)this.queryUtil.getResults(key, vpcId);
        return vDCs;
    }

    @Override
    public List<VCimVirtualDatacenter> getPrivateVDCs() {
        List vDCs = null;
        String sessionId = this.getClientSessionId();
        String key = "GET_PRIVATE_VDCS#" + sessionId;
        vDCs = (List)this.queryUtil.getResults(key, new Object[0]);
        return vDCs;
    }

    @Override
    public String getVcdSsoToken(String vdcId) {
        return this.getVdcAdapter().getVcdSsoToken(this.getClientSessionId(), vdcId);
    }

    @Override
    public Object execute(String identifier, Object ... arguments) {
        String sessionId = this.getClientSessionId();
        if (identifier.startsWith("GET_ALL_VDCS#")) {
            return this.getVdcReadOnlyAdapter().getVDCs(sessionId);
        }
        if (identifier.startsWith("GET_VDC#")) {
            if (arguments.length > 0) {
                return this.getVdcReadOnlyAdapter().getVDC(sessionId, (URI)arguments[0]);
            }
        } else if (identifier.startsWith("GET_VDC_BY_ID#")) {
            if (arguments.length > 0) {
                return this.getVdcReadOnlyAdapter().getVDCById(sessionId, (String)arguments[0]);
            }
        } else if (identifier.startsWith("GET_VDCS_FOR_VPC#")) {
            if (arguments.length > 0) {
                return this.getVdcReadOnlyAdapter().getVDCsForVpc(sessionId, (String)arguments[0]);
            }
        } else if (identifier.startsWith("GET_PRIVATE_VDCS#")) {
            return this.getVdcReadOnlyAdapter().getPrivateVDCs(sessionId);
        }
        return null;
    }

    private CloudInstanceOperations getCloudReadOnlyAdapter() {
        return (CloudInstanceOperations)((Object)this.adapterWrapper.getReadOnlyAdapter(VchsObjectType.CLOUD));
    }

    private VirtualDatacenterOperations getVdcReadOnlyAdapter() {
        return (VirtualDatacenterOperations)((Object)this.adapterWrapper.getReadOnlyAdapter(VchsObjectType.DATACENTER));
    }

    private VirtualDatacenterOperations getVdcAdapter() {
        return (VirtualDatacenterOperations)((Object)this.adapterWrapper.getWritableAdapter(VchsObjectType.DATACENTER));
    }

    @Override
    public List<VCimVirtualMachineReplicationStatus> getVirtualMachineReplicationStatusesForVdc(String vdcId) {
        return this.getVdcReadOnlyAdapter().getVirtualMachineReplicationStatusesForVdc(this.getClientSessionId(), vdcId);
    }

    @Override
    public void addVdc(String vdcName, String vpcId, int cpu, int memory, int storage, int publicIps) {
    }

    @Override
    public DR2CVMCount getDR2CVMCount(String vdcId) {
        return this.getVdcReadOnlyAdapter().getDR2CVMCount(this.getClientSessionId(), vdcId);
    }
}

