/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.model;

import com.vmware.vcim.ngc.service.common.CloudType;
import com.vmware.vcim.ngc.service.common.UriUtils;
import com.vmware.vcim.ngc.service.model.IpRange;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class Network {
    public static final String NON_PLC_TYPE = "NonPlc";
    public static final String PLC_TYPE = "Plc";
    private String id;
    private String name;
    private String href;
    private String vpcId;
    private String vdcId;
    private FenceMode fenceMode;
    private String edgeGatewayName;
    private String edgeGatewayAddress;
    private int allocatedPublicIps;
    private int usedPublicIps;
    private boolean isDefault;
    private String type;
    private String gatewayId;
    private String ipPool;
    private int allocatedVMs;
    private int poweredOnVMs;
    private List<IpRange> ipRange;
    private String defaultGatewayIp;
    private boolean dr2cvm;

    public boolean isDr2cvm() {
        return this.dr2cvm;
    }

    public void setDr2cvm(boolean dr2cvm) {
        this.dr2cvm = dr2cvm;
    }

    public Network() {
    }

    public Network(String id, String name, String href) {
        this.id = id;
        this.href = href;
        this.name = name;
    }

    public Network(String id, String name, String href, boolean dr2cvm) {
        this(id, name, href);
        this.dr2cvm = dr2cvm;
    }

    public String getEdgeGatewayName() {
        return this.edgeGatewayName;
    }

    public void setEdgeGatewayName(String edgeGatewayName) {
        this.edgeGatewayName = edgeGatewayName;
    }

    public String getEdgeGatewayAddress() {
        return this.edgeGatewayAddress;
    }

    public void setEdgeGatewayAddress(String edgeGatewayAddress) {
        this.edgeGatewayAddress = edgeGatewayAddress;
    }

    public int getAllocatedPublicIps() {
        return this.allocatedPublicIps;
    }

    public void setAllocatedPublicIps(int allocatedPublicIps) {
        this.allocatedPublicIps = allocatedPublicIps;
    }

    public int getUsedPublicIps() {
        return this.usedPublicIps;
    }

    public void setUsedPublicIps(int usedPublicIps) {
        this.usedPublicIps = usedPublicIps;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public String getVdcId() {
        return this.vdcId;
    }

    public void setVdcId(String vdcId) {
        this.vdcId = vdcId;
    }

    public FenceMode getFenceMode() {
        return this.fenceMode;
    }

    public void setFenceMode(FenceMode fenceMode) {
        this.fenceMode = fenceMode;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getIpPool() {
        return this.ipPool;
    }

    public void setIpPool(String ipPool) {
        this.ipPool = ipPool;
    }

    public int getAllocatedVMs() {
        return this.allocatedVMs;
    }

    public void setAllocatedVMs(int allocatedVMs) {
        this.allocatedVMs = allocatedVMs;
    }

    public int getPoweredOnVMs() {
        return this.poweredOnVMs;
    }

    public void setPoweredOnVMs(int poweredOnVMs) {
        this.poweredOnVMs = poweredOnVMs;
    }

    public List<IpRange> getIpRange() {
        if (null == this.ipRange) {
            this.ipRange = new ArrayList<IpRange>();
        }
        return this.ipRange;
    }

    public void setIpRange(List<IpRange> ipRange) {
        this.ipRange = ipRange;
    }

    public String getDefaultGatewayIp() {
        return this.defaultGatewayIp;
    }

    public void setDefaultGatewayIp(String defaultGatewayIp) {
        this.defaultGatewayIp = defaultGatewayIp;
    }

    public String getGatewayId() {
        return this.gatewayId;
    }

    public void setGatewayId(String gatewayId) {
        this.gatewayId = gatewayId;
    }

    public static String getVpcId(URI uri) {
        String[] urlParts = UriUtils.getUrlPartsFromUri(uri);
        if (urlParts[0].equalsIgnoreCase(CloudType.PRIVATE.url())) {
            return urlParts[1];
        }
        return null;
    }

    public static String getVdcId(URI uri) {
        String[] urlParts = UriUtils.getUrlPartsFromUri(uri);
        if (urlParts[0].equalsIgnoreCase(CloudType.PRIVATE.url())) {
            return urlParts[3];
        }
        return urlParts[1];
    }

    public static String getGatewayId(URI uri) {
        String[] urlParts = UriUtils.getUrlPartsFromUri(uri);
        if (urlParts[0].equalsIgnoreCase(CloudType.PRIVATE.url())) {
            return urlParts[5];
        }
        return urlParts[3];
    }

    public static String getNetworkId(URI uri) {
        String[] urlParts = UriUtils.getUrlPartsFromUri(uri);
        String[] ids = urlParts[urlParts.length - 1].split("\\+");
        return ids[0];
    }

    public URI getUri() {
        if (!StringUtils.isEmpty((String)this.vpcId)) {
            return UriUtils.createURIUsingDefaults("Network", CloudType.PRIVATE.url(), this.vpcId, "vdc", this.vdcId, "gateway", this.gatewayId, "networks", this.id + "+" + this.type);
        }
        if (this.dr2cvm) {
            return UriUtils.createURIUsingDefaults("Network", CloudType.DR_2_C.url(), this.vdcId, "gateway", this.gatewayId, "networks", this.id + "+" + this.type);
        }
        return UriUtils.createURIUsingDefaults("Network", CloudType.SHARED.url(), this.vdcId, "gateway", this.gatewayId, "networks", this.id + "+" + this.type);
    }

    public static enum FenceMode {
        ISOLATED,
        BRIDGED,
        NAT_ROUTED;

    }
}

