/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.model;

import com.vmware.ares.common.v1.CloudCapacityType;
import com.vmware.ares.common.v2.CloudTypeType;
import com.vmware.ares.common.v2.StorageTierType;
import com.vmware.ares.product.v2.CloudSnapshotType;
import com.vmware.ares.product.v2.DcSnapshotType;
import com.vmware.ares.vcd.v2.VdcSnapshotType;
import com.vmware.vcim.ngc.service.common.CloudType;
import com.vmware.vcim.ngc.service.common.UriUtils;
import com.vmware.vcim.ngc.service.model.FlexObjectMarker;
import com.vmware.vcim.ngc.service.model.StorageProfile;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public class VCimVpc
extends CloudSnapshotType
implements FlexObjectMarker {
    private String regionName;
    private long cpuAvailable;
    private long cpuAllocated;
    private long cpuPurchased;
    private long storageAvailable;
    private long storageAllocated;
    private long storagePurchased;
    private long memoryAvailable;
    private long memoryAllocated;
    private long memoryPurchased;
    private long publicIpsAvailable;
    private long publicIpsAllocated;
    private long publicIpsPurchased;
    private CloudType vpcType;
    private String vdcId;
    private List<StorageProfile> storageTier;
    private boolean shared;
    private boolean isDR2C;

    public boolean isDR2C() {
        return this.isDR2C;
    }

    public void setDR2C(boolean isDR2c) {
        this.isDR2C = isDR2c;
    }

    public boolean isShared() {
        return this.vpcType != CloudType.PRIVATE;
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    public VCimVpc(DcSnapshotType vpc, String regionId) {
        this.name = vpc.getName();
        this.id = vpc.getId();
        this.description = vpc.getDescription();
        this.type = vpc.getType();
        this.cpuMhz = vpc.getCpuMhz();
        this.setValues(this.cpuMhz, CapacityType.CPU);
        this.memoryMb = vpc.getMemoryMb();
        this.setValues(this.memoryMb, CapacityType.MEMORY);
        this.storageMb = vpc.getStorageMb();
        this.setValues(this.storageMb, CapacityType.STORAGE);
        this.setValues(vpc.getIp(), CapacityType.IP);
        this.storageTier = new ArrayList<StorageProfile>();
        for (StorageTierType st : vpc.getStorageTiers().getStorageTier()) {
            if (st == null) continue;
            this.storageTier.add(new StorageProfile(st.getName(), st.getCapacity(), st.getUsed() != null ? st.getUsed() : 0, st.getFree() != null ? st.getFree() : 0, st.isDefault()));
        }
        this.href = vpc.getHref();
        this.link = vpc.getLink();
        this.regionId = regionId;
        this.setCloudType(true);
    }

    public VCimVpc(VdcSnapshotType vdc, String regionId) {
        this.name = vdc.getName();
        this.description = vdc.getDescription();
        this.id = vdc.getId();
        this.type = vdc.getType();
        this.vdcId = vdc.getId();
        this.cpuMhz = new CloudCapacityType();
        this.cpuMhz.setAvailable(vdc.getCpuMhz().getAvailable());
        this.cpuMhz.setPurchased(vdc.getCpuMhz().getAllocated());
        this.cpuMhz.setAllocated(vdc.getCpuMhz().getAllocated());
        this.setValues(this.cpuMhz, CapacityType.CPU);
        this.memoryMb = new CloudCapacityType();
        this.memoryMb.setAvailable(vdc.getMemoryMb().getAvailable());
        this.memoryMb.setPurchased(vdc.getMemoryMb().getAllocated());
        this.memoryMb.setAllocated(vdc.getMemoryMb().getAllocated());
        this.setValues(this.memoryMb, CapacityType.MEMORY);
        this.storageMb = new CloudCapacityType();
        this.storageMb.setAvailable(vdc.getStorageMb().getAvailable());
        this.storageMb.setPurchased(vdc.getStorageMb().getAllocated());
        this.storageMb.setAllocated(vdc.getStorageMb().getAllocated());
        this.setValues(this.storageMb, CapacityType.STORAGE);
        this.storageTier = new ArrayList<StorageProfile>();
        for (StorageTierType st : vdc.getStorageTiers().getStorageTier()) {
            if (st == null) continue;
            this.storageTier.add(new StorageProfile(st.getName(), st.getCapacity(), st.getUsed() != null ? st.getUsed() : 0, st.getFree() != null ? st.getFree() : 0, st.isDefault()));
        }
        CloudCapacityType ip = new CloudCapacityType();
        ip.setAvailable(0L);
        ip.setPurchased(0L);
        ip.setAllocated(0L);
        this.setValues(ip, CapacityType.IP);
        this.href = vdc.getHref();
        this.link = vdc.getLink();
        this.regionId = regionId;
        this.setCloudType(false);
    }

    private void setValues(CloudCapacityType capacity, CapacityType type) {
        switch (type) {
            case CPU: {
                this.cpuAvailable = capacity.getAvailable();
                this.cpuAllocated = capacity.getAllocated();
                this.cpuPurchased = capacity.getPurchased();
                break;
            }
            case MEMORY: {
                this.memoryAvailable = capacity.getAvailable();
                this.memoryAllocated = capacity.getAllocated();
                this.memoryPurchased = capacity.getPurchased();
                break;
            }
            case STORAGE: {
                this.storageAvailable = capacity.getAvailable();
                this.storageAllocated = capacity.getAllocated();
                this.storagePurchased = capacity.getPurchased();
                break;
            }
            case IP: {
                this.publicIpsAvailable = capacity.getAvailable();
                this.publicIpsAllocated = capacity.getAllocated();
                this.publicIpsPurchased = capacity.getPurchased();
            }
        }
    }

    private void setCloudType(boolean isPrivate) {
        if (isPrivate) {
            this.cloudType = CloudTypeType.DC;
            this.vpcType = CloudType.PRIVATE;
        } else if (CloudTypeType.DR_2_C == this.cloudType) {
            this.cloudType = CloudTypeType.DR_2_C;
            this.vpcType = CloudType.DR_2_C;
        } else {
            this.cloudType = CloudTypeType.VPC;
            this.vpcType = CloudType.SHARED;
        }
    }

    public long getCpuPurchased() {
        return this.cpuPurchased;
    }

    public void setCpuPurchased(long cpuPurchased) {
        this.cpuPurchased = cpuPurchased;
    }

    public void setStoragePurchased(long storagePurchased) {
        this.storagePurchased = storagePurchased;
    }

    public void setMemoryPurchased(long memoryPurchased) {
        this.memoryPurchased = memoryPurchased;
    }

    public void setPublicIpsPurchased(long publicIpsPurchased) {
        this.publicIpsPurchased = publicIpsPurchased;
    }

    public long getStoragePurchased() {
        return this.storagePurchased;
    }

    public long getMemoryPurchased() {
        return this.memoryPurchased;
    }

    public long getPublicIpsPurchased() {
        return this.publicIpsPurchased;
    }

    @Override
    public String getRegionId() {
        return this.regionId;
    }

    @Override
    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public long getCpuAllocated() {
        return this.cpuAllocated;
    }

    public void setCpuAllocated(long cpuAllocated) {
        this.cpuAllocated = cpuAllocated;
    }

    public long getStorageAllocated() {
        return this.storageAllocated;
    }

    public void setStorageAllocated(long storageAllocated) {
        this.storageAllocated = storageAllocated;
    }

    public long getMemoryAllocated() {
        return this.memoryAllocated;
    }

    public void setMemoryAllocated(long memoryAllocated) {
        this.memoryAllocated = memoryAllocated;
    }

    public long getPublicIpsAllocated() {
        return this.publicIpsAllocated;
    }

    public void setPublicIpsAllocated(long publicIpsAllocated) {
        this.publicIpsAllocated = publicIpsAllocated;
    }

    public long getCpuAvailable() {
        return this.cpuAvailable;
    }

    public void setCpuAvailable(long cpuAvailable) {
        this.cpuAvailable = cpuAvailable;
    }

    public long getStorageAvailable() {
        return this.storageAvailable;
    }

    public void setStorageAvailable(long storageAvailable) {
        this.storageAvailable = storageAvailable;
    }

    public long getMemoryAvailable() {
        return this.memoryAvailable;
    }

    public void setMemoryAvailable(long memoryAvailable) {
        this.memoryAvailable = memoryAvailable;
    }

    public long getPublicIpsAvailable() {
        return this.publicIpsAvailable;
    }

    public void setPublicIpsAvailable(long publicIpsAvailable) {
        this.publicIpsAvailable = publicIpsAvailable;
    }

    public List<StorageProfile> getStorageTier() {
        return this.storageTier;
    }

    public void setStorageTier(List<StorageProfile> storageTier) {
        this.storageTier = storageTier;
    }

    public static String getVpcId(URI uri) {
        String[] urlParts = UriUtils.getUrlPartsFromUri(uri);
        String[] ids = urlParts[1].split("\\+");
        return ids[0];
    }

    public static String getVdcId(URI uri) {
        String[] urlParts = UriUtils.getUrlPartsFromUri(uri);
        if (urlParts[0].equalsIgnoreCase(CloudType.SHARED.url()) || urlParts[0].equalsIgnoreCase(CloudType.DR_2_C.url())) {
            String[] ids = urlParts[1].split("\\+");
            return ids[ids.length - 1];
        }
        return null;
    }

    public static String getRegionId(URI uri) {
        String[] urlParts = UriUtils.getUrlPartsFromUri(uri);
        String[] ids = urlParts[1].split("\\+");
        return ids[1];
    }

    public static boolean isPrivate(URI uri) {
        String[] urlParts = UriUtils.getUrlPartsFromUri(uri);
        return !urlParts[0].equalsIgnoreCase(CloudType.SHARED.url()) && !urlParts[0].equalsIgnoreCase(CloudType.DR_2_C.url());
    }

    @Override
    public URI getUri() {
        if (!this.isShared()) {
            return UriUtils.createURIUsingDefaults("CloudInstance", this.vpcType.url(), this.id + "+" + this.regionId);
        }
        if (this.isDR2C) {
            return UriUtils.createURIUsingDefaults("CloudInstance", CloudType.DR_2_C.url(), this.id + "+" + this.regionId + "+" + this.vdcId);
        }
        return UriUtils.createURIUsingDefaults("CloudInstance", this.vpcType.url(), this.id + "+" + this.regionId + "+" + this.vdcId);
    }

    private static enum CapacityType {
        CPU,
        MEMORY,
        STORAGE,
        IP;

    }
}

