/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.model.adapters;

import com.vmware.ares.vcd.v1.MyImageRecordType;
import com.vmware.ares.vcd.v1.VmStorageParamsType;
import com.vmware.vcim.ngc.service.model.VCimTemplateType;
import java.util.ArrayList;
import java.util.List;

public class ImageRecordAdapter
implements VCimTemplateType {
    private MyImageRecordType imageType;

    public ImageRecordAdapter(MyImageRecordType imageType) {
        this.imageType = imageType;
    }

    @Override
    public String getId() {
        return this.imageType.getId();
    }

    @Override
    public void setId(String id) {
        this.imageType.setId(id);
    }

    @Override
    public String getTemplateId() {
        return "";
    }

    @Override
    public void setTemplateId(String templateId) {
    }

    @Override
    public String getOperatingSystemName() {
        return "";
    }

    @Override
    public void setOperatingSystemName(String operatingSystemName) {
    }

    @Override
    public String getOsInstructionSet() {
        return "";
    }

    @Override
    public void setOsInstructionSet(String osInstructionSet) {
    }

    @Override
    public int getVcpu() {
        return this.imageType.getVCPU();
    }

    @Override
    public void setVcpu(int vcpu) {
        this.imageType.setVCPU(vcpu);
    }

    @Override
    public int getMemoryMB() {
        return this.imageType.getMemoryMB();
    }

    @Override
    public void setMemoryMB(int memoryMB) {
        this.imageType.setMemoryMB(memoryMB);
    }

    @Override
    public List<Integer> getStorageMB() {
        ArrayList<Integer> storage = new ArrayList<Integer>();
        for (VmStorageParamsType storageParam : this.imageType.getStorage()) {
            storage.add(storageParam.getCapacityMb());
        }
        return storage;
    }

    @Override
    public void setStorageMB(List<Integer> storageMB) {
        List<VmStorageParamsType> vmStorageList = this.imageType.getStorage();
        int port = 0;
        for (Integer storage : storageMB) {
            VmStorageParamsType vmStorage = new VmStorageParamsType();
            vmStorage.setCapacityMb(storage);
            vmStorage.setNew(true);
            vmStorage.setPort(port++);
            vmStorageList.add(vmStorage);
        }
    }

    @Override
    public String getName() {
        return this.imageType.getName();
    }

    @Override
    public void setName(String name) {
        this.imageType.setName(name);
    }

    @Override
    public String getHref() {
        return this.imageType.getHref();
    }

    @Override
    public void setHref(String href) {
        this.imageType.setHref(href);
    }

    @Override
    public boolean isIsChargeable() {
        return false;
    }

    @Override
    public void setIsChargeable(boolean value) {
    }

    @Override
    public String getDescription() {
        return this.imageType.getDescription();
    }

    @Override
    public void setDescription(String description) {
        this.imageType.setDescription(description);
    }

    @Override
    public List<Integer> getStoragePorts() {
        ArrayList<Integer> storagePorts = new ArrayList<Integer>();
        for (VmStorageParamsType storageParam : this.imageType.getStorage()) {
            storagePorts.add(storageParam.getPort());
        }
        return storagePorts;
    }

    @Override
    public void setStoragePorts(List<Integer> storagePorts) {
    }
}

