/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.rest;

import com.vmware.vcim.ngc.service.exception.VCimException;
import com.vmware.vcim.ngc.service.rest.VcimResponseErrorHandler;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestTemplate;

public abstract class RestClient {
    private static final Logger logger = LoggerFactory.getLogger(RestClient.class);
    public static final int SERVER_PROBLEM = 500;
    public static final String SERVER_NOT_KNOWN = "UnknownHostException";
    public static final String PEER_NOT_AUTH = "peer not authenticated";
    public static final String SSL_CERTI_NOTVALID = "Server Certificate Not Verified";

    protected abstract HttpHeaders getHeaders(Map<String, String> var1, Object ... var2);

    protected abstract RestTemplate getRestTemplate(Object ... var1);

    protected abstract String processUrl(String var1, Object ... var2);

    protected abstract HttpEntity<?> processResponse(HttpEntity<?> var1, Object ... var2);

    protected <T> HttpEntity<T> sendGetRequest(String url, Class<T> responseType, Object ... args) {
        return this.sendGetRequest(url, responseType, null, args);
    }

    protected <T> HttpEntity<T> sendGetRequest(String url, Class<T> responseType, Map<String, String> customHeaders, Object ... args) {
        logger.info("GET: " + url);
        HttpHeaders headers = this.getHeaders(customHeaders, args);
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
        return this.execute(url, HttpMethod.GET, requestEntity, responseType, args);
    }

    protected <S, T> HttpEntity<?> sendPostRequest(String url, T requestData, Class<S> responseType, Object ... args) {
        return this.sendPostRequest(url, requestData, responseType, null, args);
    }

    protected <S, T> HttpEntity<?> sendPostRequest(String url, T requestData, Class<S> responseType, Map<String, String> customHeaders, Object ... args) {
        logger.info("POST: " + url);
        HttpHeaders headers = this.getHeaders(customHeaders, args);
        HttpEntity requestEntity = requestData != null ? new HttpEntity(requestData, (MultiValueMap)headers) : new HttpEntity((MultiValueMap)headers);
        return this.execute(url, HttpMethod.POST, requestEntity, responseType, args);
    }

    protected <S, T> HttpEntity<?> sendPutRequest(String url, T requestData, Class<S> responseType, Object ... args) {
        return this.sendPutRequest(url, requestData, responseType, null, args);
    }

    protected <S, T> HttpEntity<?> sendPutRequest(String url, T requestData, Class<S> responseType, Map<String, String> customHeaders, Object ... args) {
        logger.info("PUT: " + url);
        HttpHeaders headers = this.getHeaders(customHeaders, args);
        HttpEntity requestEntity = requestData != null ? new HttpEntity(requestData, (MultiValueMap)headers) : new HttpEntity((MultiValueMap)headers);
        return this.execute(url, HttpMethod.PUT, requestEntity, responseType, args);
    }

    protected <S, T> HttpEntity<?> sendDeleteRequest(String url, T requestData, Class<S> responseType, Object ... args) {
        return this.sendDeleteRequest(url, requestData, responseType, null, args);
    }

    protected <S, T> HttpEntity<?> sendDeleteRequest(String url, T requestData, Class<S> responseType, Map<String, String> customHeaders, Object ... args) {
        logger.info("DELETE: " + url);
        HttpHeaders headers = this.getHeaders(customHeaders, args);
        HttpEntity requestEntity = requestData != null ? new HttpEntity(requestData, (MultiValueMap)headers) : new HttpEntity((MultiValueMap)headers);
        return this.execute(url, HttpMethod.DELETE, requestEntity, responseType, args);
    }

    protected <T> HttpEntity<T> execute(String url, HttpMethod httpMethod, HttpEntity<?> requestEntity, Class<T> responseType, Object ... args) {
        try {
            RestTemplate restTemplate = this.getRestTemplate(args);
            url = this.processUrl(url, args);
            if (restTemplate == null) {
                throw new VCimException(500, "No RestTemplate Instance available");
            }
            logger.debug("Request Url is {}", (Object)url);
            this.logHttpEntity(requestEntity, false);
            HttpEntity<?> responseEntity = restTemplate.exchange(url, httpMethod, requestEntity, responseType, new Object[0]);
            this.logHttpEntity(responseEntity, true);
            responseEntity = this.processResponse(responseEntity, args);
            return responseEntity;
        }
        catch (VcimResponseErrorHandler.VcimResponseException ex) {
            throw new VCimException(ex.getHttpStatusCode().value(), ex.getMessage());
        }
        catch (ResourceAccessException ex) {
            logger.error("Exception in http" + httpMethod.name() + " for url " + url, (Throwable)ex);
            if (ex.getMessage().contains(PEER_NOT_AUTH)) {
                throw new VCimException(500, SSL_CERTI_NOTVALID);
            }
            throw new VCimException(500, SERVER_NOT_KNOWN);
        }
        catch (Exception ex) {
            logger.error("Exception in http" + httpMethod.name() + " for url " + url, (Throwable)ex);
            throw new VCimException(500, "Could not complete action");
        }
    }

    protected void logHttpEntity(HttpEntity<?> entity, boolean isResponse) {
        if (!logger.isDebugEnabled()) {
            return;
        }
        if (isResponse) {
            ResponseEntity responseEntity = (ResponseEntity)entity;
            logger.debug("Response Status Code is {}", (Object)responseEntity.getStatusCode());
            logger.debug("Response Headers are {}", (Object)entity.getHeaders().toString());
            return;
        }
        logger.debug("Request Headers are {}", (Object)entity.getHeaders().toString());
        logger.debug("Request Body is {}", entity.getBody());
    }
}

