/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.rest;

import com.vmware.vcim.ngc.service.exception.VCimException;
import com.vmware.vcim.ngc.service.security.ClientConnectionConfiguration;
import com.vmware.vcim.ngc.service.security.FakeSSLSocketFactory;
import com.vmware.vcim.ngc.service.security.SecureContext;
import com.vmware.vcim.ngc.service.security.exceptions.SSLContextException;
import com.vmware.vcim.ngc.service.security.exceptions.TrustManagerException;
import com.vmware.vcim.ngc.service.security.exceptions.TrustStoreException;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import java.net.URI;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.client.RestTemplate;

public class RestTemplateFactory {
    public static final String PROXY_HOST_SCHEME = "hcs.proxyHostScheme";
    private static final String HTTPS_PROXY_HOST = "https.proxyHost";
    private static final String HTTPS_PROXY_PORT = "https.proxyPort";
    public static final String HTTPS_PROXY_USER = "https.proxyUser";
    public static final String HTTPS_PROXY_PASSWORD = "https.proxyPassword";
    private static final String HTTP_PROXY_HOST = "http.proxyHost";
    private static final String HTTP_PROXY_PORT = "http.proxyPort";
    private static final String HTTP_PROXY_USER = "http.proxyUser";
    private static final String HTTP_PROXY_PASSWORD = "http.proxyPassword";
    private static final String SESSION_TIMEOUT = "vchs_session.timeout";
    private static final int DEFAULT_TIMEOUT = 60;
    private static final String IGONRE_SSL = "ignoreSSL";
    private static final int SERVER_PROBLEM = 500;
    private static final String KEY_STORE_FILE = "configuration" + System.getProperty("file.separator") + "keystore";
    private static final String KEY_NOT_FOUND = "KeyStore File Not Found";
    @Autowired
    private final ConfigurationService _confgurationService;
    private List<HttpMessageConverter<?>> messageConverters;
    private static final Logger logger = LoggerFactory.getLogger(RestTemplateFactory.class);

    public RestTemplateFactory(ConfigurationService conf) {
        this._confgurationService = conf;
    }

    private int getPort(URI uri) {
        String scheme = uri.getScheme();
        int port = uri.getPort();
        if (port < 0) {
            if ("https".equals(scheme)) {
                port = 443;
            } else if ("http".equals(scheme)) {
                port = 80;
            }
        }
        return port;
    }

    public RestTemplate createRestTemplate(String url, String proxyUrl, String proxyPort, String proxyUsername, String proxyPassword, boolean useProxy) {
        URI uri = URI.create(url);
        return this.createRestTemplate(uri, proxyUrl, proxyPort, proxyUsername, proxyPassword, useProxy);
    }

    public RestTemplate createRestTemplate(URI url, String proxyUrl, String proxyPort, String proxyUsername, String proxyPassword, boolean useProxy) {
        Scheme scheme;
        logger.info("Creating RestTemplate for: URL - {}", (Object)url.toString());
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory();
        HttpClient client = factory.getHttpClient();
        boolean ignoreSSL = Boolean.parseBoolean(this._confgurationService.getProperty(IGONRE_SSL));
        String timeout = this._confgurationService.getProperty(SESSION_TIMEOUT);
        int timeoutinInt = 0;
        if (timeout != null && !timeout.equals("")) {
            try {
                timeoutinInt = Integer.parseInt(timeout) * 60 * 1000;
            }
            catch (NumberFormatException ex) {
                timeoutinInt = 60000;
            }
            if (timeoutinInt <= 0) {
                timeoutinInt = 60000;
            }
            factory.setConnectTimeout(timeoutinInt);
            factory.setReadTimeout(timeoutinInt);
        }
        if (client instanceof AbstractHttpClient) {
            ((AbstractHttpClient)client).setHttpRequestRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(0, false));
        }
        RestTemplate restTemplate = new RestTemplate((ClientHttpRequestFactory)factory);
        restTemplate.setMessageConverters(this.messageConverters);
        if (url.getScheme().equals("https")) {
            scheme = null;
            if (ignoreSSL) {
                scheme = new Scheme(url.getScheme(), this.getPort(url), (SchemeSocketFactory)FakeSSLSocketFactory.getInstance());
            } else {
                ClientConnectionConfiguration config;
                block18: {
                    config = null;
                    try {
                        config = new ClientConnectionConfiguration(KEY_STORE_FILE, null);
                    }
                    catch (TrustStoreException e) {
                        if (e.getError() == TrustStoreException.TrustStoreError.E_FILE_NOT_FOUND) {
                            throw new VCimException(500, KEY_NOT_FOUND);
                        }
                        if (e.getError() != TrustStoreException.TrustStoreError.E_KEYSTORE_LOAD) break block18;
                        throw new VCimException(500, "Error loading keystore file");
                    }
                }
                try {
                    scheme = new Scheme(url.getScheme(), this.getPort(url), (SchemeSocketFactory)SecureContext.getSSLSocketFactory(config));
                }
                catch (TrustManagerException e) {
                    throw new VCimException(500, "Unable to trust the certificate");
                }
                catch (SSLContextException e) {
                    throw new VCimException(500, "Error Creating SSL Connection to the Server");
                }
            }
            client.getConnectionManager().getSchemeRegistry().register(scheme);
        }
        if (url.getScheme().equals("http")) {
            scheme = new Scheme(url.getScheme(), this.getPort(url), (SchemeSocketFactory)PlainSocketFactory.getSocketFactory());
            client.getConnectionManager().getSchemeRegistry().register(scheme);
        }
        if (useProxy) {
            System.setProperty(HTTP_PROXY_HOST, proxyUrl);
            System.setProperty(HTTPS_PROXY_HOST, proxyUrl);
            System.setProperty(HTTP_PROXY_PORT, proxyPort);
            System.setProperty(HTTPS_PROXY_PORT, proxyPort);
            HttpHost proxyHost = new HttpHost(proxyUrl, Integer.parseInt(proxyPort), "http");
            client.getParams().setParameter("http.route.default-proxy", (Object)proxyHost);
            if (!StringUtils.isEmpty((String)proxyUsername) && !StringUtils.isEmpty((String)proxyPassword)) {
                System.setProperty(HTTP_PROXY_USER, proxyUsername);
                System.setProperty(HTTPS_PROXY_USER, proxyUsername);
                System.setProperty(HTTP_PROXY_PASSWORD, proxyPassword);
                System.setProperty(HTTPS_PROXY_PASSWORD, proxyPassword);
                ((AbstractHttpClient)client).getCredentialsProvider().setCredentials(new AuthScope(proxyHost.getHostName(), proxyHost.getPort()), (Credentials)new UsernamePasswordCredentials(proxyUsername, proxyPassword));
            }
        } else {
            System.clearProperty(HTTPS_PROXY_HOST);
            System.clearProperty(HTTPS_PROXY_PORT);
            System.clearProperty(HTTPS_PROXY_USER);
            System.clearProperty(HTTPS_PROXY_PASSWORD);
            System.clearProperty(HTTP_PROXY_HOST);
            System.clearProperty(HTTP_PROXY_PORT);
            System.clearProperty(HTTP_PROXY_USER);
            System.clearProperty(HTTP_PROXY_PASSWORD);
        }
        return restTemplate;
    }

    public RestTemplate createRestTemplate(URI url, String username, String password, String proxyUrl, String proxyPort, String proxyUsername, String proxyPassword, boolean useProxy) {
        logger.info("Creating RestTemplate for: User- " + username + ", URL- " + url.toString());
        return this.createRestTemplate(url, proxyUrl, proxyPort, proxyUsername, proxyPassword, useProxy);
    }

    public void setMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        this.messageConverters = messageConverters;
    }
}

