/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.rest;

import com.vmware.ares.common.v1.ErrorType;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Scanner;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.ResponseErrorHandler;

public class VcimResponseErrorHandler
implements ResponseErrorHandler {
    private static final Logger logger = LoggerFactory.getLogger(VcimResponseErrorHandler.class);
    private static final String VCIM_ERROR_CNT_TYPE = "vnd.vmware.ares.error";
    private static final String VCLOUD_ERROR_CNT_TYPE = "vnd.vmware.vcloud.error+xml";

    public boolean hasError(ClientHttpResponse response) throws IOException {
        HttpStatus status;
        MediaType mediaType = response.getHeaders().getContentType();
        if (mediaType != null) {
            String classParam = mediaType.getParameter("class");
            if (classParam != null && classParam.equals(VCIM_ERROR_CNT_TYPE)) {
                return true;
            }
            if (mediaType.getSubtype().equals(VCLOUD_ERROR_CNT_TYPE)) {
                return true;
            }
        }
        return (status = response.getStatusCode()) != HttpStatus.ACCEPTED && status != HttpStatus.CREATED && status != HttpStatus.OK && status != HttpStatus.NO_CONTENT;
    }

    public void handleError(ClientHttpResponse response) throws IOException {
        logger.error("Error Response Status is {}", (Object)response.getStatusCode());
        logger.error("Error Response Status text is {}", (Object)response.getStatusText());
        if (response.getBody() != null) {
            String responseStr = this.convertInputStreamToString(response.getBody());
            logger.error("error Response Body is {}", (Object)responseStr);
            StreamSource ss = new StreamSource(new StringReader(responseStr));
            try {
                MediaType mediaType = response.getHeaders().getContentType();
                if (mediaType != null) {
                    String classParam = mediaType.getParameter("class");
                    if (classParam != null && classParam.equals(VCIM_ERROR_CNT_TYPE)) {
                        ErrorType errorType = this.getVcimErrorType(ss);
                        VcimResponseException exception = new VcimResponseException(response.getStatusCode(), errorType);
                        throw exception;
                    }
                    if (mediaType.getSubtype().equals(VCLOUD_ERROR_CNT_TYPE)) {
                        com.vmware.vcloud.api.rest.schema_v1_5.ErrorType errorType = this.getVcloudErrorType(ss);
                        VcimResponseException exception = new VcimResponseException(response.getStatusCode(), errorType);
                        throw exception;
                    }
                }
            }
            catch (JAXBException ex) {
                logger.error("Unable to unmarshall to errorType", (Throwable)ex);
            }
        }
        VcimResponseException exception = new VcimResponseException(response.getStatusCode());
        throw exception;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String convertInputStreamToString(InputStream inputStream) {
        Scanner sc = null;
        try {
            sc = new Scanner(inputStream, "UTF-8").useDelimiter("\\A");
            String string = sc.hasNext() ? sc.next() : "";
            return string;
        }
        finally {
            if (sc != null) {
                sc.close();
            }
        }
    }

    private com.vmware.vcloud.api.rest.schema_v1_5.ErrorType getVcloudErrorType(StreamSource ss) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{com.vmware.vcloud.api.rest.schema_v1_5.ErrorType.class});
        Unmarshaller um = context.createUnmarshaller();
        JAXBElement errorType = um.unmarshal((Source)ss, com.vmware.vcloud.api.rest.schema_v1_5.ErrorType.class);
        return (com.vmware.vcloud.api.rest.schema_v1_5.ErrorType)errorType.getValue();
    }

    private ErrorType getVcimErrorType(StreamSource ss) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ErrorType.class});
        Unmarshaller um = context.createUnmarshaller();
        JAXBElement errorType = um.unmarshal((Source)ss, ErrorType.class);
        return (ErrorType)errorType.getValue();
    }

    public static class VcimResponseException
    extends RuntimeException {
        private static final long serialVersionUID = 1553543416127557390L;
        private HttpStatus httpStatusCode;
        private String message;
        private int majorErrorCode;
        private String minorErrorCode;
        private String vendorSpecificErrorCode;
        private String errorStackTrace;

        public VcimResponseException(HttpStatus statusCode, ErrorType errorType) {
            this.httpStatusCode = statusCode;
            this.message = errorType.getMessage();
            this.majorErrorCode = errorType.getMajorErrorCode();
            this.minorErrorCode = errorType.getMinorErrorCode();
            this.vendorSpecificErrorCode = errorType.getVendorSpecificErrorCode();
            this.errorStackTrace = errorType.getStackTrace();
            if (this.message.startsWith("[")) {
                this.message = this.message.substring(this.message.indexOf(93) + 1).trim();
            }
        }

        public VcimResponseException(HttpStatus statusCode, com.vmware.vcloud.api.rest.schema_v1_5.ErrorType errorType) {
            this.httpStatusCode = statusCode;
            this.message = errorType.getMessage();
            this.majorErrorCode = errorType.getMajorErrorCode();
            this.minorErrorCode = errorType.getMinorErrorCode();
            this.vendorSpecificErrorCode = errorType.getVendorSpecificErrorCode();
            this.errorStackTrace = errorType.getStackTrace();
            if (this.message.startsWith("[")) {
                this.message = this.message.substring(this.message.indexOf(93) + 1).trim();
            }
        }

        public VcimResponseException(HttpStatus statusCode) {
            this.httpStatusCode = statusCode;
            this.message = "Unable to marshall errorType";
            this.majorErrorCode = 99999;
            this.minorErrorCode = "ERRORTYPE_UNMARSHAL_ERROR";
        }

        public HttpStatus getHttpStatusCode() {
            return this.httpStatusCode;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        public int getMajorErrorCode() {
            return this.majorErrorCode;
        }

        public String getMinorErrorCode() {
            return this.minorErrorCode;
        }

        public String getVendorSpecificErrorCode() {
            return this.vendorSpecificErrorCode;
        }

        public String getErrorStackTrace() {
            return this.errorStackTrace;
        }
    }
}

