/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.security;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.params.HttpParams;

public class FakeSSLSocketFactory
extends SSLSocketFactory {
    private static FakeSSLSocketFactory instance;
    private static SSLContext customSslContext;
    private final String[] SUPPORTED_SSL_VERSIONS = new String[]{"SSLv3", "TLSv1"};

    public Socket connectSocket(Socket arg0, InetSocketAddress arg1, InetSocketAddress arg2, HttpParams arg3) throws IOException, UnknownHostException {
        SSLSocket sslSocket = (SSLSocket)super.connectSocket(arg0, arg1, arg2, arg3);
        sslSocket.setEnabledProtocols(this.SUPPORTED_SSL_VERSIONS);
        return sslSocket;
    }

    @Deprecated
    public Socket connectSocket(Socket arg0, String arg1, int arg2, InetAddress arg3, int arg4, HttpParams arg5) throws IOException, UnknownHostException, ConnectTimeoutException {
        SSLSocket sslSocket = (SSLSocket)super.connectSocket(arg0, arg1, arg2, arg3, arg4, arg5);
        sslSocket.setEnabledProtocols(this.SUPPORTED_SSL_VERSIONS);
        return sslSocket;
    }

    public Socket createLayeredSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        SSLSocket sslSocket = (SSLSocket)super.createLayeredSocket(socket, host, port, autoClose);
        sslSocket.setEnabledProtocols(this.SUPPORTED_SSL_VERSIONS);
        return sslSocket;
    }

    public Socket createLayeredSocket(Socket socket, String host, int port, HttpParams params) throws IOException, UnknownHostException {
        SSLSocket sslSocket = (SSLSocket)super.createLayeredSocket(socket, host, port, params);
        sslSocket.setEnabledProtocols(this.SUPPORTED_SSL_VERSIONS);
        return sslSocket;
    }

    @Deprecated
    public Socket createSocket() throws IOException {
        SSLSocket sslSocket = (SSLSocket)super.createSocket();
        sslSocket.setEnabledProtocols(this.SUPPORTED_SSL_VERSIONS);
        return sslSocket;
    }

    public Socket createSocket(HttpParams params) throws IOException {
        SSLSocket sslSocket = (SSLSocket)super.createSocket();
        sslSocket.setEnabledProtocols(this.SUPPORTED_SSL_VERSIONS);
        return sslSocket;
    }

    @Deprecated
    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        SSLSocket sslSocket = (SSLSocket)super.createSocket(socket, host, port, autoClose);
        sslSocket.setEnabledProtocols(this.SUPPORTED_SSL_VERSIONS);
        return sslSocket;
    }

    private FakeSSLSocketFactory() throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        super(new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                return true;
            }
        }, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
    }

    public static FakeSSLSocketFactory getInstance() {
        return instance;
    }

    static {
        customSslContext = null;
        try {
            customSslContext = SSLContext.getInstance("TLS");
            X509TrustManager tm = new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }
            };
            customSslContext.init(null, new TrustManager[]{tm}, null);
            instance = new FakeSSLSocketFactory();
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

