/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.security;

import com.vmware.vcim.ngc.service.security.ClientConnectionConfiguration;
import com.vmware.vcim.ngc.service.security.CommonX509TrustManager;
import com.vmware.vcim.ngc.service.security.CustomSSLFactory;
import com.vmware.vcim.ngc.service.security.exceptions.SSLContextException;
import com.vmware.vcim.ngc.service.security.exceptions.TrustManagerException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import org.apache.http.conn.ssl.SSLSocketFactory;

public class SecureContext {
    public static SSLSocketFactory getSSLSocketFactory(ClientConnectionConfiguration config) throws TrustManagerException, SSLContextException {
        TrustManager[] trustManagers = new TrustManager[]{new CommonX509TrustManager(config)};
        SSLContext customSSLContext = null;
        try {
            customSSLContext = SSLContext.getInstance(config.getSSLContextAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            throw new SSLContextException(SSLContextException.SSLContextError.E_NO_SUCH_ALGORITHM);
        }
        try {
            customSSLContext.init(null, trustManagers, null);
        }
        catch (KeyManagementException e) {
            throw new SSLContextException(SSLContextException.SSLContextError.E_KEY_MANAGEMENT);
        }
        SSLParameters params = new SSLParameters();
        params.setCipherSuites(config.getSupportedCipherSuites());
        params.setProtocols(config.getSupportedProtocols());
        params.setEndpointIdentificationAlgorithm(config.getEndpointIdentificationAlgorithm());
        CustomSSLFactory factory = new CustomSSLFactory(customSSLContext, params);
        return factory;
    }
}

