/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.tasks.impl;

import com.vmware.vcim.ngc.service.tasks.ObjectType;
import com.vmware.vcim.ngc.service.tasks.VCimTask;
import com.vmware.vise.core.model.monitor.ClientTaskInfo;
import com.vmware.vise.core.model.monitor.TaskState;

public class TaskAssembler {
    public ClientTaskInfo buildClientTaskInfo(VCimTask task) {
        ClientTaskInfo taskInfo = new ClientTaskInfo();
        taskInfo.rootTaskKey = taskInfo.key = "key-" + task.getId();
        taskInfo.eventChainId = 0;
        taskInfo.taskRef = new TaskRef(taskInfo.serverGuid, taskInfo.entityType);
        taskInfo.initiator = task.getOwner();
        taskInfo.entityName = task.getName();
        taskInfo.description = task.getDescription();
        taskInfo.source = "vCHS";
        String entityType = ObjectType.VM.value();
        String icon = ObjectType.VM.icon();
        if (task.getEntityType() != null) {
            entityType = task.getEntityType().type();
            icon = task.getEntityType().icon();
        }
        taskInfo.entityType = entityType;
        taskInfo.primaryIconId = icon;
        taskInfo.service = "vCHS";
        taskInfo.serverGuid = "vchs.vmware.com";
        taskInfo.cancelable = false;
        taskInfo.pausable = false;
        if (VCimTask.TaskState.RUNNING == task.getState()) {
            taskInfo.state = this.getTaskState("running");
            taskInfo.progress = this.getTaskProgress("running");
        } else {
            taskInfo.state = VCimTask.TaskState.SUCCESS == task.getState() ? this.getTaskState("completed") : this.getTaskState("failed");
            taskInfo.progress = this.getTaskProgress("completed");
        }
        taskInfo.queueTime = task.getStartTime();
        taskInfo.startTime = task.getStartTime();
        taskInfo.completionTime = task.getEndTime();
        taskInfo.entity = null;
        taskInfo.result = null;
        taskInfo.error = null;
        taskInfo.labelIds = "";
        return taskInfo;
    }

    private TaskState getTaskState(String state) {
        if (state.equals("running")) {
            return TaskState.RUNNING;
        }
        if (state.equals("failed")) {
            return TaskState.ERROR;
        }
        if (state.equals("canceled")) {
            return TaskState.CANCELED;
        }
        if (state.equals("waiting")) {
            return TaskState.RUNNING;
        }
        if (state.equals("waiting-signal")) {
            return TaskState.PAUSED;
        }
        if (state.equals("suspended")) {
            return TaskState.PAUSED;
        }
        if (state.equals("completed")) {
            return TaskState.SUCCESS;
        }
        if (state.equals("initializing")) {
            return TaskState.RUNNING;
        }
        return TaskState.ERROR;
    }

    private int getTaskProgress(String state) {
        if (state.equals("running")) {
            return -1;
        }
        if (state.equals("failed")) {
            return 100;
        }
        if (state.equals("canceled")) {
            return 100;
        }
        if (state.equals("waiting")) {
            return -1;
        }
        if (state.equals("waiting-signal")) {
            return -1;
        }
        if (state.equals("suspended")) {
            return -1;
        }
        if (state.equals("completed")) {
            return 100;
        }
        if (state.equals("initializing")) {
            return -1;
        }
        return -1;
    }

    public static class TaskRef {
        private String serverGuid;
        private String type;

        public TaskRef(String serverGuid, String type) {
            this.serverGuid = serverGuid;
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public String getServerGuid() {
            return this.serverGuid;
        }
    }
}

