/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.vpc.impl;

import com.vmware.ares.auth.v1.VCDSessionTokenType;
import com.vmware.ares.common.v1.EntityState;
import com.vmware.ares.common.v1.LinkType;
import com.vmware.ares.common.v1.TaskState;
import com.vmware.ares.common.v1.TaskType;
import com.vmware.ares.common.v2.CloudTypeType;
import com.vmware.ares.common.v2.StorageTierType;
import com.vmware.ares.common.v2.StorageTiersListType;
import com.vmware.ares.product.v1.SharedCloudVdcPutType;
import com.vmware.ares.product.v2.DcVdcParamsType;
import com.vmware.ares.vcd.v1.ComputeCapacityType;
import com.vmware.ares.vcd.v1.VdcStorageProfileType;
import com.vmware.ares.vcd.v1.VdcStorageProfilesType;
import com.vmware.ares.vcd.v1.VdcUserType;
import com.vmware.ares.vcd.v1.VdcUsersType;
import com.vmware.ares.vcd.v2.DR2CPlaceholderListType;
import com.vmware.ares.vcd.v2.DR2CPlaceholderType;
import com.vmware.ares.vcd.v2.VdcSnapshotListType;
import com.vmware.ares.vcd.v2.VdcSnapshotType;
import com.vmware.ares.vcd.v2.VdcType;
import com.vmware.vcim.ngc.service.adapter.common.AdapterWrapper;
import com.vmware.vcim.ngc.service.adapter.common.DataAdapter;
import com.vmware.vcim.ngc.service.adapter.common.DataAdapterFactory;
import com.vmware.vcim.ngc.service.impl.VcimSessionManager;
import com.vmware.vcim.ngc.service.model.DR2CVMCount;
import com.vmware.vcim.ngc.service.model.VCimRegion;
import com.vmware.vcim.ngc.service.model.VCimVirtualDatacenter;
import com.vmware.vcim.ngc.service.model.VCimVirtualMachine;
import com.vmware.vcim.ngc.service.model.VCimVirtualMachineReplicationStatus;
import com.vmware.vcim.ngc.service.model.VCimVpc;
import com.vmware.vcim.ngc.service.model.VchsObjectType;
import com.vmware.vcim.ngc.service.model.VdcUser;
import com.vmware.vcim.ngc.service.rest.vcim.VcimRestClient;
import com.vmware.vcim.ngc.service.tasks.ObjectType;
import com.vmware.vcim.ngc.service.tasks.TaskException;
import com.vmware.vcim.ngc.service.tasks.TaskService;
import com.vmware.vcim.ngc.service.tasks.VCimTask;
import com.vmware.vcim.ngc.service.vpc.contracts.CloudInstanceOperations;
import com.vmware.vcim.ngc.service.vpc.contracts.VirtualDatacenterOperations;
import com.vmware.vcim.ngc.service.vpc.contracts.VirtualMachineOperations;
import com.vmware.vcim.ngc.service.vpc.impl.RegionVpcAdapter;
import com.vmware.vcim.ngc.service.vpc.impl.VpcAdapter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class VirtualDatacenterVpcAdapter
extends VpcAdapter
implements VirtualDatacenterOperations,
DataAdapter {
    private DataAdapterFactory dataAdapterFactory;
    private final AdapterWrapper adapterWrapper;
    private final RegionVpcAdapter regionVpcAdapter;
    private final TaskService taskService;
    private final VcimSessionManager vcimSessionManager;
    private static final Logger logger = LoggerFactory.getLogger(VirtualDatacenterVpcAdapter.class);
    private Map<String, VdcStaticData> vdcStaticDataMap = new HashMap<String, VdcStaticData>();
    public static final String ADD_VDC_DESCRIPTION = "Creating VDC";
    public static final String UPDATE_VDC_DESCRIPTION = "Updating VDC";
    public static final String UPDATE_VDC_VM_QUOTA_DESCRIPTION = "Updating VDC's VM Quota";
    public static final String DELETE_VDC_DESCRIPTION = "Deleting VDC";
    public static final String LOCK_VDC_DESCRIPTION = "Locking VDC";
    public static final String UNLOCK_VDC_DESCRIPTION = "Unlocking VDC";

    public VirtualDatacenterVpcAdapter(VcimRestClient vcimRestClient, AdapterWrapper adapterWrapper, RegionVpcAdapter regionVpcAdapter, TaskService taskService, VcimSessionManager vcimSessionManager) {
        super(vcimRestClient);
        this.adapterWrapper = adapterWrapper;
        this.regionVpcAdapter = regionVpcAdapter;
        this.taskService = taskService;
        this.vcimSessionManager = vcimSessionManager;
    }

    public DataAdapterFactory getDataAdapterFactory() {
        return this.dataAdapterFactory;
    }

    public void setDataAdapterFactory(DataAdapterFactory dataAdapterFactory) {
        this.dataAdapterFactory = dataAdapterFactory;
        this.dataAdapterFactory.registerAdapter(this);
    }

    @Override
    public List<VCimVirtualDatacenter> getVDCs(String clientSessionId) {
        ArrayList<VCimVirtualDatacenter> vdcs = new ArrayList<VCimVirtualDatacenter>();
        List<VCimRegion> regions = this.regionVpcAdapter.getRegions(clientSessionId);
        for (VCimRegion region : regions) {
            vdcs.addAll(this.getVDCs(clientSessionId, region, DatacenterType.BOTH));
        }
        return vdcs;
    }

    @Override
    public List<VCimVirtualDatacenter> getSharedVDCs(String clientSessionId) {
        ArrayList<VCimVirtualDatacenter> vdcs = new ArrayList<VCimVirtualDatacenter>();
        List<VCimRegion> regions = this.regionVpcAdapter.getRegions(clientSessionId);
        for (VCimRegion region : regions) {
            vdcs.addAll(this.getVDCs(clientSessionId, region, DatacenterType.SHARED));
        }
        return vdcs;
    }

    private List<VCimVirtualDatacenter> getVDCs(String clientSessionId, VCimRegion region, DatacenterType vdcType) {
        logger.info("Fetching vdcs of region " + region.getName());
        ArrayList<VCimVirtualDatacenter> vDCs = new ArrayList<VCimVirtualDatacenter>();
        String url = "/api/private/region/<REGION_ID>/vdcs";
        url = url.replace("<REGION_ID>", region.getId());
        ResponseEntity vdcResponse = (ResponseEntity)this.vcimRestClient.sendGetRequest(url, VdcSnapshotListType.class, null, clientSessionId);
        if (null != vdcResponse) {
            VdcSnapshotListType vdcs = (VdcSnapshotListType)vdcResponse.getBody();
            for (VdcSnapshotType vdc : vdcs.getVdcSnapshot()) {
                if (!(vdcType == DatacenterType.BOTH || vdc.getContainerCloudType() == CloudTypeType.DC && vdcType == DatacenterType.PRIVATE || vdc.getContainerCloudType() == CloudTypeType.VPC && vdcType == DatacenterType.SHARED) && (vdc.getContainerCloudType() != CloudTypeType.DR_2_C || vdcType != DatacenterType.SHARED)) continue;
                VCimVirtualDatacenter vDC = new VCimVirtualDatacenter(vdc);
                vDC.setRegionName(region.getName());
                vDC.setRegionId(region.getId());
                vDCs.add(vDC);
                this.putvdcStaticData(vDC.getId(), new VdcStaticData(vDC));
            }
        }
        return vDCs;
    }

    private void getVDCDetails(String clientSessionId, VCimVirtualDatacenter vDC) {
        logger.info("Fetching details of vdcs - " + vDC.getName());
        ResponseEntity response = (ResponseEntity)this.vcimRestClient.sendGetRequest(vDC.getHref(), VdcType.class, null, clientSessionId);
        VdcType vdcType = (VdcType)response.getBody();
        vDC.setDescription(vdcType.getDescription());
        vDC.setEnabled(vdcType.isIsEnabled());
        vDC.setVmQuota(vdcType.getVmQuota());
    }

    private void getVPCDetailsForVDC(String clientSessionId, VCimVirtualDatacenter vDC, String vpcId) {
        logger.info("Fetching cloud details of vdc" + vDC.getName());
        VCimVpc vpc = this.getCloudReadOnlyAdapter().getVpcById(clientSessionId, vpcId);
        vDC.setVpcVcpuAvailable(vpc.getCpuAvailable());
        vDC.setVpcMemoryAvailable(vpc.getMemoryAvailable());
        vDC.setVpcStorageAvailable(vpc.getStorageAvailable());
        vDC.setVpcStorageTiersAvailable(vpc.getStorageTier());
    }

    @Override
    public VCimVirtualDatacenter getVDC(String clientSessionId, URI vDCUri) {
        logger.info("Fetching VDC with URI - " + vDCUri.toString());
        String regionId = VCimVirtualDatacenter.getRegionId(vDCUri);
        boolean isPrivate = VCimVirtualDatacenter.isPrivate(vDCUri);
        List<VCimVirtualDatacenter> vDCs = this.getVDCs(clientSessionId, this.regionVpcAdapter.getRegion(clientSessionId, regionId), isPrivate ? DatacenterType.PRIVATE : DatacenterType.SHARED);
        if (vDCs != null) {
            for (VCimVirtualDatacenter vDC : vDCs) {
                if (!vDCUri.equals(vDC.getUri())) continue;
                try {
                    this.getVDCDetails(clientSessionId, vDC);
                }
                catch (Exception ex) {
                    logger.error("Error fetching details of VDC", (Throwable)ex);
                }
                String vpcId = VCimVirtualDatacenter.getVpcId(vDCUri);
                this.getVPCDetailsForVDC(clientSessionId, vDC, vpcId);
                logger.info("VDC found");
                return vDC;
            }
        }
        return null;
    }

    @Override
    public VCimVirtualDatacenter getVDCById(String clientSessionId, String vdcId) {
        logger.info("Fetching VDC with id - " + vdcId);
        VdcStaticData staticData = this.getvdcStaticData(vdcId);
        List<VCimVirtualDatacenter> vDCs = null;
        vDCs = staticData != null ? this.getVDCs(clientSessionId, this.regionVpcAdapter.getRegion(clientSessionId, staticData.region), staticData.vdcType) : this.getVDCs(clientSessionId);
        if (vDCs != null) {
            for (VCimVirtualDatacenter vDC : vDCs) {
                if (!vDC.getId().equalsIgnoreCase(vdcId)) continue;
                logger.info("VDC found - " + vDC.getName());
                return vDC;
            }
        }
        return null;
    }

    @Override
    public List<VdcUser> getVdcUsers(String clientSessionId, String vpcId, String vdcId) {
        logger.info("Fetching users of VDC with id - " + vdcId);
        ArrayList<VdcUser> users = new ArrayList<VdcUser>();
        String url = "/api/private/dc/<VPC_ID>/vdc/<VDC_ID>/useraccess";
        url = !StringUtils.isEmpty((String)vpcId) ? url.replace("<VPC_ID>", vpcId) : "/api/private/vpc/<VDC_ID>/useraccess";
        url = url.replace("<VDC_ID>", vdcId);
        ResponseEntity response = (ResponseEntity)this.vcimRestClient.sendGetRequest(url, VdcUsersType.class, null, clientSessionId);
        VdcUsersType vdcUsers = (VdcUsersType)response.getBody();
        if (null != vdcUsers) {
            for (VdcUserType vdcUser : vdcUsers.getVdcUser()) {
                VdcUser user = new VdcUser();
                user.setId(vdcUser.getId());
                user.setFirstName(vdcUser.getFirstName());
                user.setLastName(vdcUser.getLastName());
                user.setUsername(vdcUser.getUsername());
                user.setHref(vdcUser.getHref());
                user.setEditable(vdcUser.isEditable());
                user.setRoles(vdcUser.getRoles());
                user.setHasVdcAccess(vdcUser.isHasVdcAccess());
                users.add(user);
            }
        }
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VdcStaticData getvdcStaticData(String key) {
        Map<String, VdcStaticData> map = this.vdcStaticDataMap;
        synchronized (map) {
            return this.vdcStaticDataMap.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putvdcStaticData(String key, VdcStaticData value) {
        Map<String, VdcStaticData> map = this.vdcStaticDataMap;
        synchronized (map) {
            this.vdcStaticDataMap.put(key, value);
        }
    }

    @Override
    public void addVdc(String clientSessionId, String vdcName, String vpcId, int cpu, int memory, String storage, int publicIps) {
        logger.info("Adding VDC in cloud with id - " + vpcId + ": Name - " + vdcName + ", memomry - " + memory + ", Storage - " + storage + ", Public IPs - " + publicIps);
        DcVdcParamsType vdc = new DcVdcParamsType();
        String url = "/api/private/dc/<VPC_ID>/vdcs";
        url = url.replace("<VPC_ID>", vpcId);
        vdc.setName(vdcName);
        vdc.setCpuCapacityGhz(cpu);
        vdc.setMemoryCapacityGb(memory);
        StorageTiersListType stl = new StorageTiersListType();
        StringTokenizer stt = new StringTokenizer(storage, ";");
        while (stt.hasMoreTokens()) {
            String[] tierStr = stt.nextToken().split(":");
            StorageTierType st = new StorageTierType();
            st.setName(tierStr[0]);
            st.setCapacity(new Integer(tierStr[1]));
            if (st.getCapacity() <= 0) continue;
            stl.getStorageTier().add(st);
        }
        stl.getStorageTier().get(0).setDefault(true);
        vdc.setStorageTiers(stl);
        vdc.setExternalIpQuantity(publicIps);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "vnd.vmware.ares.dcvdc");
        this.vcimRestClient.sendPostRequest(url, vdc, String.class, headers, clientSessionId);
    }

    @Override
    public void updateVdcSettings(String clientSessionId, String href, String vdcName, String vdcDesc, int cpuAlloc, int memoryAlloc, String storageAlloc) {
        logger.info("Updating VDC with href - " + href + ": Name - " + vdcName + ", memomry - " + memoryAlloc + ", Storage - " + storageAlloc + ", CPU - " + cpuAlloc);
        if (VCimVirtualDatacenter.isPrivate(href)) {
            ResponseEntity response = (ResponseEntity)this.vcimRestClient.sendGetRequest(href, VdcType.class, null, clientSessionId);
            VdcType vdcType = (VdcType)response.getBody();
            for (LinkType link : vdcType.getLink()) {
                if (!link.getName().equals("edit")) continue;
                VdcType vdc = new VdcType();
                ComputeCapacityType computeCapacityType = new ComputeCapacityType();
                computeCapacityType.setCpuGhz(cpuAlloc);
                computeCapacityType.setMemoryGb(memoryAlloc);
                VdcStorageProfilesType stl = new VdcStorageProfilesType();
                StringTokenizer stt = new StringTokenizer(storageAlloc, ";");
                while (stt.hasMoreTokens()) {
                    String[] tierStr = stt.nextToken().split(":");
                    VdcStorageProfileType st = new VdcStorageProfileType();
                    st.setId(tierStr[0]);
                    st.setSizeMb(Integer.parseInt(tierStr[1]) * 1024);
                    if (st.getSizeMb() <= 0) continue;
                    stl.getStorageProfile().add(st);
                }
                vdc.setStorageProfiles(stl);
                vdc.setName(vdcName);
                vdc.setDescription(vdcDesc);
                vdc.setComputeCapacity(computeCapacityType);
                vdc.setVmQuota(vdcType.getVmQuota());
                vdc.setHref(vdcType.getHref());
                vdc.setId(vdcType.getId());
                vdc.setIsEnabled(vdcType.isIsEnabled());
                vdc.setIsThinProvision(vdcType.isIsThinProvision());
                vdc.setSdpServiceId(vdcType.getSdpServiceId());
                vdc.setState(vdcType.getState());
                vdc.setType(vdcType.getType());
                vdc.setTasks(vdcType.getTasks());
                vdc.setUsesFastProvisioning(vdcType.isUsesFastProvisioning());
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Content-Type", "vnd.vmware.ares.vdc");
                this.vcimRestClient.sendPutRequest(link.getHref(), vdc, String.class, headers, clientSessionId);
            }
        }
    }

    @Override
    public void updateVdcVMQuota(String clientSessionId, String href, int vmQuota) {
        logger.info("Setting VM quota of VDC with href - " + href + " to " + vmQuota);
        ResponseEntity response = (ResponseEntity)this.vcimRestClient.sendGetRequest(href, VdcType.class, null, clientSessionId);
        VdcType vdcType = (VdcType)response.getBody();
        for (LinkType link : vdcType.getLink()) {
            HashMap<String, String> headers;
            if (!link.getName().equals("edit")) continue;
            if (!VCimVirtualDatacenter.isPrivate(href)) {
                SharedCloudVdcPutType sharedCloudVdcPut = new SharedCloudVdcPutType();
                sharedCloudVdcPut.setVmQuota(vmQuota);
                sharedCloudVdcPut.setName(vdcType.getName());
                sharedCloudVdcPut.setDescription(vdcType.getDescription());
                sharedCloudVdcPut.setHref(vdcType.getHref());
                sharedCloudVdcPut.setId(vdcType.getId());
                sharedCloudVdcPut.setIsEnabled(vdcType.isIsEnabled());
                sharedCloudVdcPut.setIsThinProvision(vdcType.isIsThinProvision());
                sharedCloudVdcPut.setUsesFastProvisioning(vdcType.isUsesFastProvisioning());
                sharedCloudVdcPut.setType(vdcType.getType());
                sharedCloudVdcPut.setTasks(vdcType.getTasks());
                sharedCloudVdcPut.setState(vdcType.getState());
                headers = new HashMap<String, String>();
                headers.put("Content-Type", "vnd.vmware.ares.sharedcloudvdcput");
                this.vcimRestClient.sendPutRequest(link.getHref(), sharedCloudVdcPut, String.class, headers, clientSessionId);
                continue;
            }
            VdcType vdc = new VdcType();
            vdc.setVmQuota(vmQuota);
            vdc.setName(vdcType.getName());
            vdc.setDescription(vdcType.getDescription());
            vdc.setComputeCapacity(vdcType.getComputeCapacity());
            vdc.setHref(vdcType.getHref());
            vdc.setId(vdcType.getId());
            vdc.setIsEnabled(vdcType.isIsEnabled());
            vdc.setIsThinProvision(vdcType.isIsThinProvision());
            vdc.setSdpServiceId(vdcType.getSdpServiceId());
            vdc.setState(vdcType.getState());
            vdc.setType(vdcType.getType());
            vdc.setTasks(vdcType.getTasks());
            vdc.setUsesFastProvisioning(vdcType.isUsesFastProvisioning());
            headers = new HashMap();
            headers.put("Content-Type", "vnd.vmware.ares.vdc");
            this.vcimRestClient.sendPutRequest(link.getHref(), vdc, String.class, headers, clientSessionId);
        }
    }

    @Override
    public void deleteVdc(String clientSessionId, String href) {
        logger.info("Deleting VDC with href - " + href);
        this.vcimRestClient.sendDeleteRequest(href, null, String.class, clientSessionId);
    }

    @Override
    public void changeVdcStatus(String clientSessionId, String href, boolean status) {
        try {
            ResponseEntity response = (ResponseEntity)this.vcimRestClient.sendGetRequest(href, VdcType.class, null, clientSessionId);
            VdcType vdcType = (VdcType)response.getBody();
            for (LinkType link : vdcType.getLink()) {
                TaskType task;
                ResponseEntity taskTypeResponse;
                if (status) {
                    if (!link.getName().equals("unlock")) continue;
                    logger.info("Unlocking VDC with href - " + href);
                    taskTypeResponse = (ResponseEntity)this.vcimRestClient.sendPostRequest(link.getHref(), null, TaskType.class, clientSessionId);
                    task = (TaskType)taskTypeResponse.getBody();
                    this.taskService.pushTask(this.convertToVcimTask(task, vdcType.getName(), UNLOCK_VDC_DESCRIPTION, clientSessionId));
                    continue;
                }
                if (!link.getName().equals("lock")) continue;
                logger.info("Locking VDC with href - " + href);
                taskTypeResponse = (ResponseEntity)this.vcimRestClient.sendPostRequest(link.getHref(), null, TaskType.class, clientSessionId);
                task = (TaskType)taskTypeResponse.getBody();
                this.taskService.pushTask(this.convertToVcimTask(task, vdcType.getName(), LOCK_VDC_DESCRIPTION, clientSessionId));
            }
        }
        catch (TaskException ex) {
            logger.error("Could not push task", (Throwable)ex);
        }
    }

    private VCimTask convertToVcimTask(TaskType taskType, String name, String description, String clientSessionId) {
        VCimTask vcimTask = new VCimTask(taskType.getId(), null);
        vcimTask.setEntityId(taskType.getOwnerId());
        vcimTask.setEntityType(ObjectType.VDC);
        vcimTask.setName(name);
        vcimTask.setStartTime(taskType.getStartTime().toGregorianCalendar().getTime());
        if (taskType.getEndTime() != null) {
            vcimTask.setEndTime(taskType.getEndTime().toGregorianCalendar().getTime());
        }
        vcimTask.setDescription(description);
        vcimTask.setOwner(this.vcimSessionManager.getSession(clientSessionId).getUsername());
        if (taskType.getStatus() == TaskState.QUEUED || taskType.getStatus() == TaskState.RUNNING) {
            vcimTask.setState(VCimTask.TaskState.RUNNING);
        }
        if (taskType.getStatus() == TaskState.TASK_ERROR || taskType.getStatus() == TaskState.CANCELED || taskType.getStatus() == TaskState.ABORTED) {
            vcimTask.setState(VCimTask.TaskState.ERROR);
        }
        if (taskType.getStatus() == TaskState.SUCCESS) {
            vcimTask.setState(VCimTask.TaskState.SUCCESS);
        }
        return vcimTask;
    }

    @Override
    public List<VCimVirtualDatacenter> getVDCsForVpc(String clientSessionId, String vpcId) {
        ArrayList<VCimVirtualDatacenter> vdcList = new ArrayList<VCimVirtualDatacenter>();
        VCimVpc vpc = this.getCloudReadOnlyAdapter().getVpcById(clientSessionId, vpcId);
        logger.info("Get VDCs2 for cloud - " + vpc.getName());
        URI vpcUri = vpc.getUri();
        String regionId = VCimVpc.getRegionId(vpcUri);
        boolean isPrivate = VCimVpc.isPrivate(vpcUri);
        VCimRegion region = this.regionVpcAdapter.getRegion(clientSessionId, regionId);
        List<VCimVirtualDatacenter> vDCs = this.getVDCs(clientSessionId, region, isPrivate ? DatacenterType.PRIVATE : DatacenterType.SHARED);
        if (vDCs != null) {
            for (VCimVirtualDatacenter vDC : vDCs) {
                if (!vpcId.equalsIgnoreCase(vDC.getCloudId()) || EntityState.ERROR == vDC.getState()) continue;
                vDC.setVpcVcpuAvailable(vpc.getCpuAvailable());
                vDC.setVpcMemoryAvailable(vpc.getMemoryAvailable());
                vDC.setVpcStorageAvailable(vpc.getStorageAvailable());
                vDC.setVpcStorageTiersAvailable(vpc.getStorageTier());
                vdcList.add(vDC);
            }
        }
        return vdcList;
    }

    @Override
    public List<VCimVirtualDatacenter> getPrivateVDCs(String clientSessionId) {
        ArrayList<VCimVirtualDatacenter> vdcs = new ArrayList<VCimVirtualDatacenter>();
        List<VCimRegion> regions = this.regionVpcAdapter.getRegions(clientSessionId);
        for (VCimRegion region : regions) {
            vdcs.addAll(this.getVDCs(clientSessionId, region, DatacenterType.PRIVATE));
        }
        return vdcs;
    }

    @Override
    public String getVcdSsoToken(String clientSessionId, String vdcId) {
        VCimVirtualDatacenter vdc = this.getVDCById(clientSessionId, vdcId);
        return this.getVcdSsoToken(clientSessionId, vdc);
    }

    @Override
    public String getVcdSsoToken(String clientSessionId, VCimVirtualDatacenter vdc) {
        ResponseEntity tokenResponse;
        logger.info("Getting SSO token for VDC - " + vdc.getName());
        String ssoUri = vdc.getVcdSsoTokenUrl();
        if (ssoUri != null && !ssoUri.equals("") && null != (tokenResponse = (ResponseEntity)this.vcimRestClient.sendGetRequest(ssoUri, VCDSessionTokenType.class, null, clientSessionId))) {
            logger.info("SSO token obtained for VDC - " + vdc.getName());
            VCDSessionTokenType token = (VCDSessionTokenType)tokenResponse.getBody();
            return token.getToken();
        }
        return null;
    }

    @Override
    public DataAdapter.AdapterType getAdapterType() {
        return DataAdapter.AdapterType.READ_WRITE_ADAPTER;
    }

    @Override
    public VchsObjectType getSupportedObjectType() {
        return VchsObjectType.DATACENTER;
    }

    private CloudInstanceOperations getCloudReadOnlyAdapter() {
        return (CloudInstanceOperations)((Object)this.adapterWrapper.getReadOnlyAdapter(VchsObjectType.CLOUD));
    }

    @Override
    public List<VCimVirtualMachineReplicationStatus> getVirtualMachineReplicationStatusesForVdc(String clientSessionId, String vdcId) {
        List<VCimVirtualMachineReplicationStatus> vms = new ArrayList<VCimVirtualMachineReplicationStatus>();
        VCimVirtualDatacenter vDC = this.getVDCById(clientSessionId, vdcId);
        if (null != vDC) {
            vms = this.getVirtualMachineReplicationStatusesForVdc(clientSessionId, vDC);
        }
        return vms;
    }

    private List<VCimVirtualMachineReplicationStatus> getVirtualMachineReplicationStatusesForVdc(String clientSessionId, VCimVirtualDatacenter vDC) {
        logger.debug("Fetching DR2C virtual machines statuses for VDC - " + vDC.getName());
        Date currentTimestamp = new Date();
        logger.info("Fetching DR2C virtual machines statuses for VDC " + vDC.getName() + " from vCHS, Timestamp @ " + currentTimestamp.getTime());
        ArrayList<VCimVirtualMachineReplicationStatus> statuses = new ArrayList<VCimVirtualMachineReplicationStatus>();
        String url = null;
        if (CloudTypeType.DR_2_C == vDC.getContainerCloudType()) {
            url = "/api/private/dr2c/<VDC_ID>/placeholders";
            ResponseEntity statusResponse = (ResponseEntity)this.vcimRestClient.sendGetRequest(url = url.replace("<VDC_ID>", vDC.getId()), DR2CPlaceholderListType.class, null, clientSessionId);
            if (null != statusResponse) {
                DR2CPlaceholderListType placeHolderList = (DR2CPlaceholderListType)statusResponse.getBody();
                for (DR2CPlaceholderType placeholder : placeHolderList.getDR2CPlaceholders()) {
                    VCimVirtualMachineReplicationStatus status = new VCimVirtualMachineReplicationStatus(placeholder, vDC.getCloudId());
                    status.setVDC(vDC);
                    statuses.add(status);
                }
            }
        }
        currentTimestamp = new Date();
        logger.info("Completed fetching DR2C virtual machines statuses for VDC " + vDC.getName() + " from vCHS, Timestamp @ " + currentTimestamp.getTime());
        return statuses;
    }

    @Override
    public DR2CVMCount getDR2CVMCount(String clientSessionId, String vdcId) {
        VirtualMachineOperations adapter = (VirtualMachineOperations)((Object)this.adapterWrapper.getReadOnlyAdapter(VchsObjectType.VIRTUAL_MACHINE));
        List<VCimVirtualMachine> vms = adapter.getVirtualMachinesForVdc(clientSessionId, vdcId);
        DR2CVMCount count = null;
        int recoveredVMs = 0;
        int testReadyVMs = 0;
        int placeholderVMs = 0;
        if (null != vms) {
            for (VCimVirtualMachine vm : vms) {
                if (vm.getRecoveryStatus().equalsIgnoreCase("Replication in Progress")) {
                    ++placeholderVMs;
                    continue;
                }
                if (vm.getRecoveryStatus().equalsIgnoreCase("Test Ready")) {
                    ++testReadyVMs;
                    continue;
                }
                if (!vm.getRecoveryStatus().equalsIgnoreCase("Recovered")) continue;
                ++recoveredVMs;
            }
            count = new DR2CVMCount(recoveredVMs, testReadyVMs, placeholderVMs);
        }
        return count;
    }

    private class VdcStaticData {
        public String region;
        public DatacenterType vdcType;

        public VdcStaticData(VCimVirtualDatacenter vdc) {
            this.region = vdc.getRegionId();
            this.vdcType = vdc.getContainerCloudType() == CloudTypeType.DC ? DatacenterType.PRIVATE : DatacenterType.SHARED;
        }
    }

    private static enum DatacenterType {
        PRIVATE,
        SHARED,
        BOTH;

    }
}

