/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.vpc.notification.impl;

import com.vmware.vcim.ngc.service.model.Notification;
import com.vmware.vcim.ngc.service.tasks.ObjectType;
import com.vmware.vcim.ngc.service.tasks.TaskException;
import com.vmware.vcim.ngc.service.tasks.TaskService;
import com.vmware.vcim.ngc.service.tasks.VCimTask;
import com.vmware.vcim.ngc.service.vpc.notification.NotificationCallback;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationCallbackImpl
implements NotificationCallback {
    private final TaskService taskService;
    private Map<String, ObjectType> entityTypes;
    private Map<ObjectType, Map<String, String>> notificationToNgcTaskType;
    private static final Logger logger = LoggerFactory.getLogger(NotificationCallbackImpl.class);
    private final String NOTIFICATION_TYPE_UPDATE = "com/vmware/ares/event/task/update";

    public NotificationCallbackImpl(TaskService taskService) {
        this.taskService = taskService;
        this.populateEntityTypes();
        this.populateTaskTypes();
    }

    private void populateEntityTypes() {
        this.entityTypes = new HashMap<String, ObjectType>();
        this.entityTypes.put("application/xml;class=vnd.vmware.ares.vdc", ObjectType.VDC);
        this.entityTypes.put("application/xml;class=vnd.vmware.ares.vmtype", ObjectType.VM);
        this.entityTypes.put("application/xml;class=vnd.vmware.ares.gateway", ObjectType.GATEWAY);
        this.entityTypes.put("application/xml;class=vnd.vmware.ares.networksnapshot", ObjectType.GATEWAY);
        this.entityTypes.put("application/xml;class=vnd.vmware.ares.dr2cplaceholder+xml", ObjectType.VM);
    }

    private void populateTaskTypes() {
        this.notificationToNgcTaskType = new HashMap<ObjectType, Map<String, String>>();
        HashMap<String, String> vmOperations = new HashMap<String, String>();
        vmOperations.put("Update_Vm_Network", "Updating VM Networks");
        vmOperations.put("PowerOff", "Powering Off VM");
        vmOperations.put("PowerOn", "Powering On VM");
        vmOperations.put("Suspend", "Suspending VM");
        vmOperations.put("RevertToSnapshot", "Reverting Snapshot");
        vmOperations.put("CreateSnapshot", "Creating snapshot");
        vmOperations.put("DeleteSnapshot", "Deleting Snapshot");
        vmOperations.put("Create", "Creating VM");
        vmOperations.put("Delete", "Deleting VM");
        vmOperations.put("Update", "Updating VM");
        vmOperations.put("RESET", "Resetting VM");
        vmOperations.put("Update_Vm_Owner", "Changing VM Owner");
        vmOperations.put("Update_Vm_NameDesc", "Updating VM Name and Description");
        vmOperations.put("Update_Storage", "Updating VM Storage");
        vmOperations.put("Update_Memory", "Updating VM Memory");
        vmOperations.put("Update_CPU", "Updating VM CPU");
        vmOperations.put("Test", "Test");
        vmOperations.put("Clean", "Cleanup");
        vmOperations.put("Recovery", "Recover");
        vmOperations.put("Remove_Replication", "Remove Replication");
        this.notificationToNgcTaskType.put(ObjectType.VM, vmOperations);
        HashMap<String, String> vdcOperations = new HashMap<String, String>();
        vdcOperations.put("Create", "Creating VDC");
        vdcOperations.put("Delete", "Deleting VDC");
        vdcOperations.put("Update", "Updating VDC");
        this.notificationToNgcTaskType.put(ObjectType.VDC, vdcOperations);
        HashMap<String, String> gatewayOperations = new HashMap<String, String>();
        gatewayOperations.put("Create", "Creating Gateway");
        gatewayOperations.put("Delete", "Deleting Gateway");
        gatewayOperations.put("Update", "Updating Gateway");
        this.notificationToNgcTaskType.put(ObjectType.GATEWAY, gatewayOperations);
    }

    @Override
    public void onMessage(String userName, Notification notification) {
        logger.info("Notification received for user: " + userName + ", Task State: " + notification.getTaskType());
        VCimTask task = this.getTaskFromNotification(notification);
        try {
            if (task != null) {
                this.taskService.pushTask(task);
            }
        }
        catch (TaskException e) {
            logger.error("Unable to push task to Task Service", (Throwable)e);
        }
    }

    private VCimTask getTaskFromNotification(Notification notification) {
        VCimTask task = null;
        if (this.entityTypes.containsKey(notification.getOwnerMediaType())) {
            task = new VCimTask(notification.getEntityId(), notification.getCompanyId());
            task.setNotification(notification);
            task.setEntityId(notification.getOwnerId());
            task.setName(notification.getOwnerName());
            task.setStartTime(new Date());
            task.setEndTime(notification.getRecievedAt());
            ObjectType entityType = this.entityTypes.get(notification.getOwnerMediaType());
            Map<String, String> operationDesc = this.notificationToNgcTaskType.get(entityType);
            if (null != operationDesc && operationDesc.containsKey(notification.getTaskType())) {
                task.setDescription(operationDesc.get(notification.getTaskType()));
            } else {
                task.setDescription(notification.getTaskType());
            }
            task.setEntityType(entityType);
            task.setOwner(notification.getUserName());
            if (-1 != notification.getNotificationType().indexOf("com/vmware/ares/event/task/update")) {
                task.setState(VCimTask.TaskState.RUNNING);
            } else if (notification.isOperationSuccess()) {
                task.setState(VCimTask.TaskState.SUCCESS);
            } else {
                task.setState(VCimTask.TaskState.ERROR);
            }
        } else {
            logger.error("Cannot find mapping for media Type {} and so cannot create VCimTask", (Object)notification.getOwnerMediaType());
        }
        return task;
    }

    @Override
    public void addUser(String user) {
    }

    @Override
    public void removeUser(String user) {
        this.taskService.purgeTasks(user);
    }

    public void unregisterBean() {
    }
}

