/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.filter;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.types.FilterSet;

public class TokenReplacerFilterInputStream
extends FilterInputStream {
    private static final String DEFAULT_TOKEN_BEGIN = "${";
    private static final String DEFAULT_TOKEN_END = "}";
    private static final int DEFAULT_BUFSIZ = 8192;
    private PushbackInputStream is;
    private FilterSet filter;
    private byte[] buffer;
    private int index;

    public TokenReplacerFilterInputStream(InputStream in) {
        super(in);
        this.is = new PushbackInputStream(in, 8192);
        this.buffer = null;
        this.index = 0;
        this.filter = new FilterSet();
        this.filter.setBeginToken(DEFAULT_TOKEN_BEGIN);
        this.filter.setEndToken(DEFAULT_TOKEN_END);
    }

    public TokenReplacerFilterInputStream(InputStream in, Map filters) {
        this(in);
        this.addFilters(filters);
    }

    public void setBeginToken(String token) {
        this.filter.setBeginToken(token);
    }

    public void setEndToken(String token) {
        this.filter.setEndToken(token);
    }

    public void addFilter(String name, String value) {
        this.filter.addFilter(name, value);
    }

    public void addFilters(Map filters) {
        Set keys = filters.keySet();
        for (String key : keys) {
            this.filter.addFilter(key, filters.get(key).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        InputStream inputStream = this.in;
        synchronized (inputStream) {
            if (!this.refreshBuffer()) {
                return -1;
            }
            return this.buffer[this.index++];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] buf, int offset, int len) throws IOException {
        int i;
        if (len > buf.length) {
            throw new IllegalArgumentException("buffer not large enough");
        }
        InputStream inputStream = this.in;
        synchronized (inputStream) {
            for (i = 0; i < len; ++i) {
                if (!this.refreshBuffer()) {
                    return i == 0 ? -1 : i;
                }
                buf[offset + i] = this.buffer[this.index++];
            }
        }
        return i;
    }

    private boolean refreshBuffer() throws IOException {
        if (this.buffer == null || this.index >= this.buffer.length) {
            int lastEndToken;
            byte[] tmp = new byte[8192];
            int size = this.is.read(tmp, 0, 8192);
            if (size == -1) {
                return false;
            }
            String tmpStr = new String(tmp, 0, size);
            int lastBeginToken = tmpStr.lastIndexOf(this.filter.getBeginToken());
            if (lastBeginToken != -1 && (lastEndToken = tmpStr.indexOf(this.filter.getEndToken(), lastBeginToken)) == -1) {
                String toPush = tmpStr.substring(lastBeginToken);
                tmpStr = tmpStr.substring(0, lastBeginToken);
                this.is.unread(toPush.getBytes());
            }
            String replaced = this.filter.replaceTokens(tmpStr);
            this.buffer = replaced.getBytes();
            this.index = 0;
        }
        return true;
    }
}

