/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.paramParser;

import java.util.ArrayList;
import java.util.List;
import org.hyperic.util.paramParser.FormatAtom;
import org.hyperic.util.paramParser.FormatException;
import org.hyperic.util.paramParser.LiteralAtom;

class ContainerAtom
extends FormatAtom {
    private boolean isORed = false;
    private ArrayList subAtoms = new ArrayList();
    private String blockName = null;

    ContainerAtom() {
    }

    void setBlockName(String blockName) {
        this.blockName = blockName;
    }

    String getBlockName() {
        return this.blockName;
    }

    void addSubAtom(FormatAtom subAtom) {
        this.subAtoms.add(subAtom);
        this.checkSubAtoms();
    }

    List getSubAtoms() {
        if (this.isORed) {
            ArrayList<FormatAtom> res = new ArrayList<FormatAtom>();
            for (FormatAtom subAtom : this.subAtoms) {
                if (this.atomIsOR(subAtom)) continue;
                res.add(subAtom);
            }
            return res;
        }
        return (List)this.subAtoms.clone();
    }

    boolean isORed() {
        return this.isORed;
    }

    private boolean atomIsOR(FormatAtom atom) {
        return atom instanceof LiteralAtom && ((LiteralAtom)atom).getLiteral().equals("|");
    }

    private void checkSubAtoms() {
        for (FormatAtom subAtom : this.getSubAtoms()) {
            if (!this.atomIsOR(subAtom)) continue;
            this.isORed = true;
        }
        if (!this.isORed) {
            return;
        }
        boolean lastWasOR = false;
        boolean sawOne = false;
        for (FormatAtom subAtom : this.subAtoms) {
            if (this.atomIsOR(subAtom)) {
                if (sawOne && lastWasOR) {
                    throw new FormatException("| must be seperated by an intervening atom");
                }
                lastWasOR = true;
            } else {
                if (sawOne && !lastWasOR) {
                    throw new FormatException("| must be placed between every atom in a '|' context");
                }
                lastWasOR = false;
            }
            sawOne = true;
        }
    }
}

