/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.config;

import java.util.concurrent.RejectedExecutionHandler;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.task.TaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.StringUtils;

public class TaskExecutorFactoryBean
implements FactoryBean<TaskExecutor>,
BeanNameAware,
InitializingBean,
DisposableBean {
    private String poolSize;
    private Integer queueCapacity;
    private RejectedExecutionHandler rejectedExecutionHandler;
    private Integer keepAliveSeconds;
    private String beanName;
    private ThreadPoolTaskExecutor target;

    public void setPoolSize(String poolSize) {
        this.poolSize = poolSize;
    }

    public void setQueueCapacity(int queueCapacity) {
        this.queueCapacity = queueCapacity;
    }

    public void setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
        this.rejectedExecutionHandler = rejectedExecutionHandler;
    }

    public void setKeepAliveSeconds(int keepAliveSeconds) {
        this.keepAliveSeconds = keepAliveSeconds;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void afterPropertiesSet() {
        this.target = new ThreadPoolTaskExecutor();
        this.determinePoolSizeRange();
        if (this.queueCapacity != null) {
            this.target.setQueueCapacity(this.queueCapacity);
        }
        if (this.keepAliveSeconds != null) {
            this.target.setKeepAliveSeconds(this.keepAliveSeconds);
        }
        if (this.rejectedExecutionHandler != null) {
            this.target.setRejectedExecutionHandler(this.rejectedExecutionHandler);
        }
        if (this.beanName != null) {
            this.target.setThreadNamePrefix(this.beanName + "-");
        }
        this.target.afterPropertiesSet();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void determinePoolSizeRange() {
        if (!StringUtils.hasText((String)this.poolSize)) return;
        try {
            int maxPoolSize;
            int corePoolSize;
            int separatorIndex = this.poolSize.indexOf(45);
            if (separatorIndex != -1) {
                corePoolSize = Integer.valueOf(this.poolSize.substring(0, separatorIndex));
                if (corePoolSize > (maxPoolSize = Integer.valueOf(this.poolSize.substring(separatorIndex + 1, this.poolSize.length())).intValue())) {
                    throw new IllegalArgumentException("Lower bound of pool-size range must not exceed the upper bound");
                }
                if (this.queueCapacity == null) {
                    if (corePoolSize != 0) throw new IllegalArgumentException("A non-zero lower bound for the size range requires a queue-capacity value");
                    this.target.setAllowCoreThreadTimeOut(true);
                    corePoolSize = maxPoolSize;
                }
            } else {
                Integer value = Integer.valueOf(this.poolSize);
                corePoolSize = value;
                maxPoolSize = value;
            }
            this.target.setCorePoolSize(corePoolSize);
            this.target.setMaxPoolSize(maxPoolSize);
            return;
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Invalid pool-size value [" + this.poolSize + "]: only single " + "maximum integer (e.g. \"5\") and minimum-maximum range (e.g. \"3-5\") are supported", ex);
        }
    }

    public TaskExecutor getObject() {
        return this.target;
    }

    public Class<? extends TaskExecutor> getObjectType() {
        return this.target != null ? this.target.getClass() : ThreadPoolTaskExecutor.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() {
        this.target.destroy();
    }
}

