/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ExpireMap
extends HashMap {
    @Override
    public Set entrySet() {
        Set entries = super.entrySet();
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Value value = (Value)entry.getValue();
            if (!value.hasExpired()) continue;
            it.remove();
        }
        return entries;
    }

    @Override
    public Object get(Object key) {
        Value value = (Value)super.get(key);
        if (value != null) {
            if (value.hasExpired()) {
                super.remove(key);
            } else {
                return value.getValue();
            }
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public Set keySet() {
        this.entrySet();
        return super.keySet();
    }

    @Override
    public Collection values() {
        Set entries = this.entrySet();
        ArrayList<Object> values = new ArrayList<Object>();
        for (Map.Entry entry : entries) {
            Value value = (Value)entry.getValue();
            values.add(value.getValue());
        }
        return values;
    }

    @Override
    public Object put(Object key, Object value) {
        return super.put(key, new Value(value));
    }

    public Object put(Object key, Object value, long expiration) {
        return super.put(key, new Value(value, expiration));
    }

    public static void main(String[] args) throws Exception {
        ExpireMap map = new ExpireMap();
        map.put("key", "object", 2000L);
        Thread.sleep(1000L);
        System.out.println("1 sec: Map contains key: " + map.containsKey("key"));
        Thread.sleep(1000L);
        System.out.println("2 sec: Map contains key: " + map.containsKey("key"));
        map.put("key", "object");
        Object obj = map.get("key");
        System.out.println("Objects are equal: " + obj.equals("object"));
    }

    public static ExpireMap getSynchronizedCache() {
        return (ExpireMap)Collections.synchronizedMap(new ExpireMap());
    }

    public class Value {
        private Object value;
        private long expiration;

        public Value(Object value) {
            this(value, 240000L);
        }

        public Value(Object value, long expiration) {
            this.value = value;
            this.expiration = System.currentTimeMillis() + expiration;
        }

        public boolean hasExpired() {
            return this.expiration < System.currentTimeMillis();
        }

        public long getExpiration() {
            return this.expiration;
        }

        public void setExpiration(long l) {
            this.expiration = l;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object object) {
            this.value = object;
        }
    }
}

