/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.bizapp.agent;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.bizapp.agent.TokenNotFoundException;
import org.hyperic.util.StringUtil;
import org.hyperic.util.exec.Os;
import org.hyperic.util.security.SecurityUtil;

public class PlatformToken {
    private static String PLATFORM_TOKEN_FILE_NAME = "epops-token";
    private static String DEFAULT_LINUX_FILE_PATH = "/etc/epops/" + PLATFORM_TOKEN_FILE_NAME;
    private static String DEFAULT_WINDOWS_FILE_PATH = "\\VMware\\EP Ops Agent\\" + PLATFORM_TOKEN_FILE_NAME;
    private static String TOKEN_FILE_ENCODING = "UTF-8";
    private static String DEFAULT_PATH_VALUE = "*default*";
    private static double defaultOsVersion = 6.1;
    private static double windows2003Version = 5.2;
    private static Log LOGGER = LogFactory.getLog(PlatformToken.class);
    private String platformToken = null;
    private boolean isCreatedInCurrentRun = false;

    public PlatformToken(String userDefinedLinuxPath, String userDefinedWindowsPath) throws TokenNotFoundException {
        String tokenPath = this.calculateTokenPathBasedOnOS(userDefinedLinuxPath, userDefinedWindowsPath);
        this.loadTokenFromFile(tokenPath);
    }

    private String calculateTokenPathBasedOnOS(String customLinuxPath, String customWindowsPath) {
        LOGGER.debug((Object)"Calculating platform token path");
        String calculatedTokenPath = null;
        String userDefinedPath = null;
        if (Os.isWindowsFamily()) {
            userDefinedPath = customWindowsPath;
            if (!StringUtil.isNullOrEmpty((String)userDefinedPath) && !DEFAULT_PATH_VALUE.equals(userDefinedPath)) {
                return userDefinedPath;
            }
            String systemDrive = System.getenv("SystemDrive");
            if (StringUtil.isNullOrEmpty((String)systemDrive)) {
                systemDrive = "C:";
            }
            LOGGER.debug((Object)("The system drive is " + systemDrive));
            String windowsDefaultFilePathPrefix = null;
            double osVersion = 0.0;
            try {
                osVersion = Double.parseDouble(Os.getVersion());
                LOGGER.debug((Object)("The OS version is " + osVersion));
            }
            catch (NumberFormatException ex) {
                LOGGER.error((Object)String.format("Could not parse OS version number %s. Using default %s", Os.getVersion(), defaultOsVersion));
                osVersion = defaultOsVersion;
            }
            if (osVersion <= windows2003Version) {
                windowsDefaultFilePathPrefix = System.getenv("ALLUSERSPROFILE");
                if (StringUtil.isNullOrEmpty((String)windowsDefaultFilePathPrefix)) {
                    windowsDefaultFilePathPrefix = systemDrive + "\\Documents and Settings\\All Users\\Application Data";
                }
            } else {
                windowsDefaultFilePathPrefix = System.getenv("PROGRAMDATA");
                if (StringUtil.isNullOrEmpty((String)windowsDefaultFilePathPrefix)) {
                    windowsDefaultFilePathPrefix = systemDrive + "\\ProgramData";
                }
            }
            calculatedTokenPath = windowsDefaultFilePathPrefix + DEFAULT_WINDOWS_FILE_PATH;
        } else {
            userDefinedPath = customLinuxPath;
            if (!StringUtil.isNullOrEmpty((String)userDefinedPath) && !DEFAULT_PATH_VALUE.equals(userDefinedPath)) {
                return userDefinedPath;
            }
            calculatedTokenPath = DEFAULT_LINUX_FILE_PATH;
        }
        LOGGER.debug((Object)("Calculated token path is " + calculatedTokenPath));
        return calculatedTokenPath;
    }

    private void loadTokenFromFile(String filePath) throws TokenNotFoundException {
        LOGGER.info((Object)("Loading the platform token from " + filePath));
        if (StringUtil.isNullOrEmpty((String)filePath)) {
            throw new TokenNotFoundException("The token file path is undefined");
        }
        File platfromTokenFile = new File(filePath);
        try {
            if (!platfromTokenFile.exists()) {
                String newPlatfromToken = SecurityUtil.generateRandomToken();
                FileUtils.writeStringToFile((File)platfromTokenFile, (String)newPlatfromToken, (String)TOKEN_FILE_ENCODING);
                LOGGER.info((Object)String.format("The platform token file was not found in %s, because file does not exist. A new platform token %s has been created and stored in that location.", filePath, newPlatfromToken));
                this.isCreatedInCurrentRun = true;
            }
            this.platformToken = FileUtils.readFileToString((File)platfromTokenFile, (String)TOKEN_FILE_ENCODING).trim();
            SecurityUtil.validateToken((String)this.platformToken);
            LOGGER.info((Object)("Current platform token is " + this.platformToken));
        }
        catch (SecurityException tokenValidationException) {
            throw new TokenNotFoundException("The agent encountered an error when reading the token from the file at " + filePath + ": " + tokenValidationException.getMessage());
        }
        catch (IOException ex) {
            throw new TokenNotFoundException("The agent encountered an error when accessing the token file at " + filePath + ": " + ex.getMessage());
        }
    }

    public String getValue() {
        return this.platformToken;
    }

    public boolean wasTokenGeneratedByCurrentRun() {
        return this.isCreatedInCurrentRun;
    }
}

