/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.CollectorIdentifier;
import org.hyperic.hq.product.CollectorResult;
import org.hyperic.hq.product.ExecutableProcess;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.MeasurementPlugin;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.MetricNotFoundException;
import org.hyperic.hq.product.MetricUnreachableException;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PluginException;
import org.hyperic.util.PluginLoader;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.ConfigSchema;

public abstract class Collector
implements Runnable {
    public static final String PROP_HOSTNAME = "hostname";
    public static final String PROP_PORT = "port";
    public static final String PROP_PROTOCOL = "protocol";
    public static final String PROP_PATH = "path";
    public static final String PROP_SSL = "ssl";
    public static final String PROP_SSL_PROTOCOL = "sslprotocol";
    public static final String PROP_USERNAME = "user";
    public static final String PROP_PASSWORD = "pass";
    public static final String PROP_REALM = "realm";
    public static final String PROP_FOLLOW = "follow";
    public static final String PROP_METHOD = "method";
    public static final String PROP_SSLPORT = "sslport";
    public static final String METHOD_HEAD = "HEAD";
    public static final String METHOD_GET = "GET";
    public static final String PROTOCOL_HTTP = "http";
    public static final String PROTOCOL_HTTPS = "https";
    public static final String PROTOCOL_FTP = "ftp";
    public static final String PROTOCOL_SOCKET = "socket";
    public static final String DEFAULT_HOSTNAME = "localhost";
    public static final String DEFAULT_FTP_PORT = "21";
    public static final String DEFAULT_HTTP_PORT = "80";
    public static final String DEFAULT_HTTPS_PORT = "443";
    public static final String PROP_TIMEOUT = "timeout";
    public static final String ATTR_RESPONSE_TIME = "ResponseTime";
    public static final String ATTR_RESPONSE_CODE = "ResponseCode";
    public static final String LISTEN_PORTS = "listen.ports";
    public static final String GUID = "GUID";
    public static final String MAC = "Mac";
    static Log log = LogFactory.getLog((String)Collector.class.getName());
    static Map containers = new HashMap();
    private GenericPlugin plugin;
    private Properties props;
    private boolean isRunning = false;
    private int timeout = -1;
    private long startTime;
    private long endTime;
    private Metric intervalMetric;
    private long lastCollection = -1L;
    private static Map compatAliases = new HashMap();
    CollectorResult result = new CollectorResult();
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;
    public static final String REMOVABLE = "removable";
    public static final String ALLOW_REMOVE = "allow_remove";

    protected void init() throws PluginException {
        this.setSource(this.getPlugin().getName());
    }

    public abstract void collect();

    public void init(GenericPlugin plugin, ConfigResponse config) throws PluginException {
        this.plugin = plugin;
        this.setProperties(config.toProperties());
        this.init();
    }

    public Map getValues(GenericPlugin plugin, ConfigResponse config) throws PluginException {
        this.init(plugin, config);
        this.collect();
        return this.getResult().values;
    }

    public int getTimeout() {
        if (this.timeout == -1) {
            this.timeout = this.getIntegerProperty(this.getPropTimeout(), this.getDefaultTimeout());
        }
        return this.timeout;
    }

    public int getTimeoutMillis() {
        return this.getTimeout() * 1000;
    }

    protected int getDefaultTimeout() {
        return 30;
    }

    protected String getPropTimeout() {
        return PROP_TIMEOUT;
    }

    protected int getIntegerProperty(String key, int defVal) {
        String val = this.getProperties().getProperty(key);
        if (val == null) {
            if (defVal == -1) {
                String msg = "Missing " + key + " property";
                throw new IllegalArgumentException(msg);
            }
            return defVal;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            String msg = "Invalid value (" + val + ")" + " for " + key;
            throw new IllegalArgumentException(msg);
        }
    }

    protected String getCollectorProperty(String key, String defVal) {
        return this.props.getProperty(key, defVal);
    }

    static Object getCompatValue(Map map, String key) {
        Object val = map.get(key);
        if (val == null) {
            Object alias = compatAliases.get(key);
            if (alias == null) {
                alias = key.toLowerCase();
            }
            if (alias != null) {
                val = map.get(alias);
            }
        }
        return val;
    }

    protected String getCollectorProperty(String key) {
        return (String)Collector.getCompatValue(this.props, key);
    }

    protected void setProperties(Properties props) {
        this.props = props;
    }

    protected Properties getProperties() {
        return this.props;
    }

    protected GenericPlugin getPlugin() {
        return this.plugin;
    }

    protected void setSource(String value) {
        this.result.source = value;
    }

    protected String getSource() {
        return this.result.source;
    }

    protected void setLogLevel(int value) {
        this.result.level = value;
    }

    protected int getLogLevel() {
        return this.result.level;
    }

    protected void setMessage(String value) {
        this.result.message = value;
    }

    protected String getMessage() {
        return this.result.message;
    }

    private String composeMessage(String msg, Throwable t) {
        return msg + ": " + t.getMessage();
    }

    protected void setMessage(String msg, Throwable t) {
        this.setMessage(this.composeMessage(msg, t));
    }

    protected void setErrorMessage(String msg) {
        this.setLogLevel(3);
        this.setMessage(msg);
    }

    protected void setWarningMessage(String msg) {
        this.setLogLevel(4);
        this.setMessage(msg);
    }

    protected void setInfoMessage(String msg) {
        this.setLogLevel(6);
        this.setMessage(msg);
    }

    protected void setDebugMessage(String msg) {
        this.setLogLevel(7);
        this.setMessage(msg);
    }

    protected void setErrorMessage(String msg, Throwable t) {
        this.setErrorMessage(this.composeMessage(msg, t));
    }

    protected void setWarningMessage(String msg, Throwable t) {
        this.setWarningMessage(this.composeMessage(msg, t));
    }

    protected void setInfoMessage(String msg, Throwable t) {
        this.setInfoMessage(this.composeMessage(msg, t));
    }

    protected void setDebugMessage(String msg, Throwable t) {
        this.setDebugMessage(this.composeMessage(msg, t));
    }

    protected void setValue(String key, String val) {
        this.result.setValue(key, val);
    }

    protected void addValues(Map values) {
        this.result.addValues(values);
    }

    protected CollectorResult getResult() {
        return this.result;
    }

    protected void setValue(String key, double val) {
        this.result.setValue(key, val);
    }

    protected void setAvailability(double val) {
        this.setValue("Availability", val);
    }

    protected void setAvailability(boolean val) {
        this.setAvailability(val ? 100.0 : 0.0);
    }

    protected void setResponseCode(int code) {
        this.setValue(ATTR_RESPONSE_CODE, code);
    }

    protected void setResponseTime(double value) {
        this.setValue(ATTR_RESPONSE_TIME, value);
    }

    protected void startTime() {
        this.startTime = System.currentTimeMillis();
    }

    protected void endTime() {
        this.endTime = System.currentTimeMillis();
    }

    String mapToString(Map map) {
        HashMap<String, String> props = new HashMap<String, String>();
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            String val = (String)entry.getValue();
            String secured = ConfigSchema.isSecret((String)key) || ConfigSchema.isSensitive((String)key) ? "******" : val;
            props.put(key, secured);
        }
        return ((Object)props).toString();
    }

    public String toString() {
        return this.mapToString(this.props);
    }

    public MetricValue getValue(Metric metric, CollectorResult result) {
        return result.getMetricValue(metric.getAttributeName());
    }

    private long getInterval() {
        if (this.intervalMetric == null) {
            return -1L;
        }
        return this.intervalMetric.getInterval();
    }

    private void setInterval(Metric metric) {
        this.intervalMetric = metric;
    }

    protected void setInterval(MeasurementPlugin plugin, Metric metric) {
        if (!this.isPoolable()) {
            return;
        }
        long itv = metric.getInterval();
        boolean isAvail = metric.getAttributeName().equals("Availability");
        if ((isAvail || this.getInterval() == -1L) && itv > 0L && this.getInterval() != itv) {
            this.setInterval(metric);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Set itv=" + this.getInterval() / 60000L + "min for " + plugin.getName() + " collector: " + this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MetricValue getValue(MeasurementPlugin plugin, Metric metric) throws PluginException, MetricNotFoundException, MetricUnreachableException {
        Properties props = plugin.getCollectorProperties(metric);
        PluginContainer container = PluginContainer.get(plugin);
        CollectorIdentifier collectorIdentifier = new CollectorIdentifier(props);
        Collector collector = container.collectors.get(collectorIdentifier);
        CollectorResult result = container.results.get(collectorIdentifier);
        if (result != null) {
            MetricValue value;
            boolean isAvail = metric.getAttributeName().equals("Availability");
            result.collected = true;
            if (!result.reported && result.level != -1) {
                plugin.getManager().reportEvent(metric, result.getTimeStamp(), result.getLevel(), result.getSource(), result.getMessage());
                result.reported = true;
            }
            boolean setClassLoader = PluginLoader.setClassLoader((Object)collector);
            try {
                value = collector.getValue(metric, result);
                if (isAvail) {
                    collector.lastCollection = value.getTimestamp();
                }
            }
            finally {
                collector.setInterval(plugin, metric);
                if (setClassLoader) {
                    PluginLoader.resetClassLoader((Object)collector);
                }
            }
            if (value == null) {
                throw new MetricNotFoundException(metric.toString());
            }
            return value;
        }
        if (collector == null) {
            collector = plugin.getNewCollector();
            collector.plugin = plugin;
            boolean setClassLoader = PluginLoader.setClassLoader((Object)collector);
            try {
                collector.setProperties(props);
                collector.init();
                collector.setInterval(plugin, metric);
            }
            finally {
                if (setClassLoader) {
                    PluginLoader.resetClassLoader((Object)collector);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Adding " + plugin.getName() + " collector: " + collector));
            }
            container.collectors.put(collectorIdentifier, collector);
        }
        return MetricValue.FUTURE;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Collector)) {
            return false;
        }
        return ((Collector)obj).props.equals(this.props);
    }

    public int hashCode() {
        return this.props.hashCode();
    }

    public boolean isPoolable() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.isRunning = true;
        this.result.values.clear();
        this.result.level = -1;
        this.endTime = -1L;
        this.startTime = -1L;
        boolean setClassLoader = PluginLoader.setClassLoader((Object)this);
        try {
            this.collect();
        }
        catch (Throwable t) {
            log.error((Object)("Error running " + this.plugin.getName() + " collector: " + t), t);
            this.setErrorMessage("Error: " + t.getMessage(), t);
            this.setAvailability(false);
        }
        finally {
            if (setClassLoader) {
                PluginLoader.resetClassLoader((Object)this);
            }
        }
        if (this.endTime != -1L) {
            this.result.timestamp = this.endTime;
            this.setResponseTime(this.endTime - this.startTime);
        } else {
            this.result.timestamp = System.currentTimeMillis();
        }
        PluginContainer.setResult(this);
        this.isRunning = false;
    }

    protected void parseResults(String message) {
        boolean hasResultValue = false;
        StringTokenizer st = new StringTokenizer(message, "\r\n,");
        while (st.hasMoreTokens()) {
            String attr = st.nextToken();
            int ix = attr.indexOf(61);
            if (ix == -1) {
                if (hasResultValue) continue;
                StringTokenizer st2 = new StringTokenizer(attr, " \t");
                while (st2.hasMoreTokens()) {
                    String s = st2.nextToken();
                    if (!Character.isDigit(s.charAt(0)) || !Character.isDigit(s.charAt(s.length() - 1))) continue;
                    this.setValue("ResultValue", s);
                    hasResultValue = true;
                }
                continue;
            }
            String key = attr.substring(0, ix);
            String val = attr.substring(key.length() + 1);
            if (key.equals("Message")) {
                this.setMessage(val);
                continue;
            }
            this.setValue(key, val);
        }
    }

    private static String lastRun(long now, long time) {
        long delta = now - time;
        if (delta / 60000L < 1L) {
            long seconds = delta / 1000L;
            return seconds + " seconds ago";
        }
        if (delta / 3600000L < 1L) {
            long minutes = delta / 60000L;
            return minutes + " minutes ago";
        }
        if (delta / 86400000L < 1L) {
            long hours = delta / 3600000L;
            return hours + " hours ago";
        }
        return "on " + new Date(time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<Collector> getCollectorsToExecute(PluginContainer container) {
        ArrayList<Collector> pluginCollectors;
        boolean debug = log.isDebugEnabled();
        ArrayList<Collector> rtn = new ArrayList<Collector>();
        if (debug) {
            log.debug((Object)("Running " + container.name + " collectors"));
        }
        Map<CollectorIdentifier, Collector> map = container.collectors;
        synchronized (map) {
            Collection<Collector> values = container.collectors.values();
            pluginCollectors = new ArrayList<Collector>(values.size());
            pluginCollectors.addAll(values);
        }
        for (int i = 0; i < pluginCollectors.size(); ++i) {
            Collector collector = (Collector)pluginCollectors.get(i);
            long interval = collector.getInterval();
            long lastCollection = collector.lastCollection;
            if (collector.isRunning) {
                if (!debug) continue;
                log.debug((Object)(collector + " is running: deferring"));
                continue;
            }
            CollectorResult result = container.results.get(new CollectorIdentifier(collector.props));
            if (result != null && result.values.size() != 0) {
                long now = System.currentTimeMillis();
                boolean shouldSkip = true;
                if (interval != -1L && lastCollection != -1L) {
                    if (now - lastCollection >= interval - 60000L) {
                        shouldSkip = false;
                    } else if (now - result.timestamp >= interval) {
                        shouldSkip = false;
                    }
                } else {
                    shouldSkip = !result.collected;
                }
                String msg = null;
                if (debug) {
                    String itv = interval == -1L ? "unknown" : interval / 60000L + "min";
                    String coll = lastCollection == -1L ? "n/a" : Collector.lastRun(now, lastCollection);
                    msg = collector + " ran " + Collector.lastRun(now, result.timestamp) + "," + " consumed " + coll + ", " + itv + " itv: ";
                }
                if (shouldSkip) {
                    if (!debug) continue;
                    log.debug((Object)(msg + "deferring."));
                    continue;
                }
                if (debug) {
                    log.debug((Object)(msg + "collecting."));
                }
            }
            rtn.add(collector);
        }
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Collector> getCollectorsToExecute() {
        ArrayList pluginContainers;
        ArrayList<Collector> rtn = new ArrayList<Collector>();
        Map map = containers;
        synchronized (map) {
            Collection values = containers.values();
            pluginContainers = new ArrayList(values.size());
            pluginContainers.addAll(values);
        }
        for (int i = 0; i < pluginContainers.size(); ++i) {
            PluginContainer container = (PluginContainer)pluginContainers.get(i);
            rtn.addAll(Collector.getCollectorsToExecute(container));
        }
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshOnPluginsChange() {
        Map map = containers;
        synchronized (map) {
            containers.clear();
        }
    }

    public static void main(String[] args) throws Exception {
        ExecutableProcess collector = new ExecutableProcess();
        collector.setProperties(System.getProperties());
        ((Collector)collector).init();
        collector.run();
        System.out.println(collector);
    }

    static {
        String[][] aliases = new String[][]{{"RequestTime", ATTR_RESPONSE_TIME}, {"ExecTime", ATTR_RESPONSE_TIME}, {"ReturnCode", ATTR_RESPONSE_CODE}, {"Arg", "file"}, {"prefix", "exec"}, {"Params", "args"}, {"availability", "Availability"}};
        for (int i = 0; i < aliases.length; ++i) {
            compatAliases.put(aliases[i][0], aliases[i][1]);
        }
    }

    static class PluginContainer {
        String name;
        Map<CollectorIdentifier, Collector> collectors = Collections.synchronizedMap(new HashMap());
        Map<CollectorIdentifier, CollectorResult> results = Collections.synchronizedMap(new HashMap());

        PluginContainer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static PluginContainer get(GenericPlugin plugin) {
            String name = plugin.getName();
            Map map = containers;
            synchronized (map) {
                PluginContainer container = (PluginContainer)containers.get(name);
                if (container == null) {
                    container = new PluginContainer();
                    container.name = name;
                    containers.put(name, container);
                }
                return container;
            }
        }

        static void setResult(Collector collector) {
            CollectorResult result = new CollectorResult(collector);
            if (log.isDebugEnabled()) {
                log.debug((Object)("name=" + collector.plugin.getName() + ", " + "thread=" + Thread.currentThread().getName() + ", result=" + result));
            }
            PluginContainer.get((GenericPlugin)((Collector)collector).plugin).results.put(new CollectorIdentifier(collector.props), result);
        }
    }
}

