/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product.pluginxml;

import java.util.Collection;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.MeasurementInfo;
import org.hyperic.hq.product.pluginxml.BaseTag;
import org.hyperic.hq.product.pluginxml.ContainerTag;
import org.hyperic.hq.product.pluginxml.MetricTag;
import org.hyperic.hq.product.pluginxml.PluginData;
import org.hyperic.hq.product.pluginxml.ResourceTag;
import org.hyperic.util.xmlparser.XmlAttrException;
import org.hyperic.util.xmlparser.XmlEndAttrHandler;
import org.hyperic.util.xmlparser.XmlTagHandler;
import org.hyperic.util.xmlparser.XmlTagInfo;

class MetricsTag
extends ContainerTag
implements XmlEndAttrHandler {
    private static final String[] OPTIONAL_ATTRS = new String[]{"name", "include"};
    private static final Log log = LogFactory.getLog(MetricsTag.class);
    protected String metricsName;

    public MetricsTag(BaseTag parent) {
        super(parent);
    }

    @Override
    public String getName() {
        return "metrics";
    }

    @Override
    public String[] getOptionalAttributes() {
        return OPTIONAL_ATTRS;
    }

    @Override
    public XmlTagInfo[] getSubTags() {
        return this.getMergedSubTags(super.getSubTags(), new XmlTagInfo((XmlTagHandler)new MetricTag(this), 3));
    }

    public void endAttributes() throws XmlAttrException {
        if (!this.collectMetrics) {
            return;
        }
        String name = this.getAttribute("name");
        if (this.isResourceParent()) {
            if (name != null) {
                String msg = "metrics 'name' attribute not allowed when nested in a " + this.parent.getName() + " tag";
                throw new XmlAttrException(msg);
            }
            this.metricsName = ((ResourceTag)this.parent).typeName;
        } else {
            if (name == null) {
                throw new XmlAttrException("missing metrics 'name' attribute");
            }
            this.metricsName = name;
        }
        MetricsTag.includeMetrics(this.data, this.metricsName, this.getAttribute("include"), false);
    }

    @Override
    public void endTag() {
        if (!this.collectMetrics) {
            return;
        }
        for (Object include1 : this.includes) {
            String include = (String)include1;
            MetricsTag.includeMetrics(this.data, this.metricsName, include, true);
        }
    }

    protected static void includeMetrics(PluginData data, String name, String namesToInclude, boolean overrideMetrics) {
        if (namesToInclude != null) {
            StringTokenizer tok = new StringTokenizer(namesToInclude, ",");
            while (tok.hasMoreTokens()) {
                String nameToInclude = tok.nextToken();
                Collection<MeasurementInfo> metricsToInclude = data.getMetrics(nameToInclude);
                if (metricsToInclude == null) {
                    log.warn((Object)(name + " include not found: " + nameToInclude));
                    continue;
                }
                log.trace((Object)(metricsToInclude.size() + " metrics added for " + name + " (included from " + nameToInclude + ")"));
                for (MeasurementInfo metricToInclude : metricsToInclude) {
                    MeasurementInfo newMetric = (MeasurementInfo)metricToInclude.clone();
                    newMetric.setTemplate(data.applyFilters(metricToInclude.getTemplate()));
                    data.addMetric(name, metricToInclude, overrideMetrics);
                }
            }
        }
    }
}

