alter table "VcServer" add column "fullName" varchar(128);
update "VcServer" set "fullName" = '' where "fullName" is null;
alter table "VcServer" alter column "fullName" set not null;

alter table "Host" add column "fullName" varchar(128);
update "Host" set "fullName" = '' where "fullName" is null;
alter table "Host" alter column "fullName" set not null;

alter table "VcServer" add column "version" varchar(128);
update "VcServer" set "version" = '' where "version" is null;
alter table "VcServer" alter column "version" set not null;

alter table "Host" add column "version" varchar(128);
update "Host" set "version" = '' where "version" is null;
alter table "Host" alter column "version" set not null;

alter table "Vm" add column "discovered" timestamp not null default '2000-01-01';
alter table "Vm" alter column "discovered" drop default;

create table "HostMonth" (
    "id" integer primary key not null,
    "hostId" integer not null,
    "year" integer not null,
    "month" integer not null
  );
create sequence "s_HostMonth_id";
alter table "HostMonth" add constraint "HostMonthFK2" foreign key ("hostId") references "Host"("id");

create table "VmMonth" (
    "id" integer primary key not null,
    "vmId" integer not null,
    "year" integer not null,
    "month" integer not null
  );
create sequence "s_VmMonth_id";
alter table "VmMonth" add constraint "VmMonthFK16" foreign key ("vmId") references "Vm"("id");
create unique index "idx675c08b8" on "VmMonth" ("vmId","year","month");

create view "MonthlyNewVmCount" as
    select vmm.year, vmm.month, vm.id as "vmId" from "VmMonth" vmm, "Vm" vm where vmm."vmId" = vm.id
    and vmm.year = extract(year from vm.discovered)
    and vmm.month = extract(month from vm.discovered);

create table "VmSizesMonth" (
    "id" integer primary key not null,
    "year" integer not null,
    "month" integer not null
  );
create sequence "s_VmSizesMonth_id";
create table "VmSizeBinMonth" (
    "id" integer primary key not null,
    "vmSizesMonthId" integer not null,
    "bin" integer not null,
    "count" integer not null
  );
create sequence "s_VmSizeBinMonth_id";

create unique index "idx6bf70909" on "VmSizesMonth" ("year","month");
create unique index "idxd8de0cb5" on "VmSizeBinMonth" ("vmSizesMonthId","bin");

create table "CustomerRamMonth" (
    "id" integer primary key not null,
    "customerId" integer not null,
    "year" integer not null,
    "month" integer not null,
    "mbHours" bigint not null
  );
create sequence "s_CustomerRamMonth_id";
-- indexes on CustomerRamMonth
create index "idx97380ac5" on "CustomerRamMonth" ("customerId");

alter table "CustomerRamMonth" add constraint "CustomerRamMonthFK2" foreign key ("customerId") references "Customer"("id");

create unique index "idx259f0ef6" on "CustomerRamMonth" ("customerId","year","month");
create unique index "idx91b40a6e" on "HostMonth" ("hostId","year","month");

create function ym(int, int) returns int as
    'select $1 * 100 + $2'
    language SQL
    immutable;

create view "VcopsMonth" as
    select c.start, extract(year from c.start) as year, extract(month from c.start) as month,
    s."vmMemSize", s."vmBillingMemory"
    from "Collection" c, "VcopsVmCollection" v, "Sample" s
    where c.id = v."collectionId" and c.id = s."collectionId" and v."vmId" = s."vmId";

create function year(timestamp) returns int as
    'select extract(year from $1) :: int'
    language SQL
    immutable;

create function month(timestamp) returns int as
    'select extract(month from $1) :: int'
    language SQL
    immutable;
