alter table "LdapServer" alter column "dn" type varchar(256);
alter table "LdapServer" alter column "baseDn" type varchar(256);

create table "VcdServerCustomer" (
    "vcdServerId" integer not null,
    "customerId" integer not null,
    "vdcId" varchar(128) not null
  );
alter table "VcdServerCustomer" add primary key ("vcdServerId","customerId");
alter table "VcdServerCustomer" add constraint "VcdServerCustomerFK7" foreign key ("vcdServerId") references "VcdServer"("id");
alter table "VcdServerCustomer" add constraint "VcdServerCustomerFK8" foreign key ("customerId") references "Customer"("id");

alter table "VcdServer" drop column "uuid";
create unique index "VcdServer_host_port" on "VcdServer" ("host","port");

delete from "ZimbraSample";
alter table "ZimbraSample" add column "zimbraEditionId" integer not null;

alter table "ZimbraServer" add column "variant" integer not null default(1);
alter table "ZimbraServer" alter column "variant" drop default;
alter table "ZimbraServer" drop column "port";

create table "ZimbraEdition" (
    "id" integer primary key not null,
    "name" varchar(128) not null
  );
create sequence "s_ZimbraEdition_id";
-- indexes on ZimbraEdition
create unique index "zimbraEditionName" on "ZimbraEdition" ("name");

alter table "ZimbraSample" add constraint "ZimbraSampleFK29" foreign key ("zimbraEditionId") references "ZimbraEdition"("id");

alter table "VcopsServer" add column "active" boolean not null default(true);
alter table "VcopsServer" alter column "active" drop default;

create unique index "VcopsServerHost" on "VcopsServer" ("host");

create table "VmHistory" (
    "id" integer primary key not null,
    "vmId" integer not null,
    "time" timestamp not null,
    "nextTime" timestamp not null,
    "vmMemSize" integer not null,
    "guestFullName" varchar(128),
    "cpuCount" integer not null,
    "nicCount" integer not null,
    "tags" varchar(10000) not null,
    "annotation" varchar(10000) not null
  );
create sequence "s_VmHistory_id";

alter table "VmHistory" add constraint "VmHistoryFK15" foreign key ("vmId") references "Vm"("id");

create view "VmLatestHistoryId" as
    select id from "VmHistory" a where exists(
        select * from (
            select distinct "vmId", max(time) over (partition by "vmId") latest from "VmHistory"
        ) b where a.time = b.latest and a."vmId" = b."vmId"
    );

alter table "Vm" drop column "guestFullName";
alter table "Vm" drop column "cpuCount";
alter table "Vm" drop column "nicCount";

create table "VmEvent" (
    "id" integer primary key not null,
    "vmId" integer not null,
    "time" timestamp not null,
    "eventType" integer not null
  );
create sequence "s_VmEvent_id";
alter table "VmEvent" add constraint "VmEventFK14" foreign key ("vmId") references "Vm"("id");
create unique index "VmEvent_vmId_eventType_time" on "VmEvent" ("vmId","eventType","time");

alter table "VcServer" add column "monitor" boolean not null default false;
alter table "VcServer" alter column "monitor" drop default;

create table "HorizonSample" (
    "id" integer primary key not null,
    "zimbraServerId" integer not null,
    "sampleTime" timestamp not null,
    "usage" bigint not null
  );
create sequence "s_HorizonSample_id";
alter table "HorizonSample" add constraint "HorizonSampleFK31" foreign key ("zimbraServerId") references "ZimbraServer"("id");
