-- This script is to prepare the schema for migration from UM 3.3.3 to UM 3.5.0

--Mark migration started
UPDATE "SchemaInfo" SET version = 15, "migrationDone" = false;

--Clean up views, tables and sequences

DROP VIEW IF EXISTS "HostLatest";
DROP VIEW IF EXISTS "LicenseHostCount";
DROP VIEW IF EXISTS "HostLatestHistory";
DROP VIEW IF EXISTS "SampleToLicense";
DROP VIEW IF EXISTS "VcopsMonth";
DROP VIEW IF EXISTS "VmLatestHistoryId";

DROP TABLE IF EXISTS "HorizonSample";
DROP TABLE IF EXISTS "Sample";
DROP TABLE IF EXISTS "VcimServer";
DROP TABLE IF EXISTS "VmEvent";
DROP TABLE IF EXISTS "ZimbraEdition";
DROP TABLE IF EXISTS "ZimbraServer";
DROP TABLE IF EXISTS "ZimbraSample";

DROP SEQUENCE IF EXISTS "s_AggSample_id";
DROP SEQUENCE IF EXISTS "s_HorizonSample_id";
DROP SEQUENCE IF EXISTS "s_HostMonth_id";
DROP SEQUENCE IF EXISTS "s_ProtectedVmMonth_id";
DROP SEQUENCE if exists "s_Sample_id";
DROP SEQUENCE IF EXISTS "s_SrmServer_id";
DROP SEQUENCE IF EXISTS "s_VcimServer_id";
DROP SEQUENCE IF EXISTS "s_VmMonth_id";
DROP SEQUENCE IF EXISTS "s_VmEvent_id";
DROP SEQUENCE IF EXISTS "s_ZimbraEdition_id";
DROP SEQUENCE IF EXISTS "s_ZimbraSample_id";
DROP SEQUENCE IF EXISTS "s_ZimbraServer_id";

-- Following is to bring the schema to UM 3.4 level, but without indexes and constraints.

-- DesktoneServer
create table "DesktoneServer" (
    "id" integer not null,
    "active" boolean not null,
    "host" varchar(128) not null,
    "userName" varchar(128) not null,
    "password" varchar(128) not null,
    "changed" timestamp not null
  );
create sequence "s_DesktoneServer_id";

create table "DesktoneMonth" (
    "id" integer not null,
    "desktoneServerId" integer not null,
    "year" integer not null,
    "month" integer not null,
    "desktopQuota" integer not null,
	"sessionQuota" integer not null
  );
create sequence "s_DesktoneMonth_id";

alter table "VmHistory" add column "vmMemRes" integer not null default(0);
alter table "VmHistory" add column "powerState" integer not null default(1);
alter table "VmHistory" add column "vsanKBytes" bigint not null default 0;
alter table "VmHistory" alter column "vsanKBytes" drop default;
alter table "VmHistory" drop column "nicCount";

alter table "Vm" drop column "hostId";

alter table "VcServer" drop column "monitor";

alter table "HostHistory" add column nsx boolean not null default false;
alter table "HostHistory" alter column nsx drop default;
alter table "HostHistory" rename column "dnsName" to "name";

--alter table "HostLatest" rename column "dnsName" to name;

alter table "LicenseSet" add column
  "addNewHere" boolean not null default(false);

alter table "User" add column
  "username" varchar(100) not null default('admin');
alter table "User" alter column "username" drop default;

alter table "Customer" add column
  "providerId" integer not null default(1);
alter table "Customer" alter column "providerId" drop default;

drop table "VcopsVmCollection";
create table "VcopsVmCollection" (
    "id" integer not null,
    "vmId" integer not null,
    "timestamp" timestamp not null,
    "vcopsLicenseNameId" integer not null
  );

alter table "VcServer" add column port integer not null default 443;
alter table "VcServer" alter column port drop default;

alter table "CollectionSettings" drop column "intervalMinutes";

create table "ReportSettings" (
    "id" integer not null,
    "perVmMemCapMb" integer not null,
    "vcopsInPremierPlus" boolean not null
  );
insert into "ReportSettings" values(1, 24 * 1024, true);

alter table "Vm" drop column discovered;

create table "VcSrm" (
    "id" integer not null,
    "vcServerId" integer not null,
    "srmHostname" varchar(128) not null
  );
create sequence "s_VcSrm_id";

alter table "VcdServerCustomer" drop column "vdcId";

create table "VcdVdcInfo" (
    "id" integer not null,
    "vcdServerId" integer not null,
    "time" timestamp not null,
    "orgName" varchar(128) not null,
    "orgId" varchar(128) not null,
    "vdcName" varchar(128) not null,
    "vdcId" varchar(128) not null,
    "numVapps" integer not null,
    "numVms" integer not null
  );
create sequence "s_VcdVdcInfo_id";

alter table "Collection" drop column "vcServerId";
alter table "Collection" drop column "ok";
alter table "Collection" add column "errors" varchar(10000);

create table "Bundle" (
    "id" integer not null,
    "name" varchar(128) not null,
    "points" integer not null
  );
create table "Product" (
    "id" integer not null,
    "name" varchar(128) not null,
    "separable" boolean not null
  );
create table "ProductInBundle" (
    "bundleId" integer not null,
    "productId" integer not null
  );
create table "SeparateProduct" (
    "productId" integer not null
  );

alter table "VcopsServer" add column "licenseNameId" integer not null default(1);
alter table "VcopsServer" alter column "licenseNameId" drop default;

create table "NsxServer" (
    "id" integer not null,
    "active" boolean not null,
    "vcServerId" integer not null,
    "host" varchar(128) not null,
    "version" varchar(128) not null,
    "userName" varchar(128) not null,
    "password" varchar(128) not null,
    "changed" timestamp not null
  );
create sequence "s_NsxServer_id";

create table "VcopsLicenseName" (
    "id" integer not null,
    "name" varchar(128) not null
  );
create sequence "s_VcopsLicenseName_id";

insert into "VcopsLicenseName" values(nextval('"s_VcopsLicenseName_id"'), 'Not yet discovered'); -- Must be ID 1

update "LicenseCategory" set name = 'vCAN' where name = 'VSPP';

