-- This script is to migrate vPostgre database schema to UM 3.5.0 from UM 3.3.3 or UM 3.4.0 after they are prepared.

--Remove duplicates from "VcServer"
DELETE FROM "VcServer" WHERE "id" IN
 (SELECT "id" FROM (SELECT "id",ROW_NUMBER() OVER (partition BY "instanceUuid" ORDER BY "active" DESC, "changed" DESC) AS rnum
  FROM "VcServer") t
WHERE t.rnum > 1);
-- Remove invalid entry from ReportSetLicenseSet
DELETE FROM "ReportSetLicenseSet" WHERE "licenseSetId" NOT IN (SELECT "id" FROM "LicenseSet");
DELETE FROM "ReportSetLicenseSet" WHERE "reportSetId" NOT IN (SELECT "id" FROM "ReportSet");

ALTER TABLE "Provider" ALTER COLUMN "partnerId" DROP DEFAULT;
ALTER TABLE "Provider" ALTER COLUMN "contractNum" DROP DEFAULT;
ALTER TABLE "Provider" ALTER COLUMN "siteId" DROP DEFAULT;
ALTER TABLE "Provider" ALTER COLUMN "portalUserName" DROP DEFAULT;
ALTER TABLE "Provider" ALTER COLUMN "portalPassword" DROP DEFAULT;

ALTER TABLE "ReportSet" ADD COLUMN "toVsppPortal_1" boolean not null default(false);
UPDATE "ReportSet" SET "toVsppPortal_1" = "toVsppPortal";
ALTER TABLE "ReportSet" DROP COLUMN "toVsppPortal";
ALTER TABLE "ReportSet" RENAME COLUMN "toVsppPortal_1" TO "toVsppPortal";

ALTER TABLE "ReportSet" ADD COLUMN "to_1" varchar(128) not null default('');
UPDATE "ReportSet" SET "to_1" = "to";
ALTER TABLE "ReportSet" DROP COLUMN "to";
ALTER TABLE "ReportSet" RENAME COLUMN "to_1" TO "to";
ALTER TABLE "ReportSet" ALTER COLUMN "to" DROP default;

ALTER TABLE "ReportSet" ADD COLUMN "from_1" varchar(128) not null default('');
UPDATE "ReportSet" SET "from_1" = "from";
ALTER TABLE "ReportSet" DROP COLUMN "from";
ALTER TABLE "ReportSet" RENAME COLUMN "from_1" TO "from";
ALTER TABLE "ReportSet" ALTER COLUMN "from" DROP default;

ALTER TABLE "ReportSet" ADD COLUMN "lastSent_1" timestamp;
UPDATE "ReportSet" SET "lastSent_1" = "lastSent";
ALTER TABLE "ReportSet" DROP COLUMN "lastSent";
ALTER TABLE "ReportSet" RENAME COLUMN "lastSent_1" TO "lastSent";

ALTER TABLE "Vm" ADD COLUMN "biosUuid_1" varchar(128) NOT NULL;
ALTER TABLE "Vm" DROP COLUMN "biosUuid";
ALTER TABLE "Vm" RENAME COLUMN "biosUuid_1" TO "biosUuid";

ALTER TABLE "VcdServer" ADD COLUMN "serialNumber_1" varchar(128) not null default('');
UPDATE "VcdServer" SET "serialNumber_1" = "serialNumber";
ALTER TABLE "VcdServer" DROP COLUMN "serialNumber";
ALTER TABLE "VcdServer" RENAME COLUMN "serialNumber_1" TO "serialNumber";
ALTER TABLE "VcdServer" ALTER COLUMN "serialNumber" DROP default;

ALTER TABLE "EmailServer" ADD COLUMN "connectionSecurity_1" integer not null default(0);
UPDATE "EmailServer" SET "connectionSecurity_1" = "connectionSecurity";
ALTER TABLE "EmailServer" DROP COLUMN "connectionSecurity";
ALTER TABLE "EmailServer" RENAME COLUMN "connectionSecurity_1" to "connectionSecurity";
ALTER TABLE "EmailServer" ALTER COLUMN "connectionSecurity" DROP default;

ALTER TABLE "VcServer" ADD COLUMN "instanceUuid_1" varchar(128) not null default('');
UPDATE "VcServer" SET "instanceUuid_1" = "instanceUuid";
ALTER TABLE "VcServer" DROP COLUMN "instanceUuid";
ALTER TABLE "VcServer" RENAME COLUMN "instanceUuid_1" to "instanceUuid";
ALTER TABLE "VcServer" ALTER COLUMN "instanceUuid" DROP default;

ALTER TABLE "VcServer" ADD COLUMN "fullName_1" varchar(128) not null default('');
UPDATE "VcServer" SET "fullName_1" = "fullName";
ALTER TABLE "VcServer" DROP COLUMN "fullName";
ALTER TABLE "VcServer" RENAME COLUMN "fullName_1" to "fullName";
ALTER TABLE "VcServer" ALTER COLUMN "fullName" DROP default;

ALTER TABLE "VcServer" ADD COLUMN "version_1" varchar(128) not null default('');
UPDATE "VcServer" SET "version_1" = "version";
ALTER TABLE "VcServer" DROP COLUMN "version";
ALTER TABLE "VcServer" RENAME COLUMN "version_1" to "version";
ALTER TABLE "VcServer" ALTER COLUMN "version" DROP default;

ALTER TABLE "VcServer" ADD COLUMN "meter_1" boolean not null default(true);
UPDATE "VcServer" SET "meter_1" = "meter";
ALTER TABLE "VcServer" DROP COLUMN "meter";
ALTER TABLE "VcServer" RENAME COLUMN "meter_1" to "meter";
ALTER TABLE "VcServer" ALTER COLUMN "meter" DROP default;

ALTER TABLE "VcServer" ADD COLUMN "port_1" integer not null default(443);
UPDATE "VcServer" SET "port_1" = "port";
ALTER TABLE "VcServer" DROP COLUMN "port";
ALTER TABLE "VcServer" RENAME COLUMN "port_1" to "port";
ALTER TABLE "VcServer" ALTER COLUMN "port" DROP default;

ALTER TABLE "VcServer" ADD COLUMN "vcdServerId" integer not null default(0);

ALTER TABLE "Customer" ADD COLUMN "name_1" character varying(128) not null default('');
UPDATE "Customer" SET "name_1" = "name";
ALTER TABLE "Customer" DROP COLUMN "name";
ALTER TABLE "Customer" RENAME COLUMN "name_1" to "name";
ALTER TABLE "Customer" ALTER COLUMN "name" DROP default;

ALTER TABLE "User" ADD COLUMN "username_1" character varying(100) not null default ('');
UPDATE "User" SET "username_1" = "username";
ALTER TABLE "User" DROP COLUMN "username";
ALTER TABLE "User" RENAME COLUMN "username_1" to "username";
ALTER TABLE "User" ALTER COLUMN "username" DROP default;

ALTER TABLE "VcopsServer" ADD COLUMN "active_1" boolean not null default(true);
UPDATE "VcopsServer" SET "active_1" = "active";
ALTER TABLE "VcopsServer" DROP COLUMN "active";
ALTER TABLE "VcopsServer" RENAME COLUMN "active_1" to "active";
ALTER TABLE "VcopsServer" ALTER COLUMN "active" drop default;

ALTER TABLE "VcopsServer" ADD COLUMN "licenseNameId_1" integer not null default(1);
UPDATE "VcopsServer" SET "licenseNameId_1" = "licenseNameId";
ALTER TABLE "VcopsServer" DROP COLUMN "licenseNameId";
ALTER TABLE "VcopsServer" RENAME COLUMN "licenseNameId_1" to "licenseNameId";
ALTER TABLE "VcopsServer" ALTER COLUMN "licenseNameId" drop default;

alter table "VcacServer" add column "cafeHost" varchar(128) not null default('');
alter table "VcacServer" alter column "cafeHost" drop default;
alter table "VcacServer" add column "solutionUser" varchar(128) not null default('');
alter table "VcacServer" alter column "solutionUser" drop default;
alter table "VcacServer" add column "licenseNameId" integer not null default(1);
alter table "VcacServer" alter column "licenseNameId" drop default;

update "VcacServer" set "active" = 'f';

alter table "NsxServer" drop column "vcServerId";
alter table "NsxServer" drop column version;
alter table "NsxServer" add column port integer not null default(443);
alter table "NsxServer" add column "vchost" varchar(128) not null default('0.0.0.0');
alter table "NsxServer" add column "licenseType" integer not null default(1);
alter table "NsxServer" alter column "vchost" drop default;
alter table "NsxServer" alter column "licenseType" drop default;

alter table "DesktoneServer" add column "sessionModels" integer not null default(0);
alter table "DesktoneMonth" add column "tenant" varchar(1000);

ALTER TABLE "ReportSettings"
	DROP COLUMN IF EXISTS "vcopsInPremierPlus";

create table "CollectionMsg" (
    "id" integer not null,
    "collectionId" integer not null,
    "time" timestamp,
    "serverTypeId" integer,
    "host" varchar(255),
    "message" varchar(10000) not null
  );
create sequence "s_CollectionMsg_id";


ALTER TABLE "Collection"
	DROP COLUMN if exists errors;

create table "VcCollectionMsg" (
    "id" integer not null,
    "firstTime" timestamp not null,
    "lastTime" timestamp not null,
    "occurs" integer not null,
    "host" varchar(255) not null,
    "message" varchar(10000) not null
  );
create sequence "s_VcCollectionMsg_id";

create table "VcacLicenseName" (
    "id" integer not null,
    "name" varchar(128) not null
  );
create sequence "s_VcacLicenseName_id";

insert into "VcacLicenseName" values(nextval('"s_VcacLicenseName_id"'), 'Not yet discovered');

DROP TABLE "VmHistory";
create table "VmHistory" (
    "id" integer not null,
    "vmId" integer not null,
    "time" timestamp not null,
    "nextTime" timestamp not null,
    "hostId" integer not null,
    "connState" integer not null,
    "powerState" integer not null,
    "vmMemSize" integer not null,
    "vmMemRes" integer not null,
    "guestFullName" varchar(1000),
    "cpuCount" integer not null,
    "vrops" boolean not null
  );

ALTER TABLE "VmHistory"   ADD CHECK (time < "nextTime");

create view "VmLatestHistoryId" as
    select id from "VmHistory" a where exists(
        select * from (
            select distinct "vmId", max(time) over (partition by "vmId") latest from "VmHistory"
        ) b where a.time = b.latest and a."vmId" = b."vmId"
    );

DROP TABLE if exists "HostHistory";
create table "HostHistory" (
    "id" integer not null,
    "hostId" integer not null,
    "time" timestamp not null,
    "nextTime" timestamp not null,
    "fullName" varchar(128) not null,
    "version" varchar(128) not null,
    "name" varchar(128) not null,
    "licenseId" integer not null,
    "memSize" bigint not null,
    "licenseCategoryId" integer not null default(1),
    "nsx" integer not null,
    "vcd" boolean not null default(false)
  );

ALTER TABLE "HostHistory" ADD CHECK (time < "nextTime");

-- Vsan
create table if not exists "ClusterVsanHistory" (
    "id" integer primary key not null,
    "vcServerId" integer not null,
    "clusterName" varchar(128) not null,
    "vsanLicCategory" integer not null,
    "usedTotalMb" bigint not null,
    "collectTime" timestamp not null
  );
create sequence "s_ClusterVsanHistory_id";

drop function if exists "vsan_space_usage"(timestamp, timestamp, int);
CREATE TYPE "VsanSpaceUsage" AS
("vcServerId" integer, "clusterName" varchar(128), "vsanLicCategory" integer,
 "usedTotalMb" bigint, "intervalSeconds" double precision);

CREATE OR REPLACE FUNCTION "vsan_space_usage"(timestamp, timestamp, int)
    RETURNS SETOF "VsanSpaceUsage" AS $BODY$
SELECT v."vcServerId", v."clusterName", v."vsanLicCategory", v."usedTotalMb",
       extract(epoch from least(v."endTime", $2, now()) - greatest(v."startTime", $1)) "intervalSeconds"
FROM (SELECT c.*
      FROM "ClusterVsanHistory" c
      WHERE ("startTime", "endTime") overlaps ($1, $2)
      AND "vsanLicCategory" = $3) v
$BODY$
    LANGUAGE sql;

-- New Bundle table. We're removing all existing data anyway, so just drop and recreate.
drop table "Bundle";
create table "Bundle" (
    "id" integer not null,
    "name" varchar(128) not null,
    "points" float not null,
    "batch" integer not null
  );

drop table "Product";
create table "Product" (
    "id" integer not null,
    "name" varchar(128) not null,
    "separable" boolean not null
  );

drop table "ProductInBundle";
create table "ProductInBundle" (
    "bundleId" integer not null,
    "productId" integer not null
  );

insert into "Bundle" values(1, 'Standard Edition',        5, 1);
insert into "Bundle" values(2, 'Premier Edition',         7, 1);
insert into "Bundle" values(3, 'Premier-X Edition',      10, 1);
insert into "Bundle" values(4, 'Premier Plus Edition',   10, 1);
insert into "Bundle" values(5, 'Premier-X Plus Edition', 13, 1);

insert into "Bundle" values(6,  'Starter Bundle',                              3.5, 2);
insert into "Bundle" values(7,  'Standard Bundle',                               5, 2);
insert into "Bundle" values(8,  'Advanced Bundle',                               7, 2);
insert into "Bundle" values(9,  'Standard Bundle with Networking',               8, 2);
insert into "Bundle" values(10, 'Standard Bundle with Management',               8, 2);
insert into "Bundle" values(11, 'Advanced Bundle with Networking',               9, 2);
insert into "Bundle" values(12, 'Advanced Bundle with Management',              10, 2);
insert into "Bundle" values(13, 'Advanced Bundle with Networking & Management', 12, 2);

insert into "Product" values(1,  'vSphere Enterprise',             false);
insert into "Product" values(2,  'vSphere Enterprise Plus',        false);
insert into "Product" values(3,  'vSphere Standard',               false);
insert into "Product" values(4,  'vCenter Server Std',             false);
insert into "Product" values(5,  'NSX Enterprise',                  true);
insert into "Product" values(6,  'NSX Advanced',                    true);
insert into "Product" values(7,  'NSX Base',                        true);
insert into "Product" values(8,  'vRealize Operations Enterprise',  true);
insert into "Product" values(9,  'vRealize Log Insight',            true);
insert into "Product" values(10, 'vCloud Director',                 true);
insert into "Product" values(11, 'vRB for Cloud Adv',               true);
insert into "Product" values(12, 'ChargeBack Manager',              true);

insert into "ProductInBundle" values(1, 1);
insert into "ProductInBundle" values(1, 9);
insert into "ProductInBundle" values(1, 10);
insert into "ProductInBundle" values(1, 11);
insert into "ProductInBundle" values(1, 12);

insert into "ProductInBundle" values(2, 2);
insert into "ProductInBundle" values(2, 9);
insert into "ProductInBundle" values(2, 10);
insert into "ProductInBundle" values(2, 11);
insert into "ProductInBundle" values(2, 12);

insert into "ProductInBundle" values(3, 2);
insert into "ProductInBundle" values(3, 5);
insert into "ProductInBundle" values(3, 6);
insert into "ProductInBundle" values(3, 7);
insert into "ProductInBundle" values(3, 9);
insert into "ProductInBundle" values(3, 10);
insert into "ProductInBundle" values(3, 11);
insert into "ProductInBundle" values(3, 12);

insert into "ProductInBundle" values(4, 2);
insert into "ProductInBundle" values(4, 8);
insert into "ProductInBundle" values(4, 9);
insert into "ProductInBundle" values(4, 10);
insert into "ProductInBundle" values(4, 11);
insert into "ProductInBundle" values(4, 12);

insert into "ProductInBundle" values(5, 2);
insert into "ProductInBundle" values(5, 5);
insert into "ProductInBundle" values(5, 6);
insert into "ProductInBundle" values(5, 7);
insert into "ProductInBundle" values(5, 8);
insert into "ProductInBundle" values(5, 9);
insert into "ProductInBundle" values(5, 10);
insert into "ProductInBundle" values(5, 11);
insert into "ProductInBundle" values(5, 12);

insert into "ProductInBundle" values(6, 3);
insert into "ProductInBundle" values(6, 4);

insert into "ProductInBundle" values(7, 1);
insert into "ProductInBundle" values(7, 4);
insert into "ProductInBundle" values(7, 10);
insert into "ProductInBundle" values(7, 11);
insert into "ProductInBundle" values(7, 12);

insert into "ProductInBundle" values(8, 2);
insert into "ProductInBundle" values(8, 4);
insert into "ProductInBundle" values(8, 7);
insert into "ProductInBundle" values(8, 9);
insert into "ProductInBundle" values(8, 10);

insert into "ProductInBundle" values(9, 2);
insert into "ProductInBundle" values(9, 4);
insert into "ProductInBundle" values(9, 6);
insert into "ProductInBundle" values(9, 9);

insert into "ProductInBundle" values(10, 2);
insert into "ProductInBundle" values(10, 4);
insert into "ProductInBundle" values(10, 8);
insert into "ProductInBundle" values(10, 9);

insert into "ProductInBundle" values(11, 2);
insert into "ProductInBundle" values(11, 4);
insert into "ProductInBundle" values(11, 6);
insert into "ProductInBundle" values(11, 9);
insert into "ProductInBundle" values(11, 10);

insert into "ProductInBundle" values(12, 2);
insert into "ProductInBundle" values(12, 4);
insert into "ProductInBundle" values(12, 7);
insert into "ProductInBundle" values(12, 8);
insert into "ProductInBundle" values(12, 9);
insert into "ProductInBundle" values(12, 10);

insert into "ProductInBundle" values(13, 2);
insert into "ProductInBundle" values(13, 4);
insert into "ProductInBundle" values(13, 5);
insert into "ProductInBundle" values(13, 8);
insert into "ProductInBundle" values(13, 9);
insert into "ProductInBundle" values(13, 10);

create view "HostLatestHistory" as
    select * from "HostHistory" a where exists(
        select * from (
            select distinct "hostId", max(time) over (partition by "hostId") latest from "HostHistory"
        ) b where a.time = b.latest and a."hostId" = b."hostId"
    );

CREATE VIEW "HostLatest" AS
    SELECT
        h.id,
        hl.id "hhId",
        h.uuid,
        h."vcServerId",
        moref,
        time,
        "nextTime",
        "fullName",
        "version",
        "name",
        "licenseId",
        "memSize"
    FROM "Host" h
        JOIN "HostLatestHistory" hl ON h.id = hl."hostId";

CREATE TYPE "VmHistory4Report" AS
("vmId" integer, "vcId" integer, "vcName" varchar(128), "guestHostName" varchar(128),
 "instanceUuid" varchar(128), "moref" varchar(128), "reportExclusionReason" integer, "vcIP" varchar(128),
 "vmhId" integer, "hostId" integer, "connState" integer, "powerState" integer, "vhTime" timestamp, "vhNextTime" timestamp,
 "vmMemSize" integer,"vmMemRes" integer, "cpuCount" integer, "vrops" boolean, "hhName" varchar(128), "hhMemSize" bigint,
 "licenseId" integer, "hhTime" timestamp, "hhNextTime" timestamp, "nsx" integer, "vcd" boolean, "licenseCategoryId" integer,
 "licenseName" varchar(128), "intervalStart" timestamp, "intervalEnd" timestamp, "billingMem" integer);

CREATE OR REPLACE FUNCTION "vm_history"(report_starttime timestamp, report_endtime timestamp, license_ids int[])
    RETURNS SETOF "VmHistory4Report"
AS $BODY$
SELECT v.id                  "vmId",
       v."vcServerId"        "vcId",
       v."vcName",
       v."guestHostName",
       v."instanceUuid",
       v."moref",
       v."reportExclusionReason",
       vc."host"             "vcIP",
       vh.id                 "vmhId",
       vh."hostId",
       vh."connState",
       vh."powerState",
       vh.time               "vhTime",
       vh."nextTime"         "vhNextTime",
       vh."vmMemSize",
       vh."vmMemRes",
       vh."cpuCount",
       vh."vrops",
       hh."name"             "hhName",
       hh."memSize"          "hhMemSize",
       hh."licenseId",
       hh.time               "hhTime",
       hh."nextTime"         "hhNextTime",
       hh."nsx",
       hh."vcd",
       hh."licenseCategoryId",
       l."name"               "licenseName",
       greatest(vh.time, hh.time)                         "intervalStart",
       least(vh."nextTime", hh."nextTime")                "intervalEnd",
       greatest(vh."vmMemSize"/2, vh."vmMemRes")          "billingMem"
FROM "Vm" v, "VmHistory" vh, "HostHistory" hh, "License" l, "VcServer" vc
WHERE v.id = vh."vmId" AND v."vcServerId" = vc.id AND vh."hostId" = hh."hostId"
AND hh."licenseId" = l.id AND hh."licenseCategoryId" = 1
AND (vh.time, vh."nextTime") overlaps (report_starttime, report_endtime)
AND (hh.time, hh."nextTime") overlaps (report_starttime, report_endtime)
AND (vh.time, vh."nextTime") overlaps (hh.time, hh."nextTime")
AND vh."connState" = 1 AND vh."powerState" = 1
AND ((array_length(license_ids, 1) is null) or (hh."licenseId" = any (license_ids)))
AND v."reportExclusionReason" is null
$BODY$
      LANGUAGE sql;

CREATE TYPE "BillableVmHistory4Report" AS
("vmId" integer, "vcId" integer, "vcName" varchar(128), "guestHostName" varchar(128), "instanceUuid" varchar(128),
 "moref" varchar(128),"reportExclusionReason" integer, "vcIP" varchar(128), "vmhId" integer, "hostId" integer,
 "connState" integer, "powerState" integer, "vhTime" timestamp, "vhNextTime" timestamp, "vmMemSize" integer, "vmMemRes" integer,
 "cpuCount" integer, "vrops" boolean, "hhName" varchar(128), "hhMemSize" bigint, "licenseId" integer,
 "hhTime" timestamp, "hhNextTime" timestamp, "nsx" integer, "vcd" boolean, "licenseCategoryId" integer, "licenseName" varchar(128),
 "intervalStart" timestamp, "intervalEnd" timestamp, "billingMem" integer, "intervalSeconds" double precision,
 "billedVramMbhActual" double precision, "billedVramMbh" double precision);

CREATE FUNCTION "billable_vm_history"(timestamp, timestamp, license_ids int[], int)
    RETURNS SETOF "BillableVmHistory4Report" AS $BODY$
SELECT v.*, v."billingMem" * v."intervalSeconds" / 3600 "billedVramMbhActual",
       capped(v."billingMem", $4) * v."intervalSeconds" / 3600 "billedVramMbh"
FROM (SELECT *,
      extract(epoch from least("intervalEnd", $2, now()) - greatest("intervalStart", $1)) "intervalSeconds"
      FROM vm_history($1, $2, $3) vhl
     ) v
$BODY$
    LANGUAGE sql;

create function customer_summary(timestamp, timestamp, int, license_ids int[])
  returns table(id int, "customerName" varchar, "licenseName" varchar,
    sbm double precision, sbmc double precision)
  as $BODY$
select c.id, c.name "customerName", vhl."licenseName",
    sum(vhl."billedVramMbhActual") sbm,
    sum(vhl."billedVramMbh") sbmc
from billable_vm_history($1, $2, license_ids, $3) vhl
left join "CustomerVm" cv on cv."vmId" = vhl."vmId"
left join "Customer" c on c.id = cv."customerId"
group by c.id, c.name, vhl."licenseName"
$BODY$
    language sql;

create function vm_counts_by_vc(timestamp, timestamp, license_ids int[], int)
  returns table("vcServerId" int, count bigint)
  as $BODY$
select bvh."vcId", count(distinct bvh."vmId")
from billable_vm_history($1, $2, license_ids, $4) bvh
group by bvh."vcId"
having count(distinct bvh."vmId") > 0
$BODY$
    language sql;

create function vm_counts_by_vcd(timestamp, timestamp, license_ids int[], int)
  returns table("vcdServerId" int, count bigint)
  as $BODY$
select vsc."vcdServerId", count(distinct bvh."vmId")
from billable_vm_history($1, $2, license_ids, $4) bvh
join "CustomerVm" cv on cv."vmId" = bvh."vmId"
join "VcdServerCustomer" vsc on vsc."customerId" = cv."customerId"
group by vsc."vcdServerId"
having count(distinct bvh."vmId") > 0
$BODY$
    language sql;

create view "AllHostnames" as
      select host from "DesktoneServer"
union select host from "LdapServer"
union select host from "NsxServer"
union select host from "VcacServer"
union select host from "VcdServer"
union select host from "VcopsServer"
union select host from "VcServer";

create view "LicenseHostCount" as
    select l.id, l.name, l.code, count(l.code) as "numHosts" from "License" l, "HostLatestHistory" h
        where h."licenseId" = l.id
        group by l.id, l.name, l.code;

-- Other tables
create table "VcEnv" (
    "id" integer not null,
    "vcServerId" integer not null,
    "envCode" integer not null
  );
create sequence "s_VcEnv_id";

create table "Cluster" (
    "id"   integer not null,
    "name" varchar(128) not null,
    "vcServerId" integer not null,
    "vsanEnabled" boolean not null,
    "lastChanged" timestamp not null
);

UPDATE "LicenseCategory" SET "name" = 'vCAN' WHERE "name" = 'vCAN';

-- Mark migration is done.
UPDATE "SchemaInfo" SET "version" = 15, "migrationDone" = true;