-- This script is to add constraints and indexes as the last step to migrate to UM 3.5.0 from UM 3.3.3 or UM 3.4.0.

SET statement_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

SET search_path = public, pg_catalog;

SET default_tablespace = '';

--
-- Name: CollectionMsg_pkey; Type: CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "CollectionMsg"
    ADD CONSTRAINT "CollectionMsg_pkey" PRIMARY KEY (id);


--
-- Name: Collection_pkey; Type: CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "Collection"
    ADD CONSTRAINT "Collection_pkey" PRIMARY KEY (id);


--
-- Name: CustomerLocation_pkey; Type: CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "CustomerLocation"
    ADD CONSTRAINT "CustomerLocation_pkey" PRIMARY KEY (id);


--
-- Name: CustomerVmRule_pkey; Type: CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "CustomerVmRule"
    ADD CONSTRAINT "CustomerVmRule_pkey" PRIMARY KEY (id);


--
-- Name: CustomerVm_pkey; Type: CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "CustomerVm"
    ADD CONSTRAINT "CustomerVm_pkey" PRIMARY KEY (id);


--
-- Name: Customer_pkey; Type: CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "Customer"
    ADD CONSTRAINT "Customer_pkey" PRIMARY KEY (id);


--
-- Name: DesktoneMonth_pkey; Type: CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "DesktoneMonth"
    ADD CONSTRAINT "DesktoneMonth_pkey" PRIMARY KEY (id);


--
-- Name: DesktoneServer_pkey; Type: CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "DesktoneServer"
    ADD CONSTRAINT "DesktoneServer_pkey" PRIMARY KEY (id);


--
-- Name: EmailAlerts_pkey; Type: CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "EmailAlerts"
    ADD CONSTRAINT "EmailAlerts_pkey" PRIMARY KEY (id);


--
-- Name: EmailServer_pkey; Type: CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "EmailServer"
    ADD CONSTRAINT "EmailServer_pkey" PRIMARY KEY (id);


--
-- Name: HostHistory_pkey; Type: CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "HostHistory"
    ADD CONSTRAINT "HostHistory_pkey" PRIMARY KEY (id);


--
-- Name: Host_pkey; Type: CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "Host"
    ADD CONSTRAINT "Host_pkey" PRIMARY KEY (id);


--
-- Name: InventoryItem_pkey; Type: CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "InventoryItem"
    ADD CONSTRAINT "InventoryItem_pkey" PRIMARY KEY (id);


--
-- Name: LicenseCategory_pkey; Type: CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "LicenseCategory"
    ADD CONSTRAINT "LicenseCategory_pkey" PRIMARY KEY (id);


--
-- Name: LicenseSetLicense_pkey; Type: CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "LicenseSetLicense"
    ADD CONSTRAINT "LicenseSetLicense_pkey" PRIMARY KEY ("licenseSetId", "licenseId");


--
-- Name: LicenseSet_pkey; Type: CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "LicenseSet"
    ADD CONSTRAINT "LicenseSet_pkey" PRIMARY KEY (id);


--
-- Name: License_pkey; Type: CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "License"
    ADD CONSTRAINT "License_pkey" PRIMARY KEY (id);


--
-- Name: NsxServer_pkey; Type: CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "NsxServer"
    ADD CONSTRAINT "NsxServer_pkey" PRIMARY KEY (id);


--
-- Name: ProtectedUuidMonth_pkey; Type: CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "ProtectedUuidMonth"
    ADD CONSTRAINT "ProtectedUuidMonth_pkey" PRIMARY KEY (id);


--
-- Name: Provider_pkey; Type: CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "Provider"
    ADD CONSTRAINT "Provider_pkey" PRIMARY KEY (id);


--
-- Name: ReportSetLicenseSet_pkey; Type: CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "ReportSetLicenseSet"
    ADD CONSTRAINT "ReportSetLicenseSet_pkey" PRIMARY KEY ("reportSetId", "licenseSetId");


--
-- Name: ReportSetReport_pkey; Type: CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "ReportSetReport"
    ADD CONSTRAINT "ReportSetReport_pkey" PRIMARY KEY ("reportSetId", "reportId");


--
-- Name: ReportSet_pkey; Type: CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "ReportSet"
    ADD CONSTRAINT "ReportSet_pkey" PRIMARY KEY (id);


--
-- Name: ReportSettings_pkey; Type: CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "ReportSettings"
    ADD CONSTRAINT "ReportSettings_pkey" PRIMARY KEY (id);


--
-- Name: SrmVcPair_pkey; Type: CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "SrmVcPair"
    ADD CONSTRAINT "SrmVcPair_pkey" PRIMARY KEY (id);


--
-- Name: Token_pkey; Type: CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "Token"
    ADD CONSTRAINT "Token_pkey" PRIMARY KEY (id);


--
-- Name: VcCollectionMsg_pkey; Type: CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "VcCollectionMsg"
    ADD CONSTRAINT "VcCollectionMsg_pkey" PRIMARY KEY (id);


--
-- Name: VcEnv_pkey; Type: CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "VcEnv"
    ADD CONSTRAINT "VcEnv_pkey" PRIMARY KEY (id);


--
-- Name: VcServer_pkey; Type: CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "VcServer"
    ADD CONSTRAINT "VcServer_pkey" PRIMARY KEY (id);


--
-- Name: VcSrm_pkey; Type: CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "VcSrm"
    ADD CONSTRAINT "VcSrm_pkey" PRIMARY KEY (id);


--
-- Name: VcVcops_pkey; Type: CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "VcVcops"
    ADD CONSTRAINT "VcVcops_pkey" PRIMARY KEY ("vcServerId", "vcopsServerId");


--
-- Name: VcacLicenseName_pkey; Type: CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "VcacLicenseName"
    ADD CONSTRAINT "VcacLicenseName_pkey" PRIMARY KEY (id);


--
-- Name: VcacMonth_pkey; Type: CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "VcacMonth"
    ADD CONSTRAINT "VcacMonth_pkey" PRIMARY KEY (id);


--
-- Name: VcacServer_pkey; Type: CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "VcacServer"
    ADD CONSTRAINT "VcacServer_pkey" PRIMARY KEY (id);


--
-- Name: VcdServerCustomer_pkey; Type: CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "VcdServerCustomer"
    ADD CONSTRAINT "VcdServerCustomer_pkey" PRIMARY KEY ("vcdServerId", "customerId");


--
-- Name: VcdServer_pkey; Type: CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "VcdServer"
    ADD CONSTRAINT "VcdServer_pkey" PRIMARY KEY (id);


--
-- Name: VcdVdcInfo_pkey; Type: CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "VcdVdcInfo"
    ADD CONSTRAINT "VcdVdcInfo_pkey" PRIMARY KEY (id);


--
-- Name: VcopsLicenseName_pkey; Type: CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "VcopsLicenseName"
    ADD CONSTRAINT "VcopsLicenseName_pkey" PRIMARY KEY (id);


--
-- Name: VcopsServer_pkey; Type: CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "VcopsServer"
    ADD CONSTRAINT "VcopsServer_pkey" PRIMARY KEY (id);


--
-- Name: VcopsVmCollection_pkey; Type: CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "VcopsVmCollection"
    ADD CONSTRAINT "VcopsVmCollection_pkey" PRIMARY KEY (id);


--
-- Name: VmHistory_pkey; Type: CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "VmHistory"
    ADD CONSTRAINT "VmHistory_pkey" PRIMARY KEY (id);


--
-- Name: Vm_pkey; Type: CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "Vm"
    ADD CONSTRAINT "Vm_pkey" PRIMARY KEY (id);


--
-- Name: DesktoneMonth_desktoneServerId_year_month_tenant; Type: INDEX; Schema: public; Owner: usgmtr
--

CREATE UNIQUE INDEX "DesktoneMonth_desktoneServerId_year_month_tenant" ON "DesktoneMonth" USING btree ("desktoneServerId", year, month, tenant);


--
-- Name: DesktoneServer_host; Type: INDEX; Schema: public; Owner: usgmtr
--

CREATE UNIQUE INDEX "DesktoneServer_host" ON "DesktoneServer" USING btree (host);


--
-- Name: HostHistory_hostId_time; Type: INDEX; Schema: public; Owner: usgmtr
--

CREATE INDEX "HostHistory_hostId_time" ON "HostHistory" USING btree ("hostId", "time");


--
-- Name: HostHistory_licenseCategoryId_time_nextTime; Type: INDEX; Schema: public; Owner: usgmtr
--

CREATE UNIQUE INDEX "HostHistory_licenseCategoryId_time_nextTime" ON "HostHistory" USING btree ("licenseCategoryId", "time", "nextTime", "licenseId", "hostId");


--
-- Name: InventoryItem_vcServerId_moref; Type: INDEX; Schema: public; Owner: usgmtr
--

CREATE UNIQUE INDEX "InventoryItem_vcServerId_moref" ON "InventoryItem" USING btree ("vcServerId", moref);


--
-- Name: NsxServerHost; Type: INDEX; Schema: public; Owner: usgmtr
--

CREATE UNIQUE INDEX "NsxServerHost" ON "NsxServer" USING btree (host);


--
-- Name: ProtectedUuidMonth_biosUuid_year_month; Type: INDEX; Schema: public; Owner: usgmtr
--

CREATE UNIQUE INDEX "ProtectedUuidMonth_biosUuid_year_month" ON "ProtectedUuidMonth" USING btree ("biosUuid", year, month);


--
-- Name: SrmVcPair_vcServerId1; Type: INDEX; Schema: public; Owner: usgmtr
--

CREATE UNIQUE INDEX "SrmVcPair_vcServerId1" ON "SrmVcPair" USING btree ("vcServerId1");


--
-- Name: VcCollectionMsg_firstTime; Type: INDEX; Schema: public; Owner: usgmtr
--

CREATE INDEX "VcCollectionMsg_firstTime" ON "VcCollectionMsg" USING btree ("firstTime");


--
-- Name: VcServer_instanceUuid; Type: INDEX; Schema: public; Owner: usgmtr
--

CREATE UNIQUE INDEX "VcServer_instanceUuid" ON "VcServer" USING btree ("instanceUuid");


--
-- Name: VcSrm_vcServerId; Type: INDEX; Schema: public; Owner: usgmtr
--

CREATE UNIQUE INDEX "VcSrm_vcServerId" ON "VcSrm" USING btree ("vcServerId");


--
-- Name: VcVcops_VcopsServerId; Type: INDEX; Schema: public; Owner: usgmtr
--

CREATE INDEX "VcVcops_VcopsServerId" ON "VcVcops" USING btree ("vcopsServerId");


--
-- Name: VcacMonth_vcacServerId_year_month; Type: INDEX; Schema: public; Owner: usgmtr
--

CREATE UNIQUE INDEX "VcacMonth_vcacServerId_year_month" ON "VcacMonth" USING btree ("vcacServerId", year, month);


--
-- Name: VcacServer_host; Type: INDEX; Schema: public; Owner: usgmtr
--

CREATE UNIQUE INDEX "VcacServer_host" ON "VcacServer" USING btree (host);


--
-- Name: VcdServer_host_port; Type: INDEX; Schema: public; Owner: usgmtr
--

CREATE UNIQUE INDEX "VcdServer_host_port" ON "VcdServer" USING btree (host, port);


--
-- Name: VcopsServerHost; Type: INDEX; Schema: public; Owner: usgmtr
--

CREATE UNIQUE INDEX "VcopsServerHost" ON "VcopsServer" USING btree (host);


--
-- Name: VcopsVmCollection_timestamp; Type: INDEX; Schema: public; Owner: usgmtr
--

CREATE INDEX "VcopsVmCollection_timestamp" ON "VcopsVmCollection" USING btree ("timestamp");


--
-- Name: VmHistory_time_nextTime_states; Type: INDEX; Schema: public; Owner: usgmtr
--

CREATE INDEX "VmHistory_time_nextTime_states" ON "VmHistory" USING btree ("time", "nextTime", "connState", "powerState", "hostId");


--
-- Name: VmHistory_vmId_nextTime_vrops; Type: INDEX; Schema: public; Owner: usgmtr
--

CREATE UNIQUE INDEX "VmHistory_vmId_nextTime_vrops" ON "VmHistory" USING btree ("vmId", "nextTime", vrops);


--
-- Name: VmHistory_vmId_time; Type: INDEX; Schema: public; Owner: usgmtr
--

CREATE UNIQUE INDEX "VmHistory_vmId_time" ON "VmHistory" USING btree ("vmId", "time");


--
-- Name: Vm_vcServerId; Type: INDEX; Schema: public; Owner: usgmtr
--

CREATE INDEX "Vm_vcServerId" ON "Vm" USING btree ("vcServerId");


--
-- Name: collection_start; Type: INDEX; Schema: public; Owner: usgmtr
--

CREATE INDEX collection_start ON "Collection" USING btree (start);


--
-- Name: idx1d64048c; Type: INDEX; Schema: public; Owner: usgmtr
--

CREATE UNIQUE INDEX idx1d64048c ON "License" USING btree (code);


--
-- Name: idx24220521; Type: INDEX; Schema: public; Owner: usgmtr
--

CREATE UNIQUE INDEX idx24220521 ON "Customer" USING btree (name);


--
-- Name: idx2dd705be; Type: INDEX; Schema: public; Owner: usgmtr
--

CREATE UNIQUE INDEX idx2dd705be ON "LicenseSet" USING btree (name);


--
-- Name: idx2fab05d3; Type: INDEX; Schema: public; Owner: usgmtr
--

CREATE UNIQUE INDEX idx2fab05d3 ON "CustomerVm" USING btree ("vmId");


--
-- Name: idx518407d0; Type: INDEX; Schema: public; Owner: usgmtr
--

CREATE UNIQUE INDEX idx518407d0 ON "LicenseCategory" USING btree (name);


--
-- Name: idx859709f3; Type: INDEX; Schema: public; Owner: usgmtr
--

CREATE UNIQUE INDEX idx859709f3 ON "Host" USING btree ("vcServerId", moref, uuid);


--
-- Name: idxc72a0c4d; Type: INDEX; Schema: public; Owner: usgmtr
--

CREATE UNIQUE INDEX idxc72a0c4d ON "Vm" USING btree ("vcServerId", moref, "instanceUuid");


--
-- Name: vcEnv_vcServerId; Type: INDEX; Schema: public; Owner: usgmtr
--

CREATE UNIQUE INDEX "vcEnv_vcServerId" ON "VcEnv" USING btree ("vcServerId");


--
-- Name: CollectionMsgFK1; Type: FK CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "CollectionMsg"
    ADD CONSTRAINT "CollectionMsgFK1" FOREIGN KEY ("collectionId") REFERENCES "Collection"(id);


--
-- Name: CustomerFK31; Type: FK CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "Customer"
    ADD CONSTRAINT "CustomerFK31" FOREIGN KEY ("providerId") REFERENCES "Provider"(id);


--
-- Name: CustomerLocationFK1; Type: FK CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "CustomerLocation"
    ADD CONSTRAINT "CustomerLocationFK1" FOREIGN KEY ("customerId") REFERENCES "Customer"(id);


--
-- Name: CustomerVmFK16; Type: FK CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "CustomerVm"
    ADD CONSTRAINT "CustomerVmFK16" FOREIGN KEY ("customerId") REFERENCES "Customer"(id);


--
-- Name: CustomerVmFK18; Type: FK CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "CustomerVm"
    ADD CONSTRAINT "CustomerVmFK18" FOREIGN KEY ("vmId") REFERENCES "Vm"(id);


--
-- Name: CustomerVmFK19; Type: FK CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "CustomerVm"
    ADD CONSTRAINT "CustomerVmFK19" FOREIGN KEY ("customerVmRuleId") REFERENCES "CustomerVmRule"(id);


--
-- Name: CustomerVmRuleFK17; Type: FK CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "CustomerVmRule"
    ADD CONSTRAINT "CustomerVmRuleFK17" FOREIGN KEY ("customerId") REFERENCES "Customer"(id);


--
-- Name: CustomerVmRuleFK30; Type: FK CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "CustomerVmRule"
    ADD CONSTRAINT "CustomerVmRuleFK30" FOREIGN KEY ("vcServerId") REFERENCES "VcServer"(id);


--
-- Name: DesktoneMonthFK8; Type: FK CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "DesktoneMonth"
    ADD CONSTRAINT "DesktoneMonthFK8" FOREIGN KEY ("desktoneServerId") REFERENCES "DesktoneServer"(id);


--
-- Name: HostFK25; Type: FK CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "Host"
    ADD CONSTRAINT "HostFK25" FOREIGN KEY ("vcServerId") REFERENCES "VcServer"(id);


--
-- Name: HostHistoryFK2; Type: FK CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "HostHistory"
    ADD CONSTRAINT "HostHistoryFK2" FOREIGN KEY ("hostId") REFERENCES "Host"(id);


--
-- Name: HostHistoryFK3; Type: FK CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "HostHistory"
    ADD CONSTRAINT "HostHistoryFK3" FOREIGN KEY ("licenseId") REFERENCES "License"(id);


--
-- Name: InventoryItemFK26; Type: FK CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "InventoryItem"
    ADD CONSTRAINT "InventoryItemFK26" FOREIGN KEY ("vcServerId") REFERENCES "VcServer"(id);


--
-- Name: LicenseFK4; Type: FK CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "License"
    ADD CONSTRAINT "LicenseFK4" FOREIGN KEY ("licenseCategoryId") REFERENCES "LicenseCategory"(id);


--
-- Name: LicenseSetLicenseFK5; Type: FK CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "LicenseSetLicense"
    ADD CONSTRAINT "LicenseSetLicenseFK5" FOREIGN KEY ("licenseSetId") REFERENCES "LicenseSet"(id);


--
-- Name: LicenseSetLicenseFK6; Type: FK CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "LicenseSetLicense"
    ADD CONSTRAINT "LicenseSetLicenseFK6" FOREIGN KEY ("licenseId") REFERENCES "License"(id);


--
-- Name: ReportSetLicenseSetFK21; Type: FK CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "ReportSetLicenseSet"
    ADD CONSTRAINT "ReportSetLicenseSetFK21" FOREIGN KEY ("reportSetId") REFERENCES "ReportSet"(id);


--
-- Name: ReportSetLicenseSetFK22; Type: FK CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "ReportSetLicenseSet"
    ADD CONSTRAINT "ReportSetLicenseSetFK22" FOREIGN KEY ("licenseSetId") REFERENCES "LicenseSet"(id);


--
-- Name: ReportSetReportFK20; Type: FK CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "ReportSetReport"
    ADD CONSTRAINT "ReportSetReportFK20" FOREIGN KEY ("reportSetId") REFERENCES "ReportSet"(id);


--
-- Name: SrmVcPairFK27; Type: FK CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "SrmVcPair"
    ADD CONSTRAINT "SrmVcPairFK27" FOREIGN KEY ("vcServerId1") REFERENCES "VcServer"(id);


--
-- Name: SrmVcPairFK28; Type: FK CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "SrmVcPair"
    ADD CONSTRAINT "SrmVcPairFK28" FOREIGN KEY ("vcServerId2") REFERENCES "VcServer"(id);


--
-- Name: VcEnvFK32; Type: FK CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "VcEnv"
    ADD CONSTRAINT "VcEnvFK32" FOREIGN KEY ("vcServerId") REFERENCES "VcServer"(id);


--
-- Name: VcSrmFK29; Type: FK CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "VcSrm"
    ADD CONSTRAINT "VcSrmFK29" FOREIGN KEY ("vcServerId") REFERENCES "VcServer"(id);


--
-- Name: VcVcopsFK12; Type: FK CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "VcVcops"
    ADD CONSTRAINT "VcVcopsFK12" FOREIGN KEY ("vcServerId") REFERENCES "VcServer"(id);


--
-- Name: VcVcopsFK13; Type: FK CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "VcVcops"
    ADD CONSTRAINT "VcVcopsFK13" FOREIGN KEY ("vcopsServerId") REFERENCES "VcopsServer"(id);


--
-- Name: VcacMonthFK7; Type: FK CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "VcacMonth"
    ADD CONSTRAINT "VcacMonthFK7" FOREIGN KEY ("vcacServerId") REFERENCES "VcacServer"(id);


--
-- Name: VcacServerFK7; Type: FK CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "VcacServer"
    ADD CONSTRAINT "VcacServerFK7" FOREIGN KEY ("licenseNameId") REFERENCES "VcacLicenseName"(id);


--
-- Name: VcdServerCustomerFK10; Type: FK CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "VcdServerCustomer"
    ADD CONSTRAINT "VcdServerCustomerFK10" FOREIGN KEY ("customerId") REFERENCES "Customer"(id);


--
-- Name: VcdServerCustomerFK9; Type: FK CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "VcdServerCustomer"
    ADD CONSTRAINT "VcdServerCustomerFK9" FOREIGN KEY ("vcdServerId") REFERENCES "VcdServer"(id);


--
-- Name: VcdVdcInfoFK11; Type: FK CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "VcdVdcInfo"
    ADD CONSTRAINT "VcdVdcInfoFK11" FOREIGN KEY ("vcdServerId") REFERENCES "VcdServer"(id);


--
-- Name: VcopsServerFK25; Type: FK CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "VcopsServer"
    ADD CONSTRAINT "VcopsServerFK25" FOREIGN KEY ("licenseNameId") REFERENCES "VcopsLicenseName"(id);


--
-- Name: VcopsVmCollectionFK23; Type: FK CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "VcopsVmCollection"
    ADD CONSTRAINT "VcopsVmCollectionFK23" FOREIGN KEY ("vmId") REFERENCES "Vm"(id);


--
-- Name: VcopsVmCollectionFK24; Type: FK CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "VcopsVmCollection"
    ADD CONSTRAINT "VcopsVmCollectionFK24" FOREIGN KEY ("vcopsLicenseNameId") REFERENCES "VcopsLicenseName"(id);


--
-- Name: VmHistoryFK14; Type: FK CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "VmHistory"
    ADD CONSTRAINT "VmHistoryFK14" FOREIGN KEY ("hostId") REFERENCES "Host"(id);


--
-- Name: VmHistoryFK15; Type: FK CONSTRAINT; Schema: public; Owner: usgmtr
--

ALTER TABLE ONLY "VmHistory"
    ADD CONSTRAINT "VmHistoryFK15" FOREIGN KEY ("vmId") REFERENCES "Vm"(id);


--
-- PostgreSQL database dump complete
--

