#!/bin/bash

if [[ $EUID -ne 0 ]]; then
  echo "You must be a root user" 2>&1
  exit 1
fi

IP_SCR_HOME=/opt/vmware/cloudusagemetering/scripts/ipv6config

enableipv6() {
  echo "Enabling IPv6"
  cp /etc/sysctl.conf $IP_SCR_HOME/sysctl.conf.bak
  rm /etc/sysctl.conf
  cp ${IP_SCR_HOME}/sysctl.conf /etc/
  echo "Please reboot the machine"
}

disableipv6() {
  echo "disabling IPv6"
  bakfile=$IP_SCR_HOME/sysctl.conf.bak
  if [ -f "$bakfile" ]
  then
    echo "Bak file found"
    rm /etc/sysctl.conf
    cp $bakfile /etc/sysctl.conf
    echo "Please restart the machine"
  else
    echo "IPv6 is already disabled"
  fi
}

case "$1" in
         enable)
                enableipv6
                ;;
         disable)
                disableipv6
                ;;
         *)
                echo $"Usage: $0 {enable|disbale}"
                exit 1
                ;;
esac
