#!/bin/bash

echo Migrating Usage Meter from 3.2 to 3.3

source /opt/vmware/cloudusagemetering/scripts/umsetenv.sh

pushd / # Go to a directory that sudo'd users (postgres, usgmtr) can have as a CWD

service tomcat stop

echo "Updating database"
# Convert database
/opt/vmware/vpostgres/current/bin/psql -U usgmtr -f $optDir/database/migrate/320-330.sql usgmtr

echo "Copying webapp into Tomcat directory"
rm -Rf $appDir
cp $optDir/dist/um.war $webApps

echo "Setting directory ownership and permissions"
chown -R usgmtr $optDir $webApps
chmod -R 755 $optDir/scripts/*

echo "Updating appliance version"
infoDir=/opt/vmware/var/lib/vami/update/data/info
rm -f $infoDir/manifest-installed.xml.bkp
mv $infoDir/manifest-installed.xml $infoDir/manifest-installed.xml.bkp
# Change build number in next line
awk -f `dirname $0`/update-appliance-version.awk version=3.3.0.0 fullVersion='3.3.0.0 Build 1679435' $infoDir/manifest-installed.xml.bkp >$infoDir/manifest-installed.xml

service tomcat start

popd
