create table IF NOT EXISTS "VcavServer" (
"id" integer primary key not null,
"active" boolean not null,
"version" varchar(128) not null,
"host" varchar(128) not null,
"userName" varchar(128) not null,
"password" varchar(128) not null,
"changed" timestamp not null,
"port" integer not null DEFAULT 443
);

create sequence IF NOT EXISTS "s_VcavServer_id";

create unique index IF NOT EXISTS "vCloudAvailabilityHost" on "VcavServer" ("host");

create table IF NOT EXISTS "VcavVmReplication" (
"vmId" varchar(128) not null,
"vmName" varchar(128) not null,
"sourceSite" varchar(128) not null,
"destinationSite" varchar(128) not null,
"direction" varchar(128) not null,
"isMigration" boolean not null default(false),
"year" integer not null,
"month" integer not null
);

create unique index IF NOT EXISTS "VcavVmReplication_vmId_sourceSite_isMigration_month_year" on "VcavVmReplication" ("vmId","sourceSite","isMigration","year","month");