/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hibernate;

import org.hibernate.Query;
import org.hyperic.hibernate.SortField;
import org.hyperic.util.pager.PageControl;

public class PageInfo {
    private int _pageNum;
    private int _pageSize;
    private boolean _isAll;
    private SortField _sort;
    private boolean _ascending;

    private PageInfo(int pageNum, int pageSize, SortField sort, boolean ascending) {
        this._pageNum = pageNum;
        this._pageSize = pageSize;
        this._isAll = false;
        this._sort = sort;
        this._ascending = ascending;
    }

    private PageInfo(SortField sort, boolean ascending) {
        this._isAll = true;
        this._sort = sort;
        this._ascending = ascending;
    }

    public int getPageNum() {
        return this._pageNum;
    }

    public int getPageSize() {
        return this._pageSize;
    }

    public int getStartRow() {
        return this._pageNum * this._pageSize;
    }

    public SortField getSort() {
        return this._sort;
    }

    public boolean isAscending() {
        return this._ascending;
    }

    public boolean isAll() {
        return this._isAll;
    }

    public Query pageResults(Query q) {
        if (!this._isAll) {
            q.setFirstResult(this.getStartRow());
            q.setMaxResults(this.getPageSize());
        }
        return q;
    }

    public static PageInfo create(int pageNum, int pageSize, SortField sort, boolean ascending) {
        return new PageInfo(pageNum, pageSize, sort, ascending);
    }

    public static PageInfo getAll(SortField sort, boolean ascending) {
        return new PageInfo(sort, ascending);
    }

    public static PageInfo create(PageControl pc, SortField sort) {
        if (pc.equals((Object)PageControl.PAGE_ALL)) {
            return PageInfo.getAll(sort, pc.isAscending());
        }
        return new PageInfo(pc.getPagenum(), pc.getPagesize(), sort, pc.isAscending());
    }
}

