/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.tools.db.priv;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.hyperic.tools.db.priv.DefaultPrivilegeCheck;
import org.hyperic.tools.db.priv.OracleUserPrivilegeCheck;
import org.hyperic.tools.db.priv.PrivilegeCheck;
import org.hyperic.tools.db.priv.PrivilegeCheckException;
import org.hyperic.util.jdbc.JDBC;

public class PrivilegeCheckFactory {
    public static PrivilegeCheck getChecker(String jdbcUrl, String jdbcUsername, String jdbcPassword) throws PrivilegeCheckException {
        Connection conn = null;
        try {
            Class.forName(JDBC.getDriverString((String)jdbcUrl));
        }
        catch (Exception e) {
            throw new IllegalStateException("Error loading jdbc driver for url: " + jdbcUrl + ": " + e.toString());
        }
        try {
            conn = DriverManager.getConnection(jdbcUrl, jdbcUsername, jdbcPassword);
            switch (JDBC.toType((String)jdbcUrl)) {
                case 5: {
                    OracleUserPrivilegeCheck e = new OracleUserPrivilegeCheck(conn);
                    return e;
                }
                case 3: {
                    OracleUserPrivilegeCheck e = new OracleUserPrivilegeCheck(conn);
                    return e;
                }
            }
            DefaultPrivilegeCheck e = new DefaultPrivilegeCheck();
            return e;
        }
        catch (SQLException e) {
            throw new IllegalStateException("Could not connect to: " + jdbcUrl + ": " + e.getMessage());
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {}
            }
        }
    }
}

