/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.thread;

import java.util.concurrent.ThreadFactory;

public class ThreadGroupFactory
implements ThreadFactory {
    private ThreadGroup _group;
    private String _namePrefix;
    private int _numThreads;
    private boolean _createDaemonThreads;
    private final Object _syncLock = new Object();

    public ThreadGroupFactory(ThreadGroup group, String namePrefix) {
        this._group = group;
        this._namePrefix = namePrefix;
        this._numThreads = 0;
    }

    public ThreadGroupFactory(String namePrefix) {
        this(Thread.currentThread().getThreadGroup(), namePrefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDaemonThreads(boolean daemonThreads) {
        Object object = this._syncLock;
        synchronized (object) {
            this._createDaemonThreads = daemonThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Thread newThread(Runnable r) {
        boolean daemon;
        String name;
        Object object = this._syncLock;
        synchronized (object) {
            name = this._namePrefix + ++this._numThreads;
            daemon = this._createDaemonThreads;
        }
        Thread thread = new Thread(this._group, r, name);
        thread.setDaemon(daemon);
        return thread;
    }
}

