/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.units;

import java.text.NumberFormat;
import java.util.Locale;
import org.hyperic.util.units.FormattedNumber;
import org.hyperic.util.units.SimpleFormatter;

public class CurrencyFormatter
extends SimpleFormatter {
    protected String getTagName() {
        return "cents";
    }

    @Override
    protected int getUnitType() {
        return 1;
    }

    @Override
    protected int getUnitScale() {
        return 0;
    }

    @Override
    protected NumberFormat getNumberFormat(Locale locale) {
        NumberFormat res = NumberFormat.getInstance(locale);
        res.setMinimumFractionDigits(2);
        res.setMaximumFractionDigits(2);
        return res;
    }

    @Override
    protected FormattedNumber formatNumber(double rawValue, NumberFormat fmt) {
        String num = NumberFormat.getCurrencyInstance(Locale.US).format(rawValue / 100.0);
        return new FormattedNumber(num, "", " ");
    }
}

