#!/bin/sh
AGENT_BUNDLE_HOME_PROP=agent.bundle.home
AGENTPROPFILE_PROP=agent.propFile
AGENT_PROPS=../../conf/agent.properties
AGENTLOGDIR_PROP=agent.logDir
AGENTLOGDIR=../../log
AGENTDATADIR_PROP=agent.dataDir
AGENTDATADIR=../../data
AGENT_LIB=./lib
PDK_LIB=./pdk/lib
WRAPPER_LIB=../../wrapper/lib
NAME=`basename "$0"`
PARENT_PATH=${0%/*}

# for /proc/net/tcp mirror
SIGAR_PROC_NET=./tmp

# ------------- 
# Shouldn't need to change anything below this
# -------------

# Make sure any permissions will be assigned to owner only
umask 0077

cd $PARENT_PATH/../../..
INSTALL_BASE=`pwd`
cd $OLDPWD

#create log directory, in case it doesn't exist
_AGENTOPERATIONSLOGFOLDER=$INSTALL_BASE/log
if ! test -d $_AGENTOPERATIONSLOGFOLDER ; then
      mkdir $_AGENTOPERATIONSLOGFOLDER
fi
_AGENTOPERATIONSLOGFILE=$_AGENTOPERATIONSLOGFOLDER/agent.operations.log

cd_with_log() {
    cd "$1"
    if [ "$?" -ne 0 ]; then
        cd "$1" >> $_AGENTOPERATIONSLOGFILE 2>&1
    fi
}

echo_with_log() {
  echo "$1" | tee -a $_AGENTOPERATIONSLOGFILE
}

echo "" >> $_AGENTOPERATIONSLOGFILE
echo "===========================================================================" >> $_AGENTOPERATIONSLOGFILE
echo "The script $NAME started successfully at $(date)" >> $_AGENTOPERATIONSLOGFILE
echo "Requested command: ${1} ">> $_AGENTOPERATIONSLOGFILE
echo "===========================================================================" >> $_AGENTOPERATIONSLOGFILE

FINDNAME=$0 
while [ -h $FINDNAME ] ; do FINDNAME=`ls -ld $FINDNAME | awk '{print $NF}'` ; done 
RUNDIR=`echo $FINDNAME | sed -e 's@/[^/]*$@@'` 
unset FINDNAME
if test -d $RUNDIR; then
  cd_with_log $RUNDIR/..
else
  cd_with_log ..
fi

echo "Setting permissions:" >> $_AGENTOPERATIONSLOGFILE
if [ "x${HQ_JAVA_HOME}" != "x" ] ; then
    HQ_JAVA_HOME=${HQ_JAVA_HOME}
elif [ -d "${AGENT_BUNDLE_HOME}"/jre ]; then
    HQ_JAVA_HOME="${AGENT_BUNDLE_HOME}"/jre
    # Just in case
    echo "	1. chmod -R +x ${AGENT_BUNDLE_HOME}/jre/bin/*" >> $_AGENTOPERATIONSLOGFILE
    chmod -R +x "${AGENT_BUNDLE_HOME}"/jre/bin/* 2>&1 | tee -a $_AGENTOPERATIONSLOGFILE
elif [ -d jre ]; then
    HQ_JAVA_HOME=jre
    # Just in case
    echo "	1. chmod -R +x jre/bin/*" >> $_AGENTOPERATIONSLOGFILE
    chmod -R +x jre/bin/* 2>&1 | tee -a $_AGENTOPERATIONSLOGFILE 
elif [ "x$JAVA_HOME" != "x" ] ; then
    HQ_JAVA_HOME=${JAVA_HOME}
else
    case "`uname`" in
    Darwin)
        HQ_JAVA_HOME=/System/Library/Frameworks/JavaVM.framework/Home
        ;;
    *)
        echo "HQ_JAVA_HOME or JAVA_HOME must be set when invoking the agent" | tee -a $_AGENTOPERATIONSLOGFILE
        exit 1
        ;;
    esac
fi

echo "	2. chmod +x ./pdk/scripts/*" >> $_AGENTOPERATIONSLOGFILE
chmod +x ./pdk/scripts/* 2>&1 | tee -a $_AGENTOPERATIONSLOGFILE 

HQ_JAVA="${HQ_JAVA_HOME}/bin/java"

CLIENT_CLASSPATH=
for i in `ls ${AGENT_LIB}/*.jar`
do
  CLIENT_CLASSPATH="${CLIENT_CLASSPATH}:${i}"
done

for i in `ls ${PDK_LIB}/*.jar`
do
  CLIENT_CLASSPATH="${CLIENT_CLASSPATH}:${i}"
done

for i in `ls ${WRAPPER_LIB}/*.jar`
do
  CLIENT_CLASSPATH="${CLIENT_CLASSPATH}:${i}"
done


CLIENT_CLASSPATH="${CLIENT_CLASSPATH}:${AGENT_LIB}"

CLIENT_CLASS=org.hyperic.hq.bizapp.agent.client.AgentClient

HQ_JAVA_OPTS="${HQ_JAVA_OPTS} \
    -Xmx128m
    -Dsun.net.inetaddr.ttl=-1
    -Djava.net.preferIPv4Stack=false \
    -Djava.security.auth.login.config=jaas.config
    -Dagent.install.home=../.. \
    -Dagent.bundle.home=. \
    -Djava.library.path=${WRAPPER_LIB}
    -D${AGENTPROPFILE_PROP}=${AGENT_PROPS} \
    -D${AGENTLOGDIR_PROP}=${AGENTLOGDIR} \
    -D${AGENTDATADIR_PROP}=${AGENTDATADIR}"

CLIENT_CMD="${HQ_JAVA} \
    ${HQ_JAVA_OPTS}
    -cp ${CLIENT_CLASSPATH} ${CLIENT_CLASS}"

START_CMD="${CLIENT_CMD} start"
STATUS_CMD="${CLIENT_CMD} status"
PING_CMD="${CLIENT_CMD} ping"
SETUP_CMD="${CLIENT_CMD} setup"
DIE_CMD="${CLIENT_CMD} die"
SET_PROP_CMD="${CLIENT_CMD} $@"

if [ "$1" = "start" ] ; then
    echo_with_log "Starting agent"
    if ${START_CMD} ; then
        exit 0        
    else
        exit 1
    fi
elif [ "$1" = "run" ] ; then
    echo_with_log "Running agent"
    echo_with_log ${START_CMD}
    ${START_CMD} 
elif [ "$1" = "stop" ] ; then
    ${DIE_CMD} 10 || exit 1
elif [ "$1" = "status" ] ; then
    ${STATUS_CMD} || exit 1
elif [ "$1" = "ping" ] ; then
    echo_with_log "Pinging ..."
    VAL=`$PING_CMD 2>&1`
    if [ "$?" = "0" ] ; then
        echo_with_log "Success!"
    else
        echo_with_log "Failure!"
        echo_with_log "$VAL"
        exit 1
    fi
elif [ "$1" = "setup" ] ; then
    ${SETUP_CMD}
elif [ "$1" = "set-property" ] ; then
    ${SET_PROP_CMD}
else
    echo "Syntax: $0 <start | stop | ping | setup | set-property>"
    exit 1
fi
