/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.tools.db;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import org.hyperic.tools.db.DBSetup;
import org.hyperic.util.StrongCollection;
import org.hyperic.util.jdbc.JDBC;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TypeMap {
    private String _strGenericType;
    private Hashtable _mapDBType = new Hashtable();

    protected TypeMap(Node node) throws SAXException {
        if (!TypeMap.isTypeMap(node)) {
            throw new SAXException("node is not a TypeMap.");
        }
        NamedNodeMap type = node.getAttributes();
        for (int iType = 0; iType < type.getLength(); ++iType) {
            Node nodeType = type.item(iType);
            String strName = nodeType.getNodeName();
            String strValue = nodeType.getNodeValue();
            if (!strName.equalsIgnoreCase("type")) continue;
            this._strGenericType = strValue;
            NodeList listMaps = node.getChildNodes();
            for (int iMap = 0; iMap < listMaps.getLength(); ++iMap) {
                node = listMaps.item(iMap);
                if (!node.getNodeName().equalsIgnoreCase("map")) continue;
                String strDB = null;
                String strMappedType = null;
                NamedNodeMap map = node.getAttributes();
                for (int iAttr = 0; iAttr < map.getLength(); ++iAttr) {
                    node = map.item(iAttr);
                    strName = node.getNodeName();
                    strValue = node.getNodeValue();
                    if (strName.equalsIgnoreCase("db")) {
                        strDB = strValue;
                        continue;
                    }
                    if (strName.equalsIgnoreCase("type")) {
                        strMappedType = strValue;
                        continue;
                    }
                    System.out.println("Unknown attribute '" + node.getNodeName() + "' in tag 'table'");
                }
                this._mapDBType.put(strDB, strMappedType);
            }
        }
    }

    protected boolean contains(String database) {
        return this._mapDBType.contains(database);
    }

    protected String getGenericType() {
        return this._strGenericType;
    }

    public String getMappedType(String type, String database) {
        String strResult = this._strGenericType.equalsIgnoreCase(type) ? (String)this._mapDBType.get(database) : null;
        return strResult;
    }

    protected String getMappedType(String type, int database) {
        return this.getMappedType(type, JDBC.toName((int)database));
    }

    public static String getMappedType(Collection typemaps, String type, int database) {
        return TypeMap.getMappedType(typemaps, type, JDBC.toName((int)database));
    }

    public static String getMappedType(Collection typemaps, String type, String database) {
        TypeMap map;
        Iterator iter = typemaps.iterator();
        String typeName = null;
        while (iter.hasNext() && (typeName = (map = (TypeMap)iter.next()).getMappedType(type, database)) == null) {
        }
        return typeName;
    }

    protected static boolean isTypeMap(Node node) {
        String strTmp = node.getNodeName();
        return strTmp.equalsIgnoreCase("typemap");
    }

    protected static Collection readTypeMaps(Node node) {
        StrongCollection collResult = new StrongCollection("org.hyperic.tools.db.TypeMap");
        NodeList listMaps = node.getChildNodes();
        for (int iMap = 0; iMap < listMaps.getLength(); ++iMap) {
            Node nodeMap = listMaps.item(iMap);
            String strTmp = nodeMap.getNodeName();
            if (!strTmp.equalsIgnoreCase("mapping")) continue;
            NodeList listTypes = nodeMap.getChildNodes();
            for (int iType = 0; iType < listTypes.getLength(); ++iType) {
                try {
                    collResult.add(new TypeMap(listTypes.item(iType)));
                    continue;
                }
                catch (SAXException e) {
                    // empty catch block
                }
            }
        }
        return collResult;
    }

    public static Collection loadTypeMapFromFile(File f) throws IOException, SAXException {
        DBSetup dbsetup = new DBSetup();
        Node typeMapNode = dbsetup.readDocument(f.getAbsolutePath()).getFirstChild();
        Collection tmaps = TypeMap.readTypeMaps(typeMapNode);
        return tmaps;
    }
}

