/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.client;

import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.topology.client.view.ServersView;
import com.vmware.srm.client.topology.client.view.availability.PairSetup;
import com.vmware.vim.sso.client.SamlToken;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;

public interface Topology {
    public <T extends ServersView> T getView();

    public <T extends ServersView> T refresh();

    public <T extends ServersView> Promise<T> authenticate(String var1, String var2);

    public <T extends ServersView> Promise<T> authenticate(SamlToken var1, SamlToken var2);

    public <T extends ServersView> Promise<T> authenticateWithSolutionUser();

    public boolean isAuthenticated();

    public <T extends ServersView> Promise<T> loginPair(PairSetup<?> var1, String var2, String var3) throws LoginFailedException;

    public <T extends ServersView> Promise<T> loginPair(PairSetup<?> var1, X509Certificate var2, PrivateKey var3);

    public static class LoginFailedException
    extends TopologyException {
        private static final long serialVersionUID = 4052524765783325367L;

        public LoginFailedException(Exception cause) {
            super(cause);
        }
    }

    public static class TopologyException
    extends RuntimeException {
        private static final long serialVersionUID = 4337636643204242951L;

        public TopologyException(Throwable cause) {
            this(cause.getLocalizedMessage(), cause);
        }

        public TopologyException(String msg, Throwable cause) {
            super(msg, cause);
        }

        public TopologyException(String msg) {
            this(new SrmRuntimeException(msg));
        }

        static class SrmRuntimeException
        extends RuntimeException {
            private static final long serialVersionUID = -6339564630347486700L;

            SrmRuntimeException(String msg) {
                super(msg);
            }
        }
    }
}

