/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.srm.client.topology.impl.core.mxn.nodes;

import com.vmware.srm.client.reactive.Promise;
import com.vmware.srm.client.topology.client.view.certificate.CertificateValidityInfo;
import com.vmware.srm.client.topology.client.view.vc.VcServer;
import com.vmware.srm.client.topology.client.vmomi.availability.hms.HmsService;
import com.vmware.srm.client.topology.impl.core.engine.Node;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.HmsPairNode;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.NodeContext;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.VmomiExtensionServerNode;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.utils.HmsHelper;
import com.vmware.srm.client.topology.impl.core.mxn.nodes.utils.PairSetupPublisher;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppService;
import com.vmware.srm.client.topology.impl.lspp.monitor.model.LsppServiceEndpoint;
import com.vmware.srm.client.topology.impl.view.ServersViewImpl;
import com.vmware.srm.client.topology.impl.view.availability.hms.HmsPairSetupImpl;
import com.vmware.srm.client.topology.impl.view.availability.hms.HmsServerImpl;
import com.vmware.srm.client.topology.impl.vmomi.TokenProvider;
import com.vmware.srm.client.topology.impl.vmomi.hms.HmsServiceImpl;
import java.net.URI;
import java.security.KeyStore;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HmsNode
extends VmomiExtensionServerNode<HmsServiceImpl, HmsServerImpl> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HmsNode.class);

    HmsNode(LsppService serverRegistration, TokenProvider tokenProvider, boolean local, ServersViewImpl.Publisher publisher, VcServer vcServer) {
        super(serverRegistration, "com.vmware.vim.hms", tokenProvider, local, publisher, vcServer);
    }

    @Override
    HmsServiceImpl createService(URI url, KeyStore ks, TokenProvider tp) {
        return new HmsServiceImpl(url, ks, tp);
    }

    @Override
    protected Promise<Set<? extends Node<NodeContext>>> discoverNeighbours(ServersViewImpl.Publisher publisher, HmsServiceImpl service, HmsServerImpl server) {
        return HmsHelper.getPairInfos((HmsService)this.getService()).thenApply(hmsPairInfos -> {
            LOGGER.trace("HMS '{}' returned HMS pair infos '{}'", (Object)server, hmsPairInfos);
            PairSetupPublisher<HmsPairSetupImpl> hmsPsp = new PairSetupPublisher<HmsPairSetupImpl>(server, hmsPairInfos.size());
            HashSet<HmsPairNode> result = new HashSet<HmsPairNode>();
            for (HmsHelper.PairInfo pi : hmsPairInfos) {
                result.add(new HmsPairNode(server, pi, hmsPsp));
            }
            return result;
        }).onError(exc -> server.complete((Exception)exc));
    }

    @Override
    protected HmsServerImpl createServer(ServersViewImpl view, VcServer vc, HmsServiceImpl service, LsppService serviceReg, LsppServiceEndpoint vmomiEp, List<CertificateValidityInfo> certificateIssues) {
        return new HmsServerImpl(view, vmomiEp.url, (HmsService)this.getService(), this.getServerReg().getId(), this.isLocal(), certificateIssues, vc);
    }
}

